/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.compat;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.client.ClientTeamManager;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import java.util.Optional;
import net.bettercombat.Platform;
import net.bettercombat.logic.TargetHelper;
import net.minecraft.world.entity.player.Player;

public class FTBTeamsCompat {
    public static void init() {
        if (Platform.isModLoaded("ftbteams")) {
            TargetHelper.registerTeamMatcher("ftb", (attack, target) -> {
                if (attack instanceof Player) {
                    Player attackerPlayer = (Player)attack;
                    if (target instanceof Player) {
                        Player targetPlayer = (Player)target;
                        if (attackerPlayer.level().isClientSide()) {
                            return FTBTeamsCompat.checkClientTeamRelation(attackerPlayer, targetPlayer);
                        }
                        return FTBTeamsCompat.checkServerTeamRelation(attackerPlayer, targetPlayer);
                    }
                }
                return null;
            });
        }
    }

    private static TargetHelper.TeamRelation checkClientTeamRelation(Player attackerPlayer, Player targetPlayer) {
        if (!FTBTeamsAPI.api().isClientManagerLoaded()) {
            return null;
        }
        ClientTeamManager manager = FTBTeamsAPI.api().getClientManager();
        Optional attackerKnownPlayerOpt = manager.getKnownPlayer(attackerPlayer.getUUID());
        Optional targetKnownPlayerOpt = manager.getKnownPlayer(targetPlayer.getUUID());
        if (attackerKnownPlayerOpt.isEmpty() || targetKnownPlayerOpt.isEmpty()) {
            return null;
        }
        KnownClientPlayer attackerKnownPlayer = (KnownClientPlayer)attackerKnownPlayerOpt.get();
        KnownClientPlayer targetKnownPlayer = (KnownClientPlayer)targetKnownPlayerOpt.get();
        if (attackerKnownPlayer.teamId().equals(targetKnownPlayer.teamId())) {
            return new TargetHelper.TeamRelation(true, false);
        }
        return null;
    }

    private static TargetHelper.TeamRelation checkServerTeamRelation(Player attackerPlayer, Player targetPlayer) {
        if (!FTBTeamsAPI.api().isManagerLoaded()) {
            return null;
        }
        TeamManager manager = FTBTeamsAPI.api().getManager();
        if (manager.arePlayersInSameTeam(attackerPlayer.getUUID(), targetPlayer.getUUID())) {
            return new TargetHelper.TeamRelation(true, false);
        }
        return null;
    }
}

