/*
 * Decompiled with CFR 0.152.
 */
package net.cloud.betterfog;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.cloud.betterfog.BiomeInfo;
import net.cloud.betterfog.Test;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.lang3.tuple.Pair;

public class BetterFogConfiguration {
    private static final List<String> defaultBiomes = List.of("default", "plains");
    public static boolean usesDefaultBiomes = true;
    private static final List<String> signs = List.of("", "+", "-", "=", "*", "/");
    public static boolean disableForUnconfigured;
    public static int caveYStart;
    public static int caveYEnd;
    public static int caveP;
    public static int cloudYStart;
    public static int cloudYEnd;
    public static int cloudP;
    public static int voidYStart;
    public static int voidYEnd;
    public static int voidP;
    public static int changeTime;
    public static float stepColor;
    public static float stepDistance;
    public static ArrayList<String> dimensionBlacklist;
    private static boolean write;
    public static JsonObject configJson;

    public static JsonObject getDefault() {
        if (configJson != null) {
            JsonObject settings = configJson.get("biomes").getAsJsonObject();
            return settings.get("default").getAsJsonObject();
        }
        return Test.defaultInfo;
    }

    public static boolean genPrimitive(String setting, boolean def) {
        if (!configJson.has(setting) || !configJson.get(setting).isJsonPrimitive()) {
            configJson.addProperty(setting, Boolean.valueOf(def));
            write = true;
            return def;
        }
        return configJson.get(setting).getAsBoolean();
    }

    public static int genPrimitive(String setting, int def) {
        if (!configJson.has(setting) || !configJson.get(setting).isJsonPrimitive()) {
            configJson.addProperty(setting, (Number)def);
            write = true;
            return def;
        }
        return configJson.get(setting).getAsInt();
    }

    public static float genPrimitive(String setting, float def) {
        if (!configJson.has(setting) || !configJson.get(setting).isJsonPrimitive()) {
            configJson.addProperty(setting, (Number)Float.valueOf(def));
            write = true;
            return def;
        }
        return configJson.get(setting).getAsFloat();
    }

    public static ArrayList<String> genArrayString(String setting, ArrayList<String> defList) {
        if (!configJson.has(setting) || !configJson.get(setting).isJsonArray()) {
            JsonArray def = new JsonArray();
            defList.forEach(arg_0 -> ((JsonArray)def).add(arg_0));
            configJson.add(setting, (JsonElement)def);
            write = true;
            return defList;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (JsonElement e : configJson.get(setting).getAsJsonArray()) {
            list.add(e.getAsString());
        }
        return list;
    }

    public static ArrayList<Integer> genArrayInt(String setting, ArrayList<Integer> defList) {
        if (!configJson.has(setting) || !configJson.get(setting).isJsonArray()) {
            JsonArray def = new JsonArray();
            defList.forEach(arg_0 -> ((JsonArray)def).add(arg_0));
            configJson.add(setting, (JsonElement)def);
            write = true;
            return defList;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (JsonElement e : configJson.get(setting).getAsJsonArray()) {
            list.add(e.getAsInt());
        }
        return list;
    }

    public static ArrayList<Float> genArrayFloat(String setting, ArrayList<Float> defList) {
        if (!configJson.has(setting) || !configJson.get(setting).isJsonArray()) {
            JsonArray def = new JsonArray();
            defList.forEach(arg_0 -> ((JsonArray)def).add(arg_0));
            configJson.add(setting, (JsonElement)def);
            write = true;
            return defList;
        }
        ArrayList<Float> list = new ArrayList<Float>();
        for (JsonElement e : configJson.get(setting).getAsJsonArray()) {
            list.add(Float.valueOf(e.getAsFloat()));
        }
        return list;
    }

    public static JsonObject getBiomeInfoJson(String biome) {
        JsonObject settings = configJson.get("biomes").getAsJsonObject();
        if (settings.has(biome)) {
            return settings.get(biome).getAsJsonObject();
        }
        return BetterFogConfiguration.getDefault();
    }

    public static BiomeInfo getBiomeInfo(String biome) {
        return new BiomeInfo(BetterFogConfiguration.getBiomeInfoJson(biome));
    }

    public static void genConfig(String configName) {
        File biomesDir;
        File config;
        block13: {
            config = new File(String.valueOf(Minecraft.getInstance().gameDirectory) + "/config/betterfog/", File.separator + configName + ".json");
            biomesDir = new File(String.valueOf(Minecraft.getInstance().gameDirectory) + "/config/betterfog/biomes/");
            biomesDir.mkdirs();
            try {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(config));
                StringBuilder jsonstringbuilder = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    jsonstringbuilder.append(line);
                }
                bufferedReader.close();
                configJson = (JsonObject)new Gson().fromJson(jsonstringbuilder.toString(), JsonObject.class);
            }
            catch (IOException e) {
                configJson = new JsonObject();
                write = true;
                if (config.exists()) break block13;
                try {
                    config.getParentFile().mkdirs();
                    config.createNewFile();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (configJson == null) {
            configJson = new JsonObject();
        }
        BetterFogConfiguration.genPrimitive("enabled", true);
        BetterFogConfiguration.genPrimitive("day_enabled", true);
        BetterFogConfiguration.genPrimitive("night_enabled", true);
        BetterFogConfiguration.genPrimitive("rain_enabled", true);
        BetterFogConfiguration.genPrimitive("thunder_enabled", true);
        BetterFogConfiguration.genPrimitive("cave_enabled", true);
        BetterFogConfiguration.genPrimitive("cloud_enabled", true);
        BetterFogConfiguration.genPrimitive("void_enabled", true);
        BetterFogConfiguration.genPrimitive("water_enabled", true);
        BetterFogConfiguration.genPrimitive("lava_enabled", true);
        BetterFogConfiguration.genPrimitive("use_vanilla_for_unconfigured", true);
        dimensionBlacklist = BetterFogConfiguration.genArrayString("dimension_blacklist", dimensionBlacklist);
        disableForUnconfigured = BetterFogConfiguration.genPrimitive("use_vanilla_for_unconfigured", false);
        usesDefaultBiomes = BetterFogConfiguration.genPrimitive("use_defaults", false);
        caveYStart = BetterFogConfiguration.genPrimitive("cave_y_start", caveYStart);
        caveYEnd = BetterFogConfiguration.genPrimitive("cave_y_end", caveYEnd);
        caveP = BetterFogConfiguration.genPrimitive("cave_pick", caveP);
        cloudYStart = BetterFogConfiguration.genPrimitive("cloud_y_start", cloudYStart);
        cloudYEnd = BetterFogConfiguration.genPrimitive("cloud_y_end", cloudYEnd);
        cloudP = BetterFogConfiguration.genPrimitive("cloud_pick", cloudP);
        voidYStart = BetterFogConfiguration.genPrimitive("void_y_start", voidYStart);
        voidYEnd = BetterFogConfiguration.genPrimitive("void_y_end", voidYEnd);
        voidP = BetterFogConfiguration.genPrimitive("void_pick", voidP);
        changeTime = BetterFogConfiguration.genPrimitive("change_time", 200);
        stepColor = BetterFogConfiguration.genPrimitive("step_color", stepColor);
        stepDistance = BetterFogConfiguration.genPrimitive("step_distance", stepDistance);
        if (write) {
            Gson mainGSONBuilderVariable = new GsonBuilder().setPrettyPrinting().create();
            try {
                FileWriter fileWriter = new FileWriter(config);
                fileWriter.write(mainGSONBuilderVariable.toJson((JsonElement)configJson));
                fileWriter.close();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        for (String key : BetterFogConfiguration.getDefaultBiomes()) {
            File defBiome = new File(String.valueOf(Minecraft.getInstance().gameDirectory) + "/config/betterfog/biomes/", File.separator + key + ".json");
            if (defBiome.exists()) continue;
            try {
                defBiome.getParentFile().mkdirs();
                defBiome.createNewFile();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        JsonObject biomesJson = new JsonObject();
        for (File biomeFile : biomesDir.listFiles()) {
            String biome = biomeFile.getName().replace(".json", "");
            JsonObject biomeJson = BetterFogConfiguration.fixSettingError(biome, biomeFile);
            biomesJson.add(biome, (JsonElement)biomeJson);
        }
        configJson.add("biomes", (JsonElement)biomesJson);
    }

    public static List<String> getDefaultBiomes() {
        return usesDefaultBiomes ? defaultBiomes : List.of("default");
    }

    private static JsonObject fixSettingError(File file) {
        String biome = file.getName().replace(".json", "");
        return BetterFogConfiguration.fixSettingError(biome, file);
    }

    private static JsonObject fixSettingError(String biome, File file) {
        JsonObject settings;
        boolean write;
        block24: {
            JsonObject ds = BetterFogConfiguration.defaultSetting(biome);
            write = false;
            try {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                StringBuilder jsonstringbuilder = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    jsonstringbuilder.append(line);
                }
                bufferedReader.close();
                JsonElement damagedSettings = (JsonElement)new Gson().fromJson(jsonstringbuilder.toString(), JsonElement.class);
                if (damagedSettings == null || !damagedSettings.isJsonObject() || damagedSettings.getAsJsonObject().keySet().isEmpty()) {
                    settings = ds;
                    settings.remove("template");
                    write = true;
                    break block24;
                }
                settings = damagedSettings.getAsJsonObject();
                for (String key : settings.keySet()) {
                    JsonElement values = settings.get(key);
                    JsonObject dvs = ds.get(key).getAsJsonObject();
                    if (!values.isJsonObject() && !key.contains("template")) {
                        settings.add(key, (JsonElement)dvs);
                        if (write) continue;
                        write = true;
                        continue;
                    }
                    boolean shouldAddVs = false;
                    JsonObject valuesA = values.getAsJsonObject();
                    Set valuesKeys = valuesA.deepCopy().keySet();
                    for (String i : valuesKeys) {
                        if (ds.get("template").getAsJsonObject().has(i)) continue;
                        valuesA.remove(i);
                        shouldAddVs = true;
                    }
                    for (String i : valuesA.keySet()) {
                        float fValue;
                        JsonElement valueE = valuesA.get(i);
                        String dvStr = dvs.has(i) ? dvs.get(i).getAsString() : null;
                        if (!valueE.isJsonPrimitive()) {
                            if (dvStr != null) {
                                valuesA.addProperty(i, dvStr);
                                continue;
                            }
                            valuesA.remove(i);
                            continue;
                        }
                        boolean shouldAddV = false;
                        Object fullValue = valueE.getAsString();
                        String sign = ((String)fullValue).substring(0, 1);
                        String value = fullValue;
                        if (signs.contains(sign)) {
                            value = ((String)fullValue).substring(1);
                        } else {
                            sign = "";
                        }
                        try {
                            fValue = Float.parseFloat(value);
                        }
                        catch (NumberFormatException ignored) {
                            try {
                                String newValue = ((String)fullValue).substring(1);
                                fValue = Float.parseFloat(newValue);
                            }
                            catch (NumberFormatException ignored2) {
                                Pair<String, Float> sv = BetterFogConfiguration.getPairSV(dvStr);
                                sign = sv.getKey() == "=" ? "" : (String)sv.getKey();
                                fValue = ((Float)sv.getValue()).floatValue();
                            }
                            shouldAddV = true;
                        }
                        if ((sign == "=" || sign == "") && (i.contains("red") || i.contains("green") || i.contains("blue") || i.contains("opacity"))) {
                            if (fValue > 1.0f) {
                                shouldAddV = true;
                                fValue = 1.0f;
                            }
                            if (fValue < 0.0f) {
                                shouldAddV = true;
                                fValue = 0.0f;
                            }
                        }
                        fullValue = sign + fValue;
                        if (!shouldAddV) continue;
                        try {
                            valuesA.addProperty(i, (Number)Integer.parseInt((String)fullValue));
                        }
                        catch (NumberFormatException ignored2) {
                            try {
                                valuesA.addProperty(i, (Number)Float.valueOf(Float.parseFloat((String)fullValue)));
                            }
                            catch (NumberFormatException ignored) {
                                valuesA.addProperty(i, (String)fullValue);
                            }
                        }
                        shouldAddVs = true;
                    }
                    if (!shouldAddVs) continue;
                    settings.add(key, (JsonElement)valuesA);
                    write = true;
                }
            }
            catch (IOException e) {
                settings = ds;
                write = true;
            }
        }
        if (write) {
            BetterFogConfiguration.writeJson(file, settings);
        }
        return settings;
    }

    public static void writeJson(File file, JsonObject json) {
        Gson mainGSONBuilderVariable = new GsonBuilder().setPrettyPrinting().create();
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(mainGSONBuilderVariable.toJson((JsonElement)json));
            fileWriter.close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static Pair<String, Float> getPairSV(String value) {
        if (value == null) {
            return Pair.of((Object)"*", (Object)Float.valueOf(1.0f));
        }
        String sign = value.substring(0, 1);
        if (signs.contains(sign)) {
            value = value.substring(1);
        } else {
            sign = "=";
        }
        return Pair.of((Object)sign, (Object)Float.valueOf(Float.parseFloat(value)));
    }

    private static JsonObject defaultSetting(String biome) {
        try {
            InputStream in;
            ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)"betterfog", (String)("default_config/" + biome + ".json"));
            Optional res = Minecraft.getInstance().getResourceManager().getResource(loc);
            if (res.isPresent()) {
                in = ((Resource)res.get()).open();
            } else {
                loc = ResourceLocation.fromNamespaceAndPath((String)"betterfog", (String)"default_config/default.json");
                in = ((Resource)Minecraft.getInstance().getResourceManager().getResource(loc).get()).open();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            JsonElement je = (JsonElement)new Gson().fromJson((Reader)reader, JsonElement.class);
            return je.getAsJsonObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        caveYStart = 64;
        caveYEnd = -32;
        caveP = 6;
        cloudYStart = 192;
        cloudYEnd = 256;
        cloudP = 6;
        voidYStart = -64;
        voidYEnd = -32;
        voidP = 6;
        changeTime = 200;
        stepColor = 0.1f;
        stepDistance = 20.0f;
        dimensionBlacklist = new ArrayList();
        dimensionBlacklist.add("minecraft:the_end");
        dimensionBlacklist.add("minecraft:the_nether");
        write = false;
    }
}

