/*
 * Decompiled with CFR 0.152.
 */
package net.cloud.betterfog;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.cloud.betterfog.BetterFogConfiguration;
import net.cloud.betterfog.BiomeColor;
import net.cloud.betterfog.BiomeInfo;
import net.cloud.betterfog.CustomFogRenderer;
import net.cloud.betterfog.Sigmoid;
import net.cloud.betterfog.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.DimensionSpecialEffectsManager;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@EventBusSubscriber
@OnlyIn(value=Dist.CLIENT)
public class BetterFogProcedure {
    private static Stage _stage = Stage.NONE;
    private static Minecraft _minecraft = null;
    private static ClientLevel _clientLevel = null;
    private static Field _effects = null;
    private static ViewportEvent.RenderFog _fog = null;
    private static ViewportEvent.ComputeFogColor _fogColor = null;
    private static LightTexture _lightTexture = null;
    private static PoseStack _poseStack = null;
    private static Matrix4f _projectionMatrix = null;
    private static float _partialTick = 0.0f;
    private static int _ticks = 0;
    private static Camera _camera = null;
    private static double _camX = 0.0;
    private static double _camY = 0.0;
    private static double _camZ = 0.0;
    private static final Map<String, Object> _PARAMS = new HashMap<String, Object>(){
        {
            this.put("x", 0.0);
            this.put("y", 0.0);
            this.put("z", 0.0);
            this.put("vx", 0.0);
            this.put("vy", 0.0);
            this.put("vz", 0.0);
            this.put("yaw", Float.valueOf(0.0f));
            this.put("pitch", Float.valueOf(0.0f));
            this.put("roll", Float.valueOf(0.0f));
            this.put("width", 21.0);
            this.put("depth", 21.0);
            this.put("height", 21.0);
            this.put("seed", 0);
            this.put("texture", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)""));
            this.put("down", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)""));
            this.put("up", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)""));
            this.put("north", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)""));
            this.put("south", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)""));
            this.put("west", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)""));
            this.put("east", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)""));
            this.put("u0", Float.valueOf(0.0f));
            this.put("v0", Float.valueOf(0.0f));
            this.put("u1", Float.valueOf(1.0f));
            this.put("v1", Float.valueOf(1.0f));
            this.put("size", Float.valueOf(100.0f));
            this.put("weatherEffects", true);
            this.put("particle", ParticleTypes.RAIN);
            this.put("pvx", 0.0);
            this.put("pvy", 0.0);
            this.put("pvz", 0.0);
            this.put("sound", SoundEvents.WEATHER_RAIN);
            this.put("soundSource", SoundSource.WEATHER);
            this.put("soundLevel", Float.valueOf(0.2f));
            this.put("soundPitch", Float.valueOf(1.0f));
            this.put("model", Color.RGBA);
            this.put("red", Float.valueOf(255.0f));
            this.put("green", Float.valueOf(255.0f));
            this.put("blue", Float.valueOf(255.0f));
            this.put("hue", Float.valueOf(0.0f));
            this.put("saturation", Float.valueOf(0.0f));
            this.put("lightness", Float.valueOf(100.0f));
            this.put("alpha", Float.valueOf(100.0f));
        }
    };
    private static long currentTick = 0L;
    private static long biomeTime = 0L;
    private static String biome = "";
    static Color RED = Color.RED;
    static Color GREEN = Color.GREEN;
    static Color BLUE = Color.BLUE;
    static Color ALPHA = Color.ALPHA;
    static Set START = Set.START;
    static Set END = Set.END;
    private static float setRed;
    private static float setGreen;
    private static float setBlue;
    private static float setOpacity;
    private static float setStart;
    private static float setEnd;
    private static float red;
    private static float green;
    private static float blue;
    private static float opacity;
    private static float startfog;
    private static float endfog;
    private static float cloudHalf;
    private static float voidHalf;
    private static Sigmoid caveColorSig;
    private static Sigmoid caveOpacitySig;
    private static Sigmoid cloudSig1;
    private static Sigmoid cloudSig2;
    private static Sigmoid voidSig1;
    private static Sigmoid voidSig2;

    private static Map<String, Object> clone(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static float[] getColor(Map<String, Object> map) {
        Color model = (Color)((Object)map.get("model"));
        float[] result = new float[4];
        if (model == Color.RGBA) {
            result[0] = ((Float)map.get("red")).floatValue() / 255.0f;
            result[1] = ((Float)map.get("green")).floatValue() / 255.0f;
            result[2] = ((Float)map.get("blue")).floatValue() / 255.0f;
        } else if (model == Color.HSLA) {
            float[] color = BetterFogProcedure.HSLtoRGB(map);
            result[0] = color[0];
            result[1] = color[1];
            result[2] = color[2];
        }
        result[3] = ((Float)map.get("alpha")).floatValue() / 100.0f;
        if (result[0] < 0.0f) {
            result[0] = 0.0f;
        } else if (result[0] > 1.0f) {
            result[0] = 1.0f;
        }
        if (result[1] < 0.0f) {
            result[1] = 0.0f;
        } else if (result[1] > 1.0f) {
            result[1] = 1.0f;
        }
        if (result[2] < 0.0f) {
            result[2] = 0.0f;
        } else if (result[2] > 1.0f) {
            result[2] = 1.0f;
        }
        if (result[3] < 0.0f) {
            result[3] = 0.0f;
        } else if (result[3] > 1.0f) {
            result[3] = 1.0f;
        }
        return result;
    }

    private static float[] HSLtoRGB(Map<String, Object> map) {
        float hue = ((Float)map.get("hue")).floatValue();
        float saturation = ((Float)map.get("saturation")).floatValue();
        float lightness = ((Float)map.get("lightness")).floatValue();
        float[] result = new float[3];
        saturation /= 100.0f;
        lightness /= 100.0f;
        if (hue < 0.0f) {
            hue = hue % 360.0f + 360.0f;
        } else if (hue >= 360.0f) {
            hue %= 360.0f;
        }
        if (saturation < 0.0f) {
            saturation = 0.0f;
        } else if (saturation > 1.0f) {
            saturation = 1.0f;
        }
        if (lightness < 0.0f) {
            lightness = 0.0f;
        } else if (lightness > 1.0f) {
            lightness = 1.0f;
        }
        float c = (1.0f - Math.abs(lightness * 2.0f - 1.0f)) * saturation;
        float x = c * (1.0f - Math.abs(hue / 60.0f % 2.0f - 1.0f));
        float m = lightness - c / 2.0f;
        if (hue < 60.0f) {
            result[0] = c;
            result[1] = x;
            result[2] = 0.0f;
        } else if (hue >= 60.0f && hue < 120.0f) {
            result[0] = x;
            result[1] = c;
            result[2] = 0.0f;
        } else if (hue >= 120.0f && hue < 180.0f) {
            result[0] = 0.0f;
            result[1] = c;
            result[2] = x;
        } else if (hue >= 180.0f && hue < 240.0f) {
            result[0] = 0.0f;
            result[1] = x;
            result[2] = c;
        } else if (hue >= 240.0f && hue < 300.0f) {
            result[0] = x;
            result[1] = 0.0f;
            result[2] = c;
        } else if (hue >= 300.0f) {
            result[0] = c;
            result[1] = 0.0f;
            result[2] = x;
        }
        result[0] = result[0] + m;
        result[1] = result[1] + m;
        result[2] = result[2] + m;
        return result;
    }

    private static float[] RGBToHSL(Map<String, Object> map) {
        float red = ((Float)map.get("red")).floatValue() / 255.0f;
        float green = ((Float)map.get("green")).floatValue() / 255.0f;
        float blue = ((Float)map.get("blue")).floatValue() / 255.0f;
        float max = Math.max(red, Math.max(green, blue));
        float min = Math.min(red, Math.min(green, blue));
        float delta = max - min;
        float[] result = new float[3];
        if (max == red) {
            result[0] = 60.0f * ((green - blue) / delta % 6.0f);
        } else if (max == green) {
            result[0] = 60.0f * ((blue - red) / delta + 2.0f);
        } else if (max == blue) {
            result[0] = 60.0f * ((red - green) / delta + 4.0f);
        }
        result[2] = (max + min) / 2.0f;
        if (delta != 0.0f) {
            result[1] = delta / (1.0f - Math.abs(result[2] * 2.0f - 1.0f)) * 100.0f;
        }
        result[2] = result[2] * 100.0f;
        return result;
    }

    private static Map<String, Object> RGBAMap(float[] color) {
        Map<String, Object> result = BetterFogProcedure.clone(_PARAMS);
        result.put("model", (Object)Color.RGBA);
        result.put("red", Float.valueOf(color[0]));
        result.put("green", Float.valueOf(color[1]));
        result.put("blue", Float.valueOf(color[2]));
        result.put("alpha", Float.valueOf(color[3]));
        return result;
    }

    private static Map<String, Object> HSLAMap(float[] color) {
        Map<String, Object> result = BetterFogProcedure.clone(_PARAMS);
        result.put("model", (Object)Color.HSLA);
        result.put("hue", Float.valueOf(color[0]));
        result.put("saturation", Float.valueOf(color[1]));
        result.put("lightness", Float.valueOf(color[2]));
        result.put("alpha", Float.valueOf(color[3]));
        return result;
    }

    private static int[] getTextureSize(Map<String, Object> map) {
        int[] result = new int[2];
        try {
            InputStream stream = Minecraft.getInstance().getResourceManager().open((ResourceLocation)map.get("texture"));
            NativeImage image = NativeImage.read((InputStream)stream);
            result[0] = image.getWidth();
            result[1] = image.getHeight();
            image.close();
        }
        catch (Exception e) {
            result[0] = 0;
            result[1] = 0;
        }
        return result;
    }

    private static Map<String, Object> setTexture(Map<String, Object> map, String id, String path, Direction direction) {
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)id, (String)("textures/" + path));
        if (direction == null) {
            map.put("texture", texture);
        } else if (direction == Direction.DOWN) {
            map.put("down", texture);
        } else if (direction == Direction.UP) {
            map.put("up", texture);
        } else if (direction == Direction.NORTH) {
            map.put("north", texture);
        } else if (direction == Direction.SOUTH) {
            map.put("south", texture);
        } else if (direction == Direction.WEST) {
            map.put("west", texture);
        } else if (direction == Direction.EAST) {
            map.put("east", texture);
        }
        return map;
    }

    private static boolean renderable(Stage stage) {
        boolean result = false;
        if (_stage == stage) {
            result = true;
        }
        return result;
    }

    private static boolean isBrightLight(ResourceKey<Level> dimension) {
        DimensionSpecialEffects effects = DimensionSpecialEffectsManager.getForType((ResourceLocation)dimension.location());
        return effects.forceBrightLightmap();
    }

    private static float getDayLevel() {
        return _clientLevel.getTimeOfDay(_partialTick);
    }

    private static float getRainLevel() {
        return _clientLevel.getRainLevel(_partialTick);
    }

    private static float getThunderLevel() {
        return _clientLevel.getThunderLevel(_partialTick);
    }

    private static boolean rainnable(double x, double y, double z) {
        ClientLevel level = _clientLevel;
        int xi = (int)Math.floor(x);
        int yi = (int)Math.floor(y);
        int zi = (int)Math.floor(z);
        BlockPos pos = new BlockPos(xi, yi, zi);
        Biome biome = (Biome)level.getBiome(pos).value();
        boolean result = false;
        result = biome.getPrecipitationAt(pos) != Biome.Precipitation.NONE;
        result = result && biome.warmEnoughToRain(pos);
        return result;
    }

    private static boolean snowable(double x, double y, double z) {
        ClientLevel level = _clientLevel;
        int xi = (int)Math.floor(x);
        int yi = (int)Math.floor(y);
        int zi = (int)Math.floor(z);
        BlockPos pos = new BlockPos(xi, yi, zi);
        Biome biome = (Biome)level.getBiome(pos).value();
        boolean result = false;
        result = biome.getPrecipitationAt(pos) != Biome.Precipitation.NONE;
        result = result && biome.coldEnoughToSnow(pos);
        return result;
    }

    private static int getWorldHeight(double x, double z) {
        ClientLevel level = _clientLevel;
        int xi = (int)Math.floor(x);
        int zi = (int)Math.floor(z);
        return level.getHeight(Heightmap.Types.MOTION_BLOCKING, xi, zi);
    }

    private static double getCloudPosition(ResourceKey<Level> dimension, Set component) {
        double result = 0.0;
        if (component == Set.Y) {
            DimensionSpecialEffects effects = DimensionSpecialEffectsManager.getForType((ResourceLocation)dimension.location());
            result = effects.getCloudHeight();
            result = Double.isNaN(result) ? 0.0 : (result += 0.33);
        } else if (component == Set.Z) {
            result = -3.9625;
        }
        return result;
    }

    private static float getCloudColor(Color component) {
        Vector3f RGB = new Vector3f(_clientLevel.getCloudColor(_partialTick));
        float result = 0.0f;
        if (component == Color.RED || component == Color.GREEN || component == Color.BLUE) {
            if (component == Color.RED) {
                result = RGB.x() * 255.0f;
            } else if (component == Color.GREEN) {
                result = RGB.y() * 255.0f;
            } else if (component == Color.BLUE) {
                result = RGB.z() * 255.0f;
            }
        } else if (component == Color.HUE || component == Color.SATURATION || component == Color.LIGHTNESS) {
            float[] HSLA = BetterFogProcedure.RGBToHSL(BetterFogProcedure.RGBAMap(new float[]{RGB.x() * 255.0f, RGB.y() * 255.0f, RGB.z() * 255.0f, 100.0f}));
            if (component == Color.HUE) {
                result = HSLA[0];
            } else if (component == Color.SATURATION) {
                result = HSLA[1];
            } else if (component == Color.LIGHTNESS) {
                result = HSLA[2];
            }
        } else if (component == Color.ALPHA) {
            result = 80.0f;
        }
        return result;
    }

    private static float getSkyColor(Color component) {
        Vector3f RGB = new Vector3f(_clientLevel.getSkyColor(_camera.getPosition(), _partialTick));
        float result = 0.0f;
        if (component == Color.RED || component == Color.GREEN || component == Color.BLUE) {
            if (component == Color.RED) {
                result = RGB.x() * 255.0f;
            } else if (component == Color.GREEN) {
                result = RGB.y() * 255.0f;
            } else if (component == Color.BLUE) {
                result = RGB.z() * 255.0f;
            }
        } else if (component == Color.HUE || component == Color.SATURATION || component == Color.LIGHTNESS) {
            float[] HSLA = BetterFogProcedure.RGBToHSL(BetterFogProcedure.RGBAMap(new float[]{RGB.x() * 255.0f, RGB.y() * 255.0f, RGB.z() * 255.0f, 100.0f}));
            if (component == Color.HUE) {
                result = HSLA[0];
            } else if (component == Color.SATURATION) {
                result = HSLA[1];
            } else if (component == Color.LIGHTNESS) {
                result = HSLA[2];
            }
        } else if (component == Color.ALPHA) {
            result = 100.0f;
        }
        return result;
    }

    private static float getSunlightColor(Color component) {
        float[] RGBA = _clientLevel.effects().getSunriseColor(BetterFogProcedure.getDayLevel(), _partialTick);
        float result = 0.0f;
        if (RGBA != null) {
            if (component == Color.RED || component == Color.GREEN || component == Color.BLUE) {
                if (component == Color.RED) {
                    result = RGBA[0] * 255.0f;
                } else if (component == Color.GREEN) {
                    result = RGBA[1] * 255.0f;
                } else if (component == Color.BLUE) {
                    result = RGBA[2] * 255.0f;
                }
            } else if (component == Color.HUE || component == Color.SATURATION || component == Color.LIGHTNESS) {
                float[] HSLA = BetterFogProcedure.RGBToHSL(BetterFogProcedure.RGBAMap(new float[]{RGBA[0] * 255.0f, RGBA[1] * 255.0f, RGBA[2] * 255.0f, RGBA[3] * 100.0f}));
                if (component == Color.HUE) {
                    result = HSLA[0];
                } else if (component == Color.SATURATION) {
                    result = HSLA[1];
                } else if (component == Color.LIGHTNESS) {
                    result = HSLA[2];
                }
            } else if (component == Color.ALPHA) {
                result = RGBA[3] * 100.0f;
            }
        }
        return result;
    }

    private static float getStarColor(Color component) {
        float rainLevel = 1.0f - BetterFogProcedure.getRainLevel();
        float color = _clientLevel.getStarBrightness(_partialTick) * rainLevel;
        float result = 0.0f;
        if (component == Color.RED || component == Color.GREEN || component == Color.BLUE) {
            result = color * 255.0f;
        } else if (component == Color.HUE || component == Color.SATURATION || component == Color.LIGHTNESS) {
            float[] HSLA = BetterFogProcedure.RGBToHSL(BetterFogProcedure.RGBAMap(new float[]{color * 255.0f, color * 255.0f, color * 255.0f, color * 100.0f}));
            if (component == Color.HUE) {
                result = HSLA[0];
            } else if (component == Color.SATURATION) {
                result = HSLA[1];
            } else if (component == Color.LIGHTNESS) {
                result = HSLA[2];
            }
        } else if (component == Color.ALPHA) {
            result = color * 100.0f;
        }
        return result;
    }

    private static boolean isShelter(double x, double y, double z) {
        RandomSource random = RandomSource.create();
        double d0 = BetterFogProcedure.getWorldHeight(x, z);
        double rx = x + random.nextDouble() * 20.0 - 10.0;
        double rz = z + random.nextDouble() * 20.0 - 10.0;
        double d1 = BetterFogProcedure.getWorldHeight(rx, rz);
        boolean result = false;
        if (y < d0 && y + 2.0 < d1) {
            result = true;
        }
        return result;
    }

    private static double getWeatherWDH() {
        double result = 0.0;
        result = Minecraft.useFancyGraphics() ? 21.0 : 11.0;
        return result;
    }

    private static List<Vec3> getWeatherArea(Map<String, Object> map) {
        ClientLevel level = _clientLevel;
        ArrayList<Vec3> pos = new ArrayList<Vec3>();
        int width = (int)Math.floor((Double)map.get("width"));
        int min0 = (int)(-Math.floor((double)width / 2.0));
        int max0 = min0 + width - 1;
        double height = (Double)map.get("height");
        int depth = (int)Math.floor((Double)map.get("depth"));
        int min1 = (int)(-Math.floor((double)depth / 2.0));
        int max1 = min1 + depth - 1;
        double x = Math.floor((Double)map.get("x"));
        double y = (Double)map.get("y") - Math.floor(height / 2.0);
        double z = Math.floor((Double)map.get("z"));
        for (int i = min0; i <= max0; ++i) {
            for (int j = min1; j <= max1; ++j) {
                if (i == 0 && j == 0) continue;
                double sqx = x + (double)i;
                double sqy = y;
                double sqz = z + (double)j;
                pos.add(new Vec3(sqx + 0.5, sqy, sqz + 0.5));
            }
        }
        return pos;
    }

    private static float getFogDistance(Set type) {
        float result = 0.0f;
        if (type == Set.START) {
            result = RenderSystem.getShaderFogStart();
        } else if (type == Set.END) {
            result = RenderSystem.getShaderFogEnd();
        }
        return result;
    }

    private static float getFogColor(Color component) {
        float result = 0.0f;
        FogRenderer.levelFogColor();
        float[] RGBA = RenderSystem.getShaderFogColor();
        if (component == Color.RED || component == Color.GREEN || component == Color.BLUE) {
            result = component == Color.RED ? RGBA[0] * 255.0f : (component == Color.GREEN ? RGBA[1] * 255.0f : RGBA[2] * 255.0f);
        } else if (component == Color.HUE || component == Color.SATURATION || component == Color.LIGHTNESS) {
            float[] HSLA = BetterFogProcedure.RGBToHSL(BetterFogProcedure.RGBAMap(new float[]{RGBA[0] * 255.0f, RGBA[1] * 255.0f, RGBA[2] * 255.0f, 100.0f}));
            result = component == Color.HUE ? HSLA[0] : (component == Color.SATURATION ? HSLA[1] : HSLA[2]);
        } else if (component == Color.ALPHA) {
            result = 100.0f;
        }
        return result;
    }

    private static void renderClouds(Map<String, Object> map, Set type, double dx, double dz) {
        if (BetterFogProcedure.renderable(Stage.CLOUDS)) {
            int[] size;
            CloudStatus cloudsType = BetterFogProcedure._minecraft.options.getCloudsType();
            float[] color = BetterFogProcedure.getColor(map);
            float red = color[0];
            float green = color[1];
            float blue = color[2];
            float alpha = color[3];
            boolean b0 = true;
            if (type == Set.NONE && cloudsType == CloudStatus.OFF) {
                b0 = false;
            }
            if ((size = BetterFogProcedure.getTextureSize(map))[0] == 0 || size[1] == 0) {
                b0 = false;
            }
            if (dx <= 0.0 || dz <= 0.0) {
                b0 = false;
            }
            float width = (float)((Double)map.get("width")).doubleValue();
            float height = (float)((Double)map.get("height")).doubleValue();
            float depth = (float)((Double)map.get("depth")).doubleValue();
            if (width <= 0.0f || height < 0.0f || depth <= 0.0f) {
                b0 = false;
            }
            if (b0 && alpha > 0.0f) {
                double x = (Double)map.get("x");
                double y = (Double)map.get("y");
                double z = (Double)map.get("z");
                double vx = (Double)map.get("vx");
                double vy = (Double)map.get("vy");
                double vz = (Double)map.get("vz");
                double d0 = (double)((float)_ticks + _partialTick) * 0.03;
                float lx = (float)((x - _camX + d0 * vx) % (double)(width * (float)size[0]));
                float ly = (float)(y - _camY);
                float lz = (float)((z - _camZ + d0 * vz) % (double)(depth * (float)size[1]));
                float f0 = 1.0f / width / (float)size[0];
                float f1 = 1.0f / depth / (float)size[1];
                float u = -lx * f0;
                float v = -lz * f1;
                int dxi = (int)Math.floor(dx);
                int dzi = (int)Math.floor(dz);
                int qx = 0;
                int qz = 0;
                boolean b1 = false;
                if (type == Set.NONE) {
                    if (cloudsType == CloudStatus.FANCY) {
                        b1 = true;
                    }
                } else if (type == Set.FANCY) {
                    b1 = true;
                }
                RenderSystem.disableCull();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)((ResourceLocation)map.get("texture")));
                BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR_NORMAL);
                if (b1) {
                    float f7;
                    float f6;
                    float f5;
                    float f4;
                    int j;
                    int i;
                    int i0 = (int)Math.floor((float)dxi / width) + 2;
                    int i1 = (int)Math.floor((float)dzi / depth) + 2;
                    f2 = lx % width;
                    float f3 = lz % depth;
                    qx = dxi / 48;
                    qz = dzi / 48;
                    if (qx < 10) {
                        qx = 10;
                    }
                    if (qz < 10) {
                        qz = 10;
                    }
                    float red0 = red * 0.9f;
                    float green0 = green * 0.9f;
                    float blue0 = blue * 0.9f;
                    float red1 = red * 0.8f;
                    float green1 = green * 0.8f;
                    float blue1 = blue * 0.8f;
                    float red2 = red * 0.7f;
                    float green2 = green * 0.7f;
                    float blue2 = blue * 0.7f;
                    for (i = 0; i < qx; ++i) {
                        for (j = 0; j < qz; ++j) {
                            f4 = (float)(-dxi) + (float)i / (float)qx * (float)dxi * 2.0f;
                            f5 = (float)(-dxi) + (float)(i + 1) / (float)qx * (float)dxi * 2.0f;
                            f6 = (float)(-dzi) + (float)j / (float)qz * (float)dzi * 2.0f;
                            f7 = (float)(-dzi) + (float)(j + 1) / (float)qz * (float)dzi * 2.0f;
                            if (ly <= 1.0f) {
                                bufferBuilder.addVertex(f4, ly + height, f7).setUv(u + f4 * f0, v + f7 * f1).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
                                bufferBuilder.addVertex(f5, ly + height, f7).setUv(u + f5 * f0, v + f7 * f1).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
                                bufferBuilder.addVertex(f5, ly + height, f6).setUv(u + f5 * f0, v + f6 * f1).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
                                bufferBuilder.addVertex(f4, ly + height, f6).setUv(u + f4 * f0, v + f6 * f1).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
                            }
                            if (!(ly >= -height - 1.0f)) continue;
                            bufferBuilder.addVertex(f4, ly, f7).setUv(u + f4 * f0, v + f7 * f1).setColor(red2, green2, blue2, alpha).setNormal(0.0f, -1.0f, 0.0f);
                            bufferBuilder.addVertex(f5, ly, f7).setUv(u + f5 * f0, v + f7 * f1).setColor(red2, green2, blue2, alpha).setNormal(0.0f, -1.0f, 0.0f);
                            bufferBuilder.addVertex(f5, ly, f6).setUv(u + f5 * f0, v + f6 * f1).setColor(red2, green2, blue2, alpha).setNormal(0.0f, -1.0f, 0.0f);
                            bufferBuilder.addVertex(f4, ly, f6).setUv(u + f4 * f0, v + f6 * f1).setColor(red2, green2, blue2, alpha).setNormal(0.0f, -1.0f, 0.0f);
                        }
                    }
                    if (height > 0.0f) {
                        float f8;
                        for (i = -i0; i < i0; ++i) {
                            for (j = 0; j < qz; ++j) {
                                f4 = (float)i * width + f2;
                                f5 = (float)i * width + width + f2;
                                f6 = (float)i * width + width / 2.0f + f2;
                                f7 = (float)(-dzi) + (float)(j + 1) / (float)qz * (float)dzi * 2.0f;
                                f8 = (float)(-dzi) + (float)j / (float)qz * (float)dzi * 2.0f;
                                if (f4 >= (float)(-dxi) && f4 <= (float)dxi) {
                                    bufferBuilder.addVertex(f4, ly, f7).setUv(u + f6 * f0, v + f7 * f1).setColor(red0, green0, blue0, alpha).setNormal(-1.0f, 0.0f, 0.0f);
                                    bufferBuilder.addVertex(f4, ly + height, f7).setUv(u + f6 * f0, v + f7 * f1).setColor(red0, green0, blue0, alpha).setNormal(-1.0f, 0.0f, 0.0f);
                                    bufferBuilder.addVertex(f4, ly + height, f8).setUv(u + f6 * f0, v + f8 * f1).setColor(red0, green0, blue0, alpha).setNormal(-1.0f, 0.0f, 0.0f);
                                    bufferBuilder.addVertex(f4, ly, f8).setUv(u + f6 * f0, v + f8 * f1).setColor(red0, green0, blue0, alpha).setNormal(-1.0f, 0.0f, 0.0f);
                                }
                                if (!(f5 >= (float)(-dxi)) || !(f5 <= (float)dxi)) continue;
                                bufferBuilder.addVertex(f5, ly, f7).setUv(u + f6 * f0, v + f7 * f1).setColor(red0, green0, blue0, alpha).setNormal(1.0f, 0.0f, 0.0f);
                                bufferBuilder.addVertex(f5, ly + height, f7).setUv(u + f6 * f0, v + f7 * f1).setColor(red0, green0, blue0, alpha).setNormal(1.0f, 0.0f, 0.0f);
                                bufferBuilder.addVertex(f5, ly + height, f8).setUv(u + f6 * f0, v + f8 * f1).setColor(red0, green0, blue0, alpha).setNormal(1.0f, 0.0f, 0.0f);
                                bufferBuilder.addVertex(f5, ly, f8).setUv(u + f6 * f0, v + f8 * f1).setColor(red0, green0, blue0, alpha).setNormal(1.0f, 0.0f, 0.0f);
                            }
                        }
                        for (i = -i1; i < i1; ++i) {
                            for (j = 0; j < qx; ++j) {
                                f4 = (float)i * depth + f3;
                                f5 = (float)i * depth + depth + f3;
                                f6 = (float)i * depth + depth / 2.0f + f3;
                                f7 = (float)(-dxi) + (float)j / (float)qx * (float)dxi * 2.0f;
                                f8 = (float)(-dxi) + (float)(j + 1) / (float)qx * (float)dxi * 2.0f;
                                if (f4 >= (float)(-dzi) && f4 <= (float)dzi) {
                                    bufferBuilder.addVertex(f7, ly + height, f4).setUv(u + f7 * f0, v + f6 * f1).setColor(red1, green1, blue1, alpha).setNormal(0.0f, 0.0f, -1.0f);
                                    bufferBuilder.addVertex(f8, ly + height, f4).setUv(u + f8 * f0, v + f6 * f1).setColor(red1, green1, blue1, alpha).setNormal(0.0f, 0.0f, -1.0f);
                                    bufferBuilder.addVertex(f8, ly, f4).setUv(u + f8 * f0, v + f6 * f1).setColor(red1, green1, blue1, alpha).setNormal(0.0f, 0.0f, -1.0f);
                                    bufferBuilder.addVertex(f7, ly, f4).setUv(u + f7 * f0, v + f6 * f1).setColor(red1, green1, blue1, alpha).setNormal(0.0f, 0.0f, -1.0f);
                                }
                                if (!(f5 >= (float)(-dzi)) || !(f5 <= (float)dzi)) continue;
                                bufferBuilder.addVertex(f7, ly + height, f5).setUv(u + f7 * f0, v + f6 * f1).setColor(red1, green1, blue1, alpha).setNormal(0.0f, 0.0f, 1.0f);
                                bufferBuilder.addVertex(f8, ly + height, f5).setUv(u + f8 * f0, v + f6 * f1).setColor(red1, green1, blue1, alpha).setNormal(0.0f, 0.0f, 1.0f);
                                bufferBuilder.addVertex(f8, ly, f5).setUv(u + f8 * f0, v + f6 * f1).setColor(red1, green1, blue1, alpha).setNormal(0.0f, 0.0f, 1.0f);
                                bufferBuilder.addVertex(f7, ly, f5).setUv(u + f7 * f0, v + f6 * f1).setColor(red1, green1, blue1, alpha).setNormal(0.0f, 0.0f, 1.0f);
                            }
                        }
                    }
                } else {
                    qx = dxi / 240;
                    qz = dzi / 240;
                    if (qx < 2) {
                        qx = 2;
                    }
                    if (qz < 2) {
                        qz = 2;
                    }
                    for (int i = 0; i < qx; ++i) {
                        for (int j = 0; j < qz; ++j) {
                            f2 = (float)(-dxi) + (float)i / (float)qx * (float)dxi * 2.0f;
                            float f3 = (float)(-dxi) + (float)(i + 1) / (float)qx * (float)dxi * 2.0f;
                            float f4 = (float)(-dzi) + (float)j / (float)qz * (float)dzi * 2.0f;
                            float f5 = (float)(-dzi) + (float)(j + 1) / (float)qz * (float)dzi * 2.0f;
                            bufferBuilder.addVertex(f2, ly, f5).setUv(u + f2 * f0, v + f5 * f1).setColor(red, green, blue, alpha).setNormal(0.0f, -1.0f, 0.0f);
                            bufferBuilder.addVertex(f3, ly, f5).setUv(u + f3 * f0, v + f5 * f1).setColor(red, green, blue, alpha).setNormal(0.0f, -1.0f, 0.0f);
                            bufferBuilder.addVertex(f3, ly, f4).setUv(u + f3 * f0, v + f4 * f1).setColor(red, green, blue, alpha).setNormal(0.0f, -1.0f, 0.0f);
                            bufferBuilder.addVertex(f2, ly, f4).setUv(u + f2 * f0, v + f4 * f1).setColor(red, green, blue, alpha).setNormal(0.0f, -1.0f, 0.0f);
                        }
                    }
                }
                VertexBuffer cloudBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
                cloudBuffer.bind();
                cloudBuffer.upload(bufferBuilder.build());
                Matrix4f matrix4f = _poseStack.last().pose();
                ShaderInstance shaderInstance = RenderSystem.getShader();
                if (b1) {
                    RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    cloudBuffer.drawWithShader(matrix4f, _projectionMatrix, shaderInstance);
                    RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    cloudBuffer.drawWithShader(matrix4f, _projectionMatrix, shaderInstance);
                } else {
                    RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    cloudBuffer.drawWithShader(matrix4f, _projectionMatrix, shaderInstance);
                }
                cloudBuffer.close();
                RenderSystem.disableBlend();
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableCull();
            }
        }
    }

    private static void renderSkyBox(Map<String, Object> map, boolean single) {
        if (BetterFogProcedure.renderable(Stage.SKY)) {
            float[] color = BetterFogProcedure.getColor(map);
            float red = color[0];
            float green = color[1];
            float blue = color[2];
            float alpha = color[3];
            if (alpha > 0.0f) {
                ResourceLocation texture = (ResourceLocation)map.get("texture");
                float u0 = ((Float)map.get("u0")).floatValue();
                float v0 = ((Float)map.get("v0")).floatValue();
                float u1 = ((Float)map.get("u1")).floatValue();
                float v1 = ((Float)map.get("v1")).floatValue();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
                for (int i = 0; i < 6; ++i) {
                    if (!single) {
                        if (i == 0) {
                            texture = (ResourceLocation)map.get("down");
                        } else if (i == 1) {
                            texture = (ResourceLocation)map.get("up");
                        } else if (i == 2) {
                            texture = (ResourceLocation)map.get("north");
                        } else if (i == 3) {
                            texture = (ResourceLocation)map.get("east");
                        } else if (i == 4) {
                            texture = (ResourceLocation)map.get("south");
                        } else if (i == 5) {
                            texture = (ResourceLocation)map.get("west");
                        }
                    }
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
                    _poseStack.pushPose();
                    _poseStack.mulPose(Vector3f.ZP.rotationDegrees(((Float)map.get("yaw")).floatValue()));
                    _poseStack.mulPose(Vector3f.XP.rotationDegrees(((Float)map.get("pitch")).floatValue()));
                    _poseStack.mulPose(Vector3f.YP.rotationDegrees(((Float)map.get("roll")).floatValue()));
                    if (i == 0) {
                        _poseStack.mulPose(Vector3f.YP.rotationDegrees(180.0f));
                    } else if (i == 1) {
                        _poseStack.mulPose(Vector3f.XP.rotationDegrees(180.0f));
                        _poseStack.mulPose(Vector3f.YP.rotationDegrees(180.0f));
                    } else if (i == 2) {
                        _poseStack.mulPose(Vector3f.XP.rotationDegrees(90.0f));
                    } else if (i == 3) {
                        _poseStack.mulPose(Vector3f.XP.rotationDegrees(90.0f));
                        _poseStack.mulPose(Vector3f.ZP.rotationDegrees(-90.0f));
                    } else if (i == 4) {
                        _poseStack.mulPose(Vector3f.XP.rotationDegrees(90.0f));
                        _poseStack.mulPose(Vector3f.ZP.rotationDegrees(-180.0f));
                    } else if (i == 5) {
                        _poseStack.mulPose(Vector3f.XP.rotationDegrees(90.0f));
                        _poseStack.mulPose(Vector3f.ZP.rotationDegrees(-270.0f));
                    }
                    Matrix4f matrix4f = _poseStack.last().pose();
                    BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                    bufferBuilder.addVertex(matrix4f, -100.0f, -100.0f, -100.0f).setUv(u0, v0);
                    bufferBuilder.addVertex(matrix4f, -100.0f, -100.0f, 100.0f).setUv(u0, v1);
                    bufferBuilder.addVertex(matrix4f, 100.0f, -100.0f, 100.0f).setUv(u1, v1);
                    bufferBuilder.addVertex(matrix4f, 100.0f, -100.0f, -100.0f).setUv(u1, v0);
                    BufferUploader.drawWithShader((MeshData)bufferBuilder.build());
                    _poseStack.popPose();
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
            }
        }
    }

    private static void renderPolygon(Map<String, Object> map, int vertex) {
        if (BetterFogProcedure.renderable(Stage.SKY)) {
            float[] color = BetterFogProcedure.getColor(map);
            float red = color[0];
            float green = color[1];
            float blue = color[2];
            float alpha = color[3];
            if (vertex >= 2 && alpha > 0.0f) {
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShader(GameRenderer::getPositionShader);
                RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
                _poseStack.pushPose();
                _poseStack.mulPose(Vector3f.XP.rotationDegrees(90.0f));
                _poseStack.mulPose(Vector3f.ZP.rotationDegrees(((Float)map.get("yaw")).floatValue()));
                _poseStack.mulPose(Vector3f.XP.rotationDegrees(((Float)map.get("pitch")).floatValue()));
                _poseStack.mulPose(Vector3f.YP.rotationDegrees(((Float)map.get("roll")).floatValue()));
                Matrix4f matrix4f = _poseStack.last().pose();
                BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
                bufferBuilder.addVertex(matrix4f, 0.0f, 16.0f, 0.0f);
                float size = ((Float)map.get("size")).floatValue() * 5.12f;
                float deg = 360.0f / (float)vertex;
                for (int i = 0; i <= vertex; ++i) {
                    bufferBuilder.addVertex(matrix4f, size * Mth.cos((float)(deg * (float)i * ((float)Math.PI / 180))), 16.0f, size * Mth.sin((float)(deg * (float)i * ((float)Math.PI / 180))));
                }
                BufferUploader.drawWithShader((MeshData)bufferBuilder.build());
                _poseStack.popPose();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
            }
        }
    }

    private static void renderSunlights(Map<String, Object> map) {
        float[] sunlightColor;
        if (BetterFogProcedure.renderable(Stage.SKY) && (sunlightColor = _clientLevel.effects().getSunriseColor(BetterFogProcedure.getDayLevel(), _partialTick)) != null) {
            float[] color = BetterFogProcedure.getColor(map);
            float red = color[0];
            float green = color[1];
            float blue = color[2];
            float alpha = color[3] * sunlightColor[3];
            if (alpha > 0.0f) {
                double d0 = Math.sin(_clientLevel.getSunAngle(_partialTick));
                float angle = 90.0f;
                if (d0 < 0.0) {
                    angle = 270.0f;
                }
                float f1 = ((Float)map.get("size")).floatValue() * 0.4f;
                float f2 = f1 * 3.0f;
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                _poseStack.pushPose();
                _poseStack.mulPose(Vector3f.XP.rotationDegrees(90.0f));
                _poseStack.mulPose(Vector3f.ZP.rotationDegrees(((Float)map.get("yaw")).floatValue() + angle));
                _poseStack.mulPose(Vector3f.XP.rotationDegrees(((Float)map.get("pitch")).floatValue()));
                _poseStack.mulPose(Vector3f.YP.rotationDegrees(((Float)map.get("roll")).floatValue()));
                Matrix4f matrix4f = _poseStack.last().pose();
                BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                bufferBuilder.addVertex(matrix4f, 0.0f, 100.0f, 0.0f).setColor(red, green, blue, alpha);
                for (int i = 0; i <= 16; ++i) {
                    float radian = (float)i * ((float)Math.PI * 2) / 16.0f;
                    float sin = Mth.sin((float)radian);
                    float cos = Mth.cos((float)radian);
                    bufferBuilder.addVertex(matrix4f, sin * f2, cos * f2, -cos * f1 * alpha).setColor(red, green, blue, 0.0f);
                }
                BufferUploader.drawWithShader((MeshData)bufferBuilder.build());
                _poseStack.popPose();
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
            }
        }
    }

    private static void renderStars(Map<String, Object> map, int amount, int seed) {
        if (BetterFogProcedure.renderable(Stage.SKY)) {
            float[] color = BetterFogProcedure.getColor(map);
            float red = color[0];
            float green = color[1];
            float blue = color[2];
            float alpha = color[3];
            if (((Boolean)map.get("weatherEffects")).booleanValue()) {
                alpha *= 1.0f - BetterFogProcedure.getRainLevel();
            }
            if (amount > 0 && alpha > 0.0f) {
                RandomSource random = RandomSource.create((long)seed);
                float start = RenderSystem.getShaderFogStart();
                RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShader(GameRenderer::getPositionShader);
                RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
                _poseStack.pushPose();
                _poseStack.mulPose(Vector3f.XP.rotationDegrees(90.0f));
                _poseStack.mulPose(Vector3f.ZP.rotationDegrees(((Float)map.get("yaw")).floatValue()));
                _poseStack.mulPose(Vector3f.XP.rotationDegrees(((Float)map.get("pitch")).floatValue()));
                _poseStack.mulPose(Vector3f.YP.rotationDegrees(((Float)map.get("roll")).floatValue()));
                Matrix4f matrix4f = _poseStack.last().pose();
                BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
                for (int i = 0; i < amount; ++i) {
                    float z0;
                    float y0;
                    float x0 = random.nextFloat() * 2.0f - 1.0f;
                    float distance = x0 * x0 + (y0 = random.nextFloat() * 2.0f - 1.0f) * y0 + (z0 = random.nextFloat() * 2.0f - 1.0f) * z0;
                    if (!(distance < 1.0f) || !(distance > 0.01f)) continue;
                    distance = 1.0f / Mth.sqrt((float)distance);
                    float x1 = (x0 *= distance) * 100.0f;
                    float y1 = (y0 *= distance) * 100.0f;
                    float z1 = (z0 *= distance) * 100.0f;
                    float f0 = (float)Math.atan2(x0, z0);
                    float sin0 = Mth.sin((float)f0);
                    float cos0 = Mth.cos((float)f0);
                    float f1 = (float)Math.atan2(Mth.sqrt((float)(x0 * x0 + z0 * z0)), y0);
                    float sin1 = Mth.sin((float)f1);
                    float cos1 = Mth.cos((float)f1);
                    float f2 = random.nextFloat() * (float)Math.PI * 2.0f;
                    float sin2 = Mth.sin((float)f2);
                    float cos2 = Mth.cos((float)f2);
                    float f3 = 0.15f + random.nextFloat() * 0.1f;
                    for (int j = 0; j < 4; ++j) {
                        float f4 = (float)((j & 2) - 1) * f3;
                        float f5 = (float)((j + 1 & 2) - 1) * f3;
                        float f6 = f4 * cos2 - f5 * sin2;
                        float f7 = f5 * cos2 + f4 * sin2;
                        float f8 = f6 * sin1;
                        float f9 = f6 * -cos1;
                        float f10 = f9 * sin0 - f7 * cos0;
                        float f11 = f7 * sin0 + f9 * cos0;
                        bufferBuilder.addVertex(matrix4f, x1 + f10, y1 + f8, z1 + f11);
                    }
                }
                BufferUploader.drawWithShader((MeshData)bufferBuilder.build());
                _poseStack.popPose();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.setShaderFogStart((float)start);
            }
        }
    }

    private static void renderTexture(Map<String, Object> map, Set type, boolean specialBlends) {
        if (BetterFogProcedure.renderable(Stage.SKY)) {
            float[] color = BetterFogProcedure.getColor(map);
            float red = color[0];
            float green = color[1];
            float blue = color[2];
            float alpha = color[3];
            if (((Boolean)map.get("weatherEffects")).booleanValue()) {
                alpha *= 1.0f - _clientLevel.getRainLevel(_partialTick);
            }
            if (alpha > 0.0f) {
                float u0 = ((Float)map.get("u0")).floatValue();
                float v0 = ((Float)map.get("v0")).floatValue();
                float u1 = ((Float)map.get("u1")).floatValue();
                float v1 = ((Float)map.get("v1")).floatValue();
                if (type == Set.SUN) {
                    u0 = 0.0f;
                    v0 = 0.0f;
                    u1 = 1.0f;
                    v1 = 1.0f;
                } else if (type == Set.MOON) {
                    int phase = _clientLevel.getMoonPhase();
                    int i0 = phase % 4;
                    int i1 = phase / 4 % 2;
                    u0 = (float)i0 / 4.0f;
                    v0 = (float)i1 / 2.0f;
                    u1 = ((float)i0 + 1.0f) / 4.0f;
                    v1 = ((float)i1 + 1.0f) / 2.0f;
                }
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                if (specialBlends) {
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                }
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)((ResourceLocation)map.get("texture")));
                _poseStack.pushPose();
                if (type == Set.SUN || type == Set.MOON) {
                    float f0 = 0.0f;
                    if (type == Set.MOON) {
                        f0 = 180.0f;
                    }
                    _poseStack.mulPose(Vector3f.YP.rotationDegrees(-90.0f));
                    _poseStack.mulPose(Vector3f.XP.rotationDegrees(_clientLevel.getTimeOfDay(_partialTick) * 360.0f + f0));
                } else {
                    _poseStack.mulPose(Vector3f.XP.rotationDegrees(90.0f));
                    _poseStack.mulPose(Vector3f.ZP.rotationDegrees(((Float)map.get("yaw")).floatValue()));
                    _poseStack.mulPose(Vector3f.XP.rotationDegrees(((Float)map.get("pitch")).floatValue()));
                    _poseStack.mulPose(Vector3f.YP.rotationDegrees(((Float)map.get("roll")).floatValue()));
                }
                Matrix4f matrix4f = _poseStack.last().pose();
                float size = ((Float)map.get("size")).floatValue() / 5.0f;
                BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferBuilder.addVertex(matrix4f, -size, 100.0f, -size).setUv(u0, v0);
                bufferBuilder.addVertex(matrix4f, size, 100.0f, -size).setUv(u1, v0);
                bufferBuilder.addVertex(matrix4f, size, 100.0f, size).setUv(u1, v1);
                bufferBuilder.addVertex(matrix4f, -size, 100.0f, size).setUv(u0, v1);
                BufferUploader.drawWithShader((MeshData)bufferBuilder.build());
                _poseStack.popPose();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
            }
        }
    }

    private static void renderWeather(Map<String, Object> map, Set type, float length, float speed, boolean hitGround) {
        if (BetterFogProcedure.renderable(Stage.WEATHER)) {
            float camX = (float)_camX;
            float camY = (float)_camY;
            float camZ = (float)_camZ;
            float x = (float)((Double)map.get("x")).doubleValue();
            float y = (float)((Double)map.get("y")).doubleValue();
            float z = (float)((Double)map.get("z")).doubleValue();
            float lx = x - camX;
            float lz = z - camZ;
            float[] color = BetterFogProcedure.getColor(map);
            float red = color[0];
            float green = color[1];
            float blue = color[2];
            float alpha = color[3];
            float effects = 1.0f;
            if (((Boolean)map.get("weatherEffects")).booleanValue()) {
                effects = _clientLevel.getRainLevel(_partialTick);
            }
            float factor = 5.0f;
            if (_minecraft.useFancyGraphics()) {
                factor = 10.0f;
            }
            if ((alpha *= effects * ((1.0f - (factor = (float)Math.hypot(lx, lz) / factor) * factor) * 0.5f + 0.5f)) > 0.0f) {
                ClientLevel level = _clientLevel;
                int pxi = (int)Math.floor(x);
                int pzi = (int)Math.floor(z);
                float min = y - camY;
                float max = min + length;
                int height = level.getHeight(Heightmap.Types.MOTION_BLOCKING, pxi, pzi);
                boolean renderable = true;
                if (hitGround) {
                    float f0 = (float)height - camY;
                    if (min < f0 && (min = f0) >= max) {
                        renderable = false;
                    }
                    if (max < f0) {
                        renderable = false;
                    }
                }
                if (renderable) {
                    float rad = (float)(1.5707963267948966 - Math.atan2(lz, lx));
                    float cos = Mth.cos((float)rad) * 0.5f;
                    float sin = Mth.sin((float)rad) * 0.5f;
                    int light = 0xF00000;
                    if (hitGround) {
                        int bottom = (int)Math.floor(y);
                        if (bottom < height) {
                            bottom = height;
                        }
                        int top = (int)Math.ceil(y + length);
                        for (int i = bottom; i < top; ++i) {
                            boolean b0;
                            BlockPos pos = new BlockPos(pxi, i, pzi);
                            boolean bl = b0 = !level.getBlockState(pos).canOcclude();
                            if (!b0) continue;
                            light = LevelRenderer.getLightColor((BlockAndTintGetter)_clientLevel, (BlockPos)pos);
                            break;
                        }
                    }
                    RandomSource random = RandomSource.create((long)(pxi * pxi * 3121 + pxi * 45238971 ^ pzi * pzi * 418711 + pzi * 13761));
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.enableDepthTest();
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.setShader(GameRenderer::getParticleShader);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)((ResourceLocation)map.get("texture")));
                    _lightTexture.turnOnLightLayer();
                    BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                    if (type == Set.RAIN) {
                        int i0 = _ticks + pxi * pxi * 3121 + pxi * 45238971 + pzi * pzi * 418711 + pzi * 13761 & 0x1F;
                        float f0 = -((float)i0 + _partialTick) / 32.0f * (3.0f + random.nextFloat()) * speed;
                        bufferBuilder.addVertex(lx - cos, max, lz + sin).setUv(0.0f, min * 0.25f + f0).setColor(red, green, blue, alpha).setUv2(light, light);
                        bufferBuilder.addVertex(lx + cos, max, lz - sin).setUv(1.0f, min * 0.25f + f0).setColor(red, green, blue, alpha).setUv2(light, light);
                        bufferBuilder.addVertex(lx + cos, min, lz - sin).setUv(1.0f, max * 0.25f + f0).setColor(red, green, blue, alpha).setUv2(light, light);
                        bufferBuilder.addVertex(lx - cos, min, lz + sin).setUv(0.0f, max * 0.25f + f0).setColor(red, green, blue, alpha).setUv2(light, light);
                    } else if (type == Set.SNOW) {
                        float f0 = (float)_ticks + _partialTick;
                        float f1 = ((float)(_ticks & 0x200) + _partialTick) / -512.0f;
                        float f2 = (random.nextFloat() + f0 * (float)random.nextGaussian() * 0.01f) * speed;
                        float f3 = (random.nextFloat() + f0 * (float)random.nextGaussian() * 0.001f) * speed;
                        int i1 = light & 0xFFFF;
                        int i2 = light >> 16 & 0xFFFF;
                        int u = (i1 * 3 + 240) / 4;
                        int v = (i2 * 3 + 240) / 4;
                        bufferBuilder.addVertex(lx - cos, max, lz + sin).setUv(0.0f + f2, min * 0.25f + f1 + f3).setColor(red, green, blue, alpha).setUv2(u, v);
                        bufferBuilder.addVertex(lx + cos, max, lz - sin).setUv(1.0f + f2, min * 0.25f + f1 + f3).setColor(red, green, blue, alpha).setUv2(u, v);
                        bufferBuilder.addVertex(lx + cos, min, lz - sin).setUv(1.0f + f2, max * 0.25f + f1 + f3).setColor(red, green, blue, alpha).setUv2(u, v);
                        bufferBuilder.addVertex(lx - cos, min, lz + sin).setUv(0.0f + f2, max * 0.25f + f1 + f3).setColor(red, green, blue, alpha).setUv2(u, v);
                    }
                    BufferUploader.drawWithShader((MeshData)bufferBuilder.build());
                    _lightTexture.turnOffLightLayer();
                    RenderSystem.disableBlend();
                    RenderSystem.disableDepthTest();
                    RenderSystem.depthMask((boolean)true);
                }
            }
        }
    }

    private static void addWeatherParticlesAndSounds(Map<String, Object> map, boolean hitGround, Set set) {
        if (BetterFogProcedure.renderable(Stage.PARTICLES)) {
            RandomSource random = RandomSource.create();
            double x = (Double)map.get("x");
            double y = (Double)map.get("y");
            double z = (Double)map.get("z");
            int xi = (int)Math.floor(x);
            int yi = (int)Math.floor(y);
            if (hitGround) {
                yi = BetterFogProcedure.getWorldHeight(x, z);
            }
            int zi = (int)Math.floor(z);
            ClientLevel level = _clientLevel;
            BlockPos pos0 = new BlockPos(xi, yi, zi);
            BlockPos pos1 = new BlockPos(xi, yi - 1, zi);
            float rainLevel = BetterFogProcedure.getRainLevel();
            boolean weatherEffects = (Boolean)map.get("weatherEffects");
            boolean particleFlag = true;
            boolean soundFlag = true;
            boolean vanillaFlag = false;
            if (set == Set.PARTICLES_ONLY) {
                particleFlag = true;
                soundFlag = false;
            } else if (set == Set.SOUNDS_ONLY) {
                particleFlag = false;
                soundFlag = true;
            } else if (set == Set.VANILLA_PARTICLES_AND_SOUNDS) {
                vanillaFlag = true;
            } else if (set == Set.VANILLA_PARTICLES_ONLY) {
                particleFlag = true;
                soundFlag = false;
                vanillaFlag = true;
            } else if (set == Set.VANILLA_SOUNDS_ONLY) {
                particleFlag = false;
                soundFlag = true;
                vanillaFlag = true;
            }
            if (particleFlag) {
                ParticleStatus status = (ParticleStatus)BetterFogProcedure._minecraft.options.particles().get();
                boolean b0 = status != ParticleStatus.MINIMAL;
                int i0 = 1;
                float f0 = 1.0f;
                if (status == ParticleStatus.DECREASED) {
                    i0 = 2;
                }
                if (weatherEffects) {
                    f0 = rainLevel * rainLevel;
                }
                float f1 = 100.0f * f0 / (float)i0 / 441.0f;
                if (vanillaFlag) {
                    boolean bl = b0 = b0 && BetterFogProcedure.rainnable(x, y, z);
                }
                if (b0 && random.nextFloat() < f1) {
                    double rx = random.nextDouble();
                    double rz = random.nextDouble();
                    BlockState blockState = level.getBlockState(pos1);
                    FluidState fluidState = level.getFluidState(pos1);
                    VoxelShape voxelShape = blockState.getCollisionShape((BlockGetter)level, pos1);
                    double d0 = voxelShape.max(Direction.Axis.Y, rx, rz);
                    double d1 = fluidState.getHeight((BlockGetter)level, pos1);
                    double d2 = Math.max(d0, d1);
                    double qx = (double)xi + rx;
                    double qy = (double)yi - 1.0 + d2;
                    double qz = (double)zi + rz;
                    ParticleOptions particle = (ParticleOptions)map.get("particle");
                    double vx = (Double)map.get("pvx");
                    double vy = (Double)map.get("pvy");
                    double vz = (Double)map.get("pvz");
                    if (vanillaFlag) {
                        particle = !fluidState.is(FluidTags.LAVA) && !blockState.is(Blocks.MAGMA_BLOCK) && !CampfireBlock.isLitCampfire((BlockState)blockState) ? ParticleTypes.RAIN : ParticleTypes.SMOKE;
                        vx = 0.0;
                        vy = 0.0;
                        vz = 0.0;
                    }
                    _clientLevel.addParticle(particle, qx, qy, qz, vx, vy, vz);
                }
            }
            if (soundFlag) {
                float f2 = 0.0022675737f;
                float f3 = 0.33333334f;
                boolean b1 = true;
                if (weatherEffects) {
                    boolean bl = b1 = rainLevel > 0.0f;
                }
                if (vanillaFlag) {
                    boolean bl = b1 = b1 && BetterFogProcedure.rainnable(x, y, z);
                }
                if (b1 && random.nextFloat() < f2 && random.nextFloat() < f3) {
                    Vec3 cameraPos = _camera.getPosition();
                    double camX = cameraPos.x();
                    double camY = cameraPos.y();
                    double camZ = cameraPos.z();
                    double height = BetterFogProcedure.getWorldHeight(camX, camZ);
                    --yi;
                    SoundEvent sound = SoundEvents.WEATHER_RAIN;
                    SoundSource soundSource = SoundSource.WEATHER;
                    float soundLevel = 0.2f;
                    float soundPitch = 1.0f;
                    if (vanillaFlag) {
                        if (camY + 1.0 < (double)yi && camY < height) {
                            sound = SoundEvents.WEATHER_RAIN_ABOVE;
                            soundLevel = 0.1f;
                            soundPitch = 0.5f;
                        }
                    } else {
                        sound = (SoundEvent)map.get("sound");
                        soundSource = (SoundSource)map.get("soundSource");
                        soundLevel = ((Float)map.get("soundLevel")).floatValue();
                        soundPitch = ((Float)map.get("soundPitch")).floatValue();
                    }
                    _clientLevel.playLocalSound((double)xi, (double)yi, (double)zi, sound, soundSource, soundLevel, soundPitch, false);
                }
            }
        }
    }

    private static void setFog(FogShape shape, float start, float end, Map<String, Object> map) {
        if (BetterFogProcedure.renderable(Stage.FOG)) {
            if (shape == null) {
                shape = _fog.getFogShape();
            }
            _fog.setFogShape(shape);
            _fog.setNearPlaneDistance(start);
            _fog.setFarPlaneDistance(end);
            _fog.setCanceled(true);
        } else {
            float[] color = BetterFogProcedure.getColor(map);
            if (_stage == Stage.FOGCOLOR) {
                _fogColor.setRed(color[0]);
                _fogColor.setGreen(color[1]);
                _fogColor.setBlue(color[2]);
            } else {
                RenderSystem.setShaderFogColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
            }
        }
    }

    private static void renderVanillaObjects(boolean clouds, boolean endSky, boolean topSky, boolean bottomSky, boolean sunlights, boolean stars, boolean sun, boolean moon, boolean weather) {
        Map<String, Object> params = BetterFogProcedure.clone(_PARAMS);
        if (BetterFogProcedure.renderable(Stage.CLOUDS) && clouds) {
            ResourceKey dimension = _clientLevel.dimension();
            params.put("x", BetterFogProcedure.getCloudPosition((ResourceKey<Level>)dimension, Set.X));
            params.put("y", BetterFogProcedure.getCloudPosition((ResourceKey<Level>)dimension, Set.Y));
            params.put("z", BetterFogProcedure.getCloudPosition((ResourceKey<Level>)dimension, Set.Z));
            params.put("vx", -1.0);
            params.put("vy", 0.0);
            params.put("vz", 0.0);
            params.put("width", 12.0);
            params.put("depth", 12.0);
            params.put("height", 4.0);
            BetterFogProcedure.setTexture(params, "minecraft", "environment/clouds.png", null);
            params.put("model", (Object)Color.RGBA);
            params.put("red", Float.valueOf(BetterFogProcedure.getCloudColor(Color.RED)));
            params.put("green", Float.valueOf(BetterFogProcedure.getCloudColor(Color.GREEN)));
            params.put("blue", Float.valueOf(BetterFogProcedure.getCloudColor(Color.BLUE)));
            params.put("alpha", Float.valueOf(BetterFogProcedure.getCloudColor(Color.ALPHA)));
            BetterFogProcedure.renderClouds(params, Set.NONE, 480.0, 480.0);
        }
        if (BetterFogProcedure.renderable(Stage.SKY)) {
            double horizon;
            double eye;
            if (endSky) {
                boolean noFog;
                boolean bl = noFog = !BetterFogProcedure._minecraft.gui.getBossOverlay().shouldCreateWorldFog();
                if (noFog) {
                    BetterFogProcedure.setTexture(params, "minecraft", "environment/end_sky.png", null);
                    params.put("u0", Float.valueOf(0.0f));
                    params.put("v0", Float.valueOf(0.0f));
                    params.put("u1", Float.valueOf(16.0f));
                    params.put("v1", Float.valueOf(16.0f));
                    params.put("model", (Object)Color.RGBA);
                    params.put("red", Float.valueOf(40.0f));
                    params.put("green", Float.valueOf(40.0f));
                    params.put("blue", Float.valueOf(40.0f));
                    params.put("alpha", Float.valueOf(100.0f));
                    BetterFogProcedure.renderSkyBox(params, true);
                }
            }
            if (topSky) {
                params.put("yaw", Float.valueOf(0.0f));
                params.put("pitch", Float.valueOf(-90.0f));
                params.put("roll", Float.valueOf(0.0f));
                params.put("size", Float.valueOf(100.0f));
                params.put("model", (Object)Color.RGBA);
                params.put("red", Float.valueOf(BetterFogProcedure.getSkyColor(Color.RED)));
                params.put("green", Float.valueOf(BetterFogProcedure.getSkyColor(Color.GREEN)));
                params.put("blue", Float.valueOf(BetterFogProcedure.getSkyColor(Color.BLUE)));
                params.put("alpha", Float.valueOf(BetterFogProcedure.getSkyColor(Color.ALPHA)));
                BetterFogProcedure.renderPolygon(params, 8);
            }
            if (sunlights) {
                params.put("yaw", Float.valueOf(0.0f));
                params.put("pitch", Float.valueOf(0.0f));
                params.put("roll", Float.valueOf(0.0f));
                params.put("model", (Object)Color.RGBA);
                params.put("red", Float.valueOf(BetterFogProcedure.getSunlightColor(Color.RED)));
                params.put("green", Float.valueOf(BetterFogProcedure.getSunlightColor(Color.GREEN)));
                params.put("blue", Float.valueOf(BetterFogProcedure.getSunlightColor(Color.BLUE)));
                params.put("alpha", Float.valueOf(BetterFogProcedure.getSunlightColor(Color.ALPHA)));
                BetterFogProcedure.renderSunlights(params);
            }
            if (stars) {
                params.put("yaw", Float.valueOf(0.0f));
                params.put("pitch", Float.valueOf(0.0f));
                params.put("roll", Float.valueOf(BetterFogProcedure.getDayLevel() * 360.0f));
                params.put("model", (Object)Color.RGBA);
                params.put("red", Float.valueOf(BetterFogProcedure.getStarColor(Color.RED)));
                params.put("green", Float.valueOf(BetterFogProcedure.getStarColor(Color.GREEN)));
                params.put("blue", Float.valueOf(BetterFogProcedure.getStarColor(Color.BLUE)));
                params.put("alpha", Float.valueOf(BetterFogProcedure.getStarColor(Color.ALPHA)));
                BetterFogProcedure.renderStars(params, 1500, 10842);
            }
            if (bottomSky && (eye = BetterFogProcedure._minecraft.player.getEyePosition(_partialTick).y()) < (horizon = _clientLevel.getLevelData().getHorizonHeight((LevelHeightAccessor)_clientLevel))) {
                params.put("yaw", Float.valueOf(0.0f));
                params.put("pitch", Float.valueOf(90.0f));
                params.put("roll", Float.valueOf(0.0f));
                params.put("size", Float.valueOf(100.0f));
                params.put("model", (Object)Color.RGBA);
                params.put("red", Float.valueOf(0.0f));
                params.put("green", Float.valueOf(0.0f));
                params.put("blue", Float.valueOf(0.0f));
                params.put("alpha", Float.valueOf(100.0f));
                BetterFogProcedure.renderPolygon(params, 8);
            }
            if (sun) {
                BetterFogProcedure.setTexture(params, "minecraft", "environment/sun.png", null);
                params.put("u0", Float.valueOf(0.0f));
                params.put("v0", Float.valueOf(0.0f));
                params.put("u1", Float.valueOf(1.0f));
                params.put("v1", Float.valueOf(1.0f));
                params.put("size", Float.valueOf(150.0f));
                params.put("model", (Object)Color.RGBA);
                params.put("red", Float.valueOf(255.0f));
                params.put("green", Float.valueOf(255.0f));
                params.put("blue", Float.valueOf(255.0f));
                params.put("alpha", Float.valueOf(100.0f));
                BetterFogProcedure.renderTexture(params, Set.SUN, true);
            }
            if (moon) {
                BetterFogProcedure.setTexture(params, "minecraft", "environment/moon_phases.png", null);
                params.put("u0", Float.valueOf(0.0f));
                params.put("v0", Float.valueOf(0.0f));
                params.put("u1", Float.valueOf(1.0f));
                params.put("v1", Float.valueOf(1.0f));
                params.put("size", Float.valueOf(100.0f));
                params.put("model", (Object)Color.RGBA);
                params.put("red", Float.valueOf(255.0f));
                params.put("green", Float.valueOf(255.0f));
                params.put("blue", Float.valueOf(255.0f));
                params.put("alpha", Float.valueOf(100.0f));
                BetterFogProcedure.renderTexture(params, Set.MOON, true);
            }
        }
        if ((BetterFogProcedure.renderable(Stage.WEATHER) || BetterFogProcedure.renderable(Stage.PARTICLES)) && weather) {
            Vec3 pos = _camera.getPosition();
            double size = BetterFogProcedure.getWeatherWDH();
            double x = pos.x();
            double y = pos.y();
            double z = pos.z();
            params.put("x", x);
            params.put("y", y);
            params.put("z", z);
            params.put("width", size);
            params.put("depth", size);
            params.put("height", size);
            params.put("model", (Object)Color.RGBA);
            params.put("red", Float.valueOf(255.0f));
            params.put("green", Float.valueOf(255.0f));
            params.put("blue", Float.valueOf(255.0f));
            params.put("alpha", Float.valueOf(100.0f));
            List<Vec3> list = BetterFogProcedure.getWeatherArea(params);
            for (Vec3 area : list) {
                double ax = area.x();
                double ay = area.y();
                double az = area.z();
                params.put("x", ax);
                params.put("y", ay);
                params.put("z", az);
                if (BetterFogProcedure.rainnable(ax, ay, az)) {
                    BetterFogProcedure.setTexture(params, "minecraft", "environment/rain.png", null);
                    BetterFogProcedure.renderWeather(params, Set.RAIN, (float)size, 1.0f, true);
                } else if (BetterFogProcedure.snowable(ax, ay, az)) {
                    BetterFogProcedure.setTexture(params, "minecraft", "environment/snow.png", null);
                    BetterFogProcedure.renderWeather(params, Set.SNOW, (float)size, 1.0f, true);
                }
                BetterFogProcedure.addWeatherParticlesAndSounds(params, true, Set.VANILLA_PARTICLES_AND_SOUNDS);
            }
        }
    }

    private static void set(boolean brightLights) {
        if (BetterFogProcedure.renderable(Stage.TICKS)) {
            try {
                _effects.set(_clientLevel, (Object)new CustomDimensionEffects(DimensionSpecialEffects.forType((DimensionType)_clientLevel.dimensionType()), brightLights));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void clear() {
        if (BetterFogProcedure.renderable(Stage.TICKS)) {
            try {
                if (_effects == null) {
                    _effects = _clientLevel.getClass().getDeclaredField("effects");
                    _effects.setAccessible(true);
                }
                _effects.set(_clientLevel, DimensionSpecialEffects.forType((DimensionType)_clientLevel.dimensionType()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void ticks(RenderLevelStageEvent event) {
        _minecraft = Minecraft.getInstance();
        _clientLevel = BetterFogProcedure._minecraft.level;
        Entity entity = _minecraft.getCameraEntity();
        if (_clientLevel != null && entity != null) {
            _stage = Stage.TICKS;
            BetterFogProcedure.clear();
            BetterFogProcedure._execute();
        }
    }

    @SubscribeEvent
    public static void fog(ViewportEvent.RenderFog event) {
        _fog = event;
        _stage = Stage.FOG;
        BetterFogProcedure._execute();
    }

    @SubscribeEvent
    public static void fogColor(ViewportEvent.ComputeFogColor event) {
        _fogColor = event;
        _stage = Stage.FOGCOLOR;
        BetterFogProcedure._execute();
    }

    private static void _execute() {
        _minecraft = Minecraft.getInstance();
        _clientLevel = BetterFogProcedure._minecraft.level;
        Entity entity = _minecraft.getCameraEntity();
        if (_clientLevel != null && entity != null) {
            if (!_minecraft.isPaused()) {
                _partialTick = _minecraft.getFrameTimeNs();
            }
            _projectionMatrix = RenderSystem.getProjectionMatrix();
            _camera = BetterFogProcedure._minecraft.gameRenderer.getMainCamera();
            BetterFogProcedure.execute(null, _clientLevel, entity, BetterFogProcedure.clone(_PARAMS));
        }
    }

    public static float fogParam(float def, Pair<String, Float> change, double status) {
        float value = ((Float)change.getValue()).floatValue();
        float newValue = switch ((String)change.getKey()) {
            case "=" -> value;
            case "*" -> def * value;
            case "/" -> def / value;
            case "+" -> def + value;
            case "-" -> def - value;
            default -> def;
        };
        return (float)BiomeColor.fromTo(def, newValue, status);
    }

    private static void setColorFogData(Pair<String, Float> redC, Pair<String, Float> greenC, Pair<String, Float> blueC, double state) {
        red = BetterFogProcedure.fogParam(red, redC, state);
        green = BetterFogProcedure.fogParam(green, greenC, state);
        blue = BetterFogProcedure.fogParam(blue, blueC, state);
    }

    private static void setOpacityFogData(Pair<String, Float> opacityC, double state) {
        opacity = BetterFogProcedure.fogParam(opacity, opacityC, state);
    }

    private static void setDistanceFogData(Pair<String, Float> startC, Pair<String, Float> endC, double state) {
        startfog = BetterFogProcedure.fogParam(startfog, startC, state);
        endfog = BetterFogProcedure.fogParam(endfog, endC, state);
    }

    public static void setFogData(BiomeInfo.CustomFogData data, double state) {
        if (state > 0.0) {
            if (data.isEnabled()) {
                BetterFogProcedure.setColorFogData(data.getRed(), data.getGreen(), data.getBlue(), state);
                BetterFogProcedure.setOpacityFogData(data.getOpacity(), state);
                BetterFogProcedure.setDistanceFogData(data.getStart(), data.getEnd(), state);
            } else {
                BetterFogProcedure.setDefFogData(state);
            }
        }
    }

    private static void setCustomFogData(BiomeInfo.CustomFogData data, double state) {
        if (state > 0.0 && data.isEnabled()) {
            BetterFogProcedure.setFogData(data, state);
        }
    }

    private static void setDefFogData() {
        BetterFogProcedure.setDefFogData(1.0);
    }

    private static void setDefFogData(double state) {
        Vec3 color = CustomFogRenderer.setupColor(_camera, _partialTick, _clientLevel, Minecraft.getInstance().options.getEffectiveRenderDistance(), Minecraft.getInstance().gameRenderer.getDarkenWorldAmount(1.0f));
        red = (float)BiomeColor.fromTo(red, color.x, state);
        green = (float)BiomeColor.fromTo(green, color.y, state);
        blue = (float)BiomeColor.fromTo(blue, color.z, state);
        opacity = (float)BiomeColor.fromTo(opacity, 0.25, state);
        startfog = (float)BiomeColor.fromTo(startfog, Minecraft.getInstance().options.getEffectiveRenderDistance() * 16 - 32, state);
        endfog = (float)BiomeColor.fromTo(endfog, Minecraft.getInstance().options.getEffectiveRenderDistance() * 16, state);
    }

    public static void setFogData(BiomeInfo.CustomFogData data) {
        BetterFogProcedure.setFogData(data, 1.0);
    }

    public static void setCaveFogData(BiomeInfo.CustomFogData data, float y) {
        if (data.isEnabled() && y < (float)BetterFogConfiguration.caveYStart) {
            double opacityState;
            double colorState = caveColorSig.bs(y);
            double distaceState = opacityState = (double)caveOpacitySig.bs(y);
            BetterFogProcedure.setColorFogData(data.getRed(), data.getGreen(), data.getBlue(), colorState);
            BetterFogProcedure.setOpacityFogData(data.getOpacity(), opacityState);
            BetterFogProcedure.setDistanceFogData(data.getStart(), data.getEnd(), distaceState);
        }
    }

    public static void setCloudFogData(BiomeInfo.CustomFogData data, float y) {
        if (data.isEnabled() && y > (float)BetterFogConfiguration.cloudYStart && y < (float)BetterFogConfiguration.cloudYEnd) {
            float half = (float)BetterFogConfiguration.cloudYStart + (float)(BetterFogConfiguration.cloudYEnd - BetterFogConfiguration.cloudYStart) / 2.0f;
            if (y < half) {
                BetterFogProcedure.setCustomFogData(data, cloudSig1.bs(y));
            } else {
                BetterFogProcedure.setCustomFogData(data, cloudSig2.bs(y));
            }
        }
    }

    public static void setVoidFogData(BiomeInfo.CustomFogData data, float y) {
        if (data.isEnabled() && y > (float)BetterFogConfiguration.voidYStart && y < (float)BetterFogConfiguration.voidYEnd) {
            float half = (float)BetterFogConfiguration.voidYStart + (float)(BetterFogConfiguration.voidYEnd - BetterFogConfiguration.voidYStart) / 2.0f;
            if (y < half) {
                BetterFogProcedure.setCustomFogData(data, voidSig1.bs(y));
            } else {
                BetterFogProcedure.setCustomFogData(data, voidSig2.bs(y));
            }
        }
    }

    private static void execute(@Nullable Event event, ClientLevel world, Entity camera, Map<String, Object> parameter) {
        String dimension = world.dimension().location().toString();
        if (BetterFogConfiguration.dimensionBlacklist.contains(dimension)) {
            return;
        }
        if (world.dayTime() == currentTick) {
            BetterFogProcedure.setFog(parameter);
            return;
        }
        currentTick = world.dayTime();
        Vec3 pos = camera.position();
        float x = (float)pos.x;
        float y = (float)pos.y;
        float z = (float)pos.z;
        Holder biomeHolder = world.getBiome(BlockPos.containing((Position)new Vec3((double)x, 64.0, (double)z)));
        String currentBiome = ((ResourceKey)biomeHolder.unwrapKey().get()).location().toString().replace("minecraft:", "");
        if (biome != currentBiome && biomeTime + (long)BetterFogConfiguration.changeTime < currentTick) {
            biomeTime = currentTick + (long)BetterFogConfiguration.changeTime;
            biome = currentBiome;
        }
        BiomeInfo biomeInfo = BetterFogConfiguration.getBiomeInfo(biome);
        BiomeInfo.CustomFogData defaultData = biomeInfo.getDefault();
        BiomeInfo.CustomFogData nightData = biomeInfo.getNight();
        BiomeInfo.CustomFogData rainData = biomeInfo.getRain();
        BiomeInfo.CustomFogData thunderData = biomeInfo.getThunder();
        BiomeInfo.CustomFogData caveData = biomeInfo.getCave();
        BiomeInfo.CustomFogData voidData = biomeInfo.getVoid();
        BiomeInfo.CustomFogData cloudData = biomeInfo.getCloud();
        BiomeInfo.CustomFogData waterData = biomeInfo.getWater();
        BiomeInfo.CustomFogData lavaData = biomeInfo.getLava();
        FogType fogtype = _camera.getFluidInCamera();
        BetterFogProcedure.setDefFogData();
        double night = Sigmoid.smoothingSig(10.0f, -0.75f).bs(BiomeColor.getTimeOfDayValue((Level)_clientLevel));
        BetterFogProcedure.setFogData(defaultData, 1.0 - night);
        BetterFogProcedure.setFogData(nightData, night);
        double rain = BetterFogProcedure.getRainLevel();
        BetterFogProcedure.setFogData(rainData, rain);
        double thunder = BetterFogProcedure.getThunderLevel();
        BetterFogProcedure.setFogData(thunderData, thunder);
        BetterFogProcedure.setCloudFogData(cloudData, y);
        BetterFogProcedure.setVoidFogData(voidData, y);
        BetterFogProcedure.setCaveFogData(caveData, y);
        if (fogtype == FogType.WATER) {
            BetterFogProcedure.setFogData(waterData);
        } else if (fogtype == FogType.LAVA) {
            BetterFogProcedure.setFogData(lavaData);
        }
        red = Math.min(red, 1.0f);
        green = Math.min(green, 1.0f);
        blue = Math.min(blue, 1.0f);
        opacity = Math.min(opacity, 1.0f);
        setRed = BetterFogProcedure.controlledChange(setRed, red, BetterFogConfiguration.stepColor);
        setGreen = BetterFogProcedure.controlledChange(setGreen, green, BetterFogConfiguration.stepColor);
        setBlue = BetterFogProcedure.controlledChange(setBlue, blue, BetterFogConfiguration.stepColor);
        setOpacity = BetterFogProcedure.controlledChange(setOpacity, opacity, BetterFogConfiguration.stepColor);
        setStart = BetterFogProcedure.controlledChange(setStart, startfog, BetterFogConfiguration.stepDistance);
        setEnd = BetterFogProcedure.controlledChange(setEnd, endfog, BetterFogConfiguration.stepDistance);
        BetterFogProcedure.setFog(parameter);
    }

    public static void setFog(Map<String, Object> parameter) {
        parameter.put("model", (Object)Color.RGBA);
        parameter.put("red", Float.valueOf(setRed * 255.0f));
        parameter.put("green", Float.valueOf(setGreen * 255.0f));
        parameter.put("blue", Float.valueOf(setBlue * 255.0f));
        parameter.put("alpha", Float.valueOf(setOpacity * 255.0f));
        BetterFogProcedure.setFog(FogShape.CYLINDER, 0.0f, setEnd, parameter);
    }

    public static float controlledChange(float data, float changeData, float step) {
        if (data > changeData) {
            return Math.max(changeData, data - step);
        }
        if (data < changeData) {
            return Math.min(changeData, data + step);
        }
        return data;
    }

    static {
        red = 0.0f;
        green = 0.0f;
        blue = 0.0f;
        opacity = 0.0f;
        startfog = 0.0f;
        endfog = 0.0f;
        cloudHalf = (float)BetterFogConfiguration.cloudYStart + (float)(BetterFogConfiguration.cloudYEnd - BetterFogConfiguration.cloudYStart) / 2.0f;
        voidHalf = (float)BetterFogConfiguration.voidYStart + (float)(BetterFogConfiguration.voidYEnd - BetterFogConfiguration.voidYStart) / 2.0f;
        caveColorSig = Sigmoid.sigmoid01(BetterFogConfiguration.caveYStart, (float)BetterFogConfiguration.caveYEnd * 0.7f, BetterFogConfiguration.caveP);
        caveOpacitySig = Sigmoid.sigmoid01(BetterFogConfiguration.caveYStart, BetterFogConfiguration.caveYEnd, BetterFogConfiguration.caveP);
        cloudSig1 = Sigmoid.sigmoid01(BetterFogConfiguration.cloudYStart, cloudHalf, BetterFogConfiguration.cloudP, 0.6f);
        cloudSig2 = Sigmoid.sigmoid01(BetterFogConfiguration.cloudYEnd, cloudHalf, BetterFogConfiguration.cloudP, 0.6f);
        voidSig1 = Sigmoid.sigmoid01(BetterFogConfiguration.voidYStart, voidHalf, BetterFogConfiguration.voidP);
        voidSig2 = Sigmoid.sigmoid01(BetterFogConfiguration.voidYEnd, voidHalf, BetterFogConfiguration.voidP);
    }

    private static enum Color {
        RGBA,
        HSLA,
        RED,
        GREEN,
        BLUE,
        HUE,
        SATURATION,
        LIGHTNESS,
        ALPHA;

    }

    private static enum Stage {
        NONE,
        TICKS,
        FOG,
        FOGCOLOR,
        CLOUDS,
        SKY,
        WEATHER,
        PARTICLES;

    }

    private static enum Set {
        NONE,
        X,
        Y,
        Z,
        FANCY,
        FAST,
        SUN,
        MOON,
        RAIN,
        SNOW,
        PARTICLES_AND_SOUNDS,
        PARTICLES_ONLY,
        SOUNDS_ONLY,
        VANILLA_PARTICLES_AND_SOUNDS,
        VANILLA_PARTICLES_ONLY,
        VANILLA_SOUNDS_ONLY,
        START,
        END;

    }

    private static class CustomDimensionEffects
    extends DimensionSpecialEffects {
        DimensionSpecialEffects effects = null;

        public CustomDimensionEffects(DimensionSpecialEffects effects, boolean brightLights) {
            super(effects.getCloudHeight(), effects.hasGround(), effects.skyType(), brightLights, effects.constantAmbientLight());
            this.effects = effects;
        }

        public Vec3 getBrightnessDependentFogColor(Vec3 color, float partialTick) {
            Vec3 result = this.effects.getBrightnessDependentFogColor(color, partialTick);
            return result;
        }

        public boolean isFoggyAt(int i0, int i1) {
            boolean result = this.effects.isFoggyAt(i0, i1);
            return result;
        }

        public boolean renderClouds(ClientLevel clientLevel, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
            _ticks = ticks;
            _poseStack = poseStack;
            _camX = camX;
            _camY = camY;
            _camZ = camZ;
            _stage = Stage.CLOUDS;
            BetterFogProcedure._execute();
            return true;
        }

        public boolean renderSky(ClientLevel clientLevel, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
            _ticks = ticks;
            _poseStack = poseStack;
            _stage = Stage.SKY;
            BetterFogProcedure._execute();
            return true;
        }

        public boolean renderSnowAndRain(ClientLevel clientLevel, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
            _ticks = ticks;
            _lightTexture = lightTexture;
            _camX = camX;
            _camY = camY;
            _camZ = camZ;
            _stage = Stage.WEATHER;
            BetterFogProcedure._execute();
            return true;
        }

        public boolean tickRain(ClientLevel clientLevel, int ticks, Camera camera) {
            _ticks = ticks;
            _stage = Stage.PARTICLES;
            BetterFogProcedure._execute();
            return true;
        }
    }
}

