/*
 * Decompiled with CFR 0.152.
 */
package net.cloud.betterfog;

import com.google.gson.JsonObject;
import net.cloud.betterfog.BetterFogConfiguration;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeInfo {
    private JsonObject biomeData;

    public BiomeInfo(JsonObject object) {
        this.biomeData = object;
    }

    public CustomFogData get(String id) {
        JsonObject def = BetterFogConfiguration.getDefault();
        if (!(BetterFogConfiguration.configJson != null && !BetterFogConfiguration.configJson.get(id + "_enabled").getAsBoolean() || !this.biomeData.has(id) && BetterFogConfiguration.disableForUnconfigured)) {
            if (!this.biomeData.has(id)) {
                return new CustomFogData(def.get(id).getAsJsonObject());
            }
            return new CustomFogData(this.biomeData.get(id).getAsJsonObject());
        }
        return new CustomFogData(null);
    }

    public CustomFogData getDefault() {
        return this.get("day");
    }

    public CustomFogData getNight() {
        return this.get("night");
    }

    public CustomFogData getRain() {
        return this.get("rain");
    }

    public CustomFogData getThunder() {
        return this.get("thunder");
    }

    public CustomFogData getVoid() {
        return this.get("void");
    }

    public CustomFogData getCave() {
        return this.get("cave");
    }

    public CustomFogData getCloud() {
        return this.get("cloud");
    }

    public CustomFogData getWater() {
        return this.get("water");
    }

    public CustomFogData getLava() {
        return this.get("lava");
    }

    public static class CustomFogData {
        private final JsonObject data;
        private final boolean isEnabled;

        public CustomFogData(JsonObject data) {
            this.isEnabled = data != null;
            this.data = data;
        }

        public Pair<String, Float> get(String key) {
            if (this.data.has(key)) {
                return BetterFogConfiguration.getPairSV(this.data.get(key).getAsString());
            }
            return BetterFogConfiguration.getPairSV(null);
        }

        public Pair<String, Float> getRed() {
            return this.get("red");
        }

        public Pair<String, Float> getGreen() {
            return this.get("green");
        }

        public Pair<String, Float> getBlue() {
            return this.get("blue");
        }

        public Pair<String, Float> getStart() {
            return this.get("start");
        }

        public Pair<String, Float> getEnd() {
            return this.get("end");
        }

        public Pair<String, Float> getOpacity() {
            return this.get("opacity");
        }

        public Vec3 colorAsVec3() {
            return new Vec3((double)((Float)this.getRed().getRight()).floatValue(), (double)((Float)this.getGreen().getRight()).floatValue(), (double)((Float)this.getBlue().getRight()).floatValue());
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }
    }
}

