/*
 * Decompiled with CFR 0.152.
 */
package net.cloud.betterfog;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CustomFogRenderer {
    private static final int WATER_FOG_DISTANCE = 96;
    private static final List<MobEffectFogFunction> MOB_EFFECT_FOG = Lists.newArrayList((Object[])new MobEffectFogFunction[]{new BlindnessFogFunction(), new DarknessFogFunction()});
    public static final float BIOME_FOG_TRANSITION_TIME = 5000.0f;
    private static float fogRed;
    private static float fogGreen;
    private static float fogBlue;
    private static int targetBiomeFog;
    private static int previousBiomeFog;
    private static long biomeChangedTime;

    public static Vec3 setupColor(Camera arg, float g, ClientLevel arg2, int m, float h) {
        LivingEntity livingentity1;
        FogType fogtype = arg.getFluidInCamera();
        Entity entity = arg.getEntity();
        float f5 = 0.25f + 0.75f * (float)m / 32.0f;
        f5 = 1.0f - (float)Math.pow(f5, 0.25);
        Vec3 vec3 = arg2.getSkyColor(arg.getPosition(), g);
        float f7 = (float)vec3.x;
        float f9 = (float)vec3.y;
        float f10 = (float)vec3.z;
        float f11 = Mth.clamp((float)(Mth.cos((float)(arg2.getTimeOfDay(g) * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        BiomeManager biomemanager = arg2.getBiomeManager();
        Vec3 vec31 = arg.getPosition().subtract(2.0, 2.0, 2.0).scale(0.25);
        Vec3 vec32 = CubicSampler.gaussianSampleVec3((Vec3)vec31, (ix, jx, kx) -> arg2.effects().getBrightnessDependentFogColor(Vec3.fromRGB24((int)((Biome)biomemanager.getNoiseBiomeAtQuart(ix, jx, kx).value()).getFogColor()), f11));
        fogRed = (float)vec32.x();
        fogGreen = (float)vec32.y();
        fogBlue = (float)vec32.z();
        if (m >= 4) {
            float[] afloat;
            float f13 = Mth.sin((float)arg2.getSunAngle(g)) > 0.0f ? -1.0f : 1.0f;
            Vector3f vector3f = new Vector3f(f13, 0.0f, 0.0f);
            float f16 = arg.getLookVector().dot((Vector3fc)vector3f);
            if (f16 < 0.0f) {
                f16 = 0.0f;
            }
            if (f16 > 0.0f && (afloat = arg2.effects().getSunriseColor(arg2.getTimeOfDay(g), g)) != null) {
                fogRed = fogRed * (1.0f - (f16 *= afloat[3])) + afloat[0] * f16;
                fogGreen = fogGreen * (1.0f - f16) + afloat[1] * f16;
                fogBlue = fogBlue * (1.0f - f16) + afloat[2] * f16;
            }
        }
        fogRed += (f7 - fogRed) * f5;
        fogGreen += (f9 - fogGreen) * f5;
        fogBlue += (f10 - fogBlue) * f5;
        biomeChangedTime = -1L;
        f7 = entity instanceof LivingEntity && (livingentity1 = (LivingEntity)entity).hasEffect(MobEffects.NIGHT_VISION) && !livingentity1.hasEffect(MobEffects.DARKNESS) ? GameRenderer.getNightVisionScale((LivingEntity)livingentity1, (float)g) : 0.0f;
        if (fogRed != 0.0f && fogGreen != 0.0f && fogBlue != 0.0f) {
            f9 = Math.min(1.0f / fogRed, Math.min(1.0f / fogGreen, 1.0f / fogBlue));
            fogRed = fogRed * (1.0f - f7) + fogRed * f9 * f7;
            fogGreen = fogGreen * (1.0f - f7) + fogGreen * f9 * f7;
            fogBlue = fogBlue * (1.0f - f7) + fogBlue * f9 * f7;
        }
        return new Vec3((double)fogRed, (double)fogGreen, (double)fogBlue);
    }

    public static void setupNoFog() {
        RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
    }

    @Nullable
    private static MobEffectFogFunction getPriorityFogFunction(Entity arg, float f) {
        if (arg instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)arg;
            return MOB_EFFECT_FOG.stream().filter(arg2 -> arg2.isEnabled(livingentity, f)).findFirst().orElse(null);
        }
        return null;
    }

    public static Pair<Float, Float> setupFog(Camera arg, FogRenderer.FogMode arg2, float g, boolean bl, float h) {
        FogType fogtype = arg.getFluidInCamera();
        Entity entity = arg.getEntity();
        FogData CustomFogRenderer$fogdata = new FogData(arg2);
        MobEffectFogFunction CustomFogRenderer$mobeffectfogfunction = CustomFogRenderer.getPriorityFogFunction(entity, h);
        if (fogtype == FogType.LAVA) {
            if (entity.isSpectator()) {
                CustomFogRenderer$fogdata.start = -8.0f;
                CustomFogRenderer$fogdata.end = g * 0.5f;
            } else if (entity instanceof LivingEntity && ((LivingEntity)entity).hasEffect(MobEffects.FIRE_RESISTANCE)) {
                CustomFogRenderer$fogdata.start = 0.0f;
                CustomFogRenderer$fogdata.end = 3.0f;
            } else {
                CustomFogRenderer$fogdata.start = 0.25f;
                CustomFogRenderer$fogdata.end = 1.0f;
            }
        } else if (fogtype == FogType.POWDER_SNOW) {
            if (entity.isSpectator()) {
                CustomFogRenderer$fogdata.start = -8.0f;
                CustomFogRenderer$fogdata.end = g * 0.5f;
            } else {
                CustomFogRenderer$fogdata.start = 0.0f;
                CustomFogRenderer$fogdata.end = 2.0f;
            }
        } else if (CustomFogRenderer$mobeffectfogfunction != null) {
            LivingEntity livingentity = (LivingEntity)entity;
            MobEffectInstance mobeffectinstance = livingentity.getEffect(CustomFogRenderer$mobeffectfogfunction.getMobEffect());
            if (mobeffectinstance != null) {
                CustomFogRenderer$mobeffectfogfunction.setupFog(CustomFogRenderer$fogdata, livingentity, mobeffectinstance, g, h);
            }
        } else if (fogtype == FogType.WATER) {
            CustomFogRenderer$fogdata.start = -8.0f;
            CustomFogRenderer$fogdata.end = 96.0f;
            if (entity instanceof LocalPlayer) {
                LocalPlayer localplayer = (LocalPlayer)entity;
                CustomFogRenderer$fogdata.end *= Math.max(0.25f, localplayer.getWaterVision());
                Holder holder = localplayer.level().getBiome(localplayer.blockPosition());
                if (holder.is(BiomeTags.HAS_CLOSER_WATER_FOG)) {
                    CustomFogRenderer$fogdata.end *= 0.85f;
                }
            }
            if (CustomFogRenderer$fogdata.end > g) {
                CustomFogRenderer$fogdata.end = g;
                CustomFogRenderer$fogdata.shape = FogShape.CYLINDER;
            }
        } else if (bl) {
            CustomFogRenderer$fogdata.start = g * 0.05f;
            CustomFogRenderer$fogdata.end = Math.min(g, 192.0f) * 0.5f;
        } else if (arg2 == FogRenderer.FogMode.FOG_SKY) {
            CustomFogRenderer$fogdata.start = 0.0f;
            CustomFogRenderer$fogdata.end = g;
            CustomFogRenderer$fogdata.shape = FogShape.CYLINDER;
        } else {
            float f = Mth.clamp((float)(g / 10.0f), (float)4.0f, (float)64.0f);
            CustomFogRenderer$fogdata.start = g - f;
            CustomFogRenderer$fogdata.end = g;
            CustomFogRenderer$fogdata.shape = FogShape.CYLINDER;
        }
        return Pair.of((Object)Float.valueOf(CustomFogRenderer$fogdata.start), (Object)Float.valueOf(CustomFogRenderer$fogdata.end));
    }

    public static void levelFogColor() {
        RenderSystem.setShaderFogColor((float)fogRed, (float)fogGreen, (float)fogBlue);
    }

    static {
        targetBiomeFog = -1;
        previousBiomeFog = -1;
        biomeChangedTime = -1L;
    }

    @OnlyIn(value=Dist.CLIENT)
    static interface MobEffectFogFunction {
        public Holder<MobEffect> getMobEffect();

        public void setupFog(FogData var1, LivingEntity var2, MobEffectInstance var3, float var4, float var5);

        default public boolean isEnabled(LivingEntity arg, float f) {
            return arg.hasEffect(this.getMobEffect());
        }

        default public float getModifiedVoidDarkness(LivingEntity arg, MobEffectInstance arg2, float f, float g) {
            MobEffectInstance mobeffectinstance = arg.getEffect(this.getMobEffect());
            if (mobeffectinstance != null) {
                f = mobeffectinstance.endsWithin(19) ? 1.0f - (float)mobeffectinstance.getDuration() / 20.0f : 0.0f;
            }
            return f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FogData {
        public final FogRenderer.FogMode mode;
        public float start;
        public float end;
        public FogShape shape = FogShape.SPHERE;

        public FogData(FogRenderer.FogMode mode) {
            this.mode = mode;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class BlindnessFogFunction
    implements MobEffectFogFunction {
        BlindnessFogFunction() {
        }

        @Override
        public Holder<MobEffect> getMobEffect() {
            return MobEffects.BLINDNESS;
        }

        @Override
        public void setupFog(FogData p_234181_, LivingEntity p_234182_, MobEffectInstance p_234183_, float p_234184_, float p_234185_) {
            float f;
            float f2 = f = p_234183_.isInfiniteDuration() ? 5.0f : Mth.lerp((float)Math.min(1.0f, (float)p_234183_.getDuration() / 20.0f), (float)p_234184_, (float)5.0f);
            if (p_234181_.mode == FogRenderer.FogMode.FOG_SKY) {
                p_234181_.start = 0.0f;
                p_234181_.end = f * 0.8f;
            } else {
                p_234181_.start = f * 0.25f;
                p_234181_.end = f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DarknessFogFunction
    implements MobEffectFogFunction {
        DarknessFogFunction() {
        }

        @Override
        public Holder<MobEffect> getMobEffect() {
            return MobEffects.DARKNESS;
        }

        @Override
        public void setupFog(FogData p_234194_, LivingEntity p_234195_, MobEffectInstance p_234196_, float p_234197_, float p_234198_) {
            float f = Mth.lerp((float)p_234196_.getBlendFactor(p_234195_, p_234198_), (float)p_234197_, (float)15.0f);
            p_234194_.start = p_234194_.mode == FogRenderer.FogMode.FOG_SKY ? 0.0f : f * 0.75f;
            p_234194_.end = f;
        }

        @Override
        public float getModifiedVoidDarkness(LivingEntity p_234189_, MobEffectInstance p_234190_, float p_234191_, float p_234192_) {
            return 1.0f - p_234190_.getBlendFactor(p_234189_, p_234192_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum FogMode {
        FOG_SKY,
        FOG_TERRAIN;

    }
}

