/*
 * Decompiled with CFR 0.152.
 */
package net.cloud.betterfog;

public class Sigmoid {
    private float minx;
    private float maxx;
    private float sizex;
    private float miny;
    private float maxy;
    private float sizey;
    private float p;
    private float sp;

    Sigmoid(float minx, float maxx, float miny, float maxy, float p, float sx) {
        float ssx = (maxx - minx) * sx;
        this.minx = sx > 0.0f ? minx + ssx : minx;
        this.maxx = sx < 0.0f ? maxx + ssx : maxx;
        this.sizex = this.maxx - this.minx;
        this.miny = miny;
        this.maxy = maxy;
        this.sizey = this.maxy - this.miny;
        this.p = p;
        this.sp = (float)Sigmoid.sigmoid(p);
    }

    public static Sigmoid sigmoid01(float minx, float maxx, float p, float sx) {
        return new Sigmoid(minx, maxx, 0.0f, 1.0f, p, sx);
    }

    public static Sigmoid sigmoid01(float minx, float maxx, float p) {
        return new Sigmoid(minx, maxx, 0.0f, 1.0f, p, 0.0f);
    }

    public static Sigmoid smoothingSig(float p, float sx) {
        return new Sigmoid(0.0f, 1.0f, 0.0f, 1.0f, p, sx);
    }

    public float pickSig(float x) {
        if (this.p != 0.0f) {
            return (float)(Sigmoid.sigmoid(this.p * (2.0f * x - 1.0f)) / 2.0 * (double)this.sp + 0.5);
        }
        return x;
    }

    public float bs(float x) {
        if (this.sizex > 0.0f) {
            if (x < this.minx) {
                return this.miny;
            }
            if (x > this.maxx) {
                return this.maxy;
            }
        } else {
            if (x < this.maxx) {
                return this.maxy;
            }
            if (x > this.minx) {
                return this.miny;
            }
        }
        return this.sizey * this.pickSig((x - this.minx) / this.sizex) + this.miny;
    }

    public static double sigmoid(double x) {
        return 2.0 / (1.0 + Math.pow(Math.E, -x)) - 1.0;
    }
}

