/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.client.screen.shaking;

import com.teamabnormals.blueprint.client.screen.shaking.PositionedShakeSource;
import java.util.function.Supplier;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;

public class EmanatingShakeSource
extends PositionedShakeSource {
    private final Supplier<Position> position;
    private final Supplier<Boolean> isActive;
    private int deadTicks;

    public EmanatingShakeSource(Supplier<Position> position, Supplier<Boolean> isActive, int duration, double intensityX, double intensityY, double intensityZ, double maxBuildupX, double maxBuildupY, double maxBuildupZ, double decayX, double decayY, double decayZ) {
        super(duration, intensityX, intensityY, intensityZ, maxBuildupX, maxBuildupY, maxBuildupZ, decayX, decayY, decayZ, position.get().x(), position.get().y(), position.get().z());
        this.position = position;
        this.isActive = isActive;
    }

    public EmanatingShakeSource(Supplier<Position> position, Supplier<Boolean> isAlive, int duration, double intensity, double maxBuildup, double decay) {
        super(duration, intensity, maxBuildup, decay, position.get().x(), position.get().y(), position.get().z());
        this.position = position;
        this.isActive = isAlive;
    }

    public EmanatingShakeSource(Entity entity, int duration, double intensityX, double intensityY, double intensityZ, double maxBuildupX, double maxBuildupY, double maxBuildupZ, double decayX, double decayY, double decayZ) {
        this(() -> ((Entity)entity).position(), () -> ((Entity)entity).isAlive(), duration, intensityX, intensityY, intensityZ, maxBuildupX, maxBuildupY, maxBuildupZ, decayX, decayY, decayZ);
    }

    @Override
    public void tick() {
        Position position = this.position.get();
        this.x = position.x();
        this.y = position.y();
        this.z = position.z();
        if (!this.isActive.get().booleanValue()) {
            ++this.deadTicks;
            this.decayX *= (double)0.925f;
            this.decayY *= (double)0.925f;
            this.decayZ *= (double)0.925f;
        }
        super.tick();
    }

    @Override
    public boolean isStopped() {
        return super.isStopped() || this.deadTicks >= 20;
    }
}

