/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.advancement.modification.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierSerializers;
import com.teamabnormals.blueprint.common.advancement.modification.BlueprintAdvancementBuilder;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.AdvancementModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.Criterion;
import net.minecraft.resources.RegistryOps;

public record CriteriaModifier(Map<String, Criterion<?>> criteria, Optional<AdvancementRequirements> requirements, boolean shouldReplaceRequirements, Optional<List<IndexedRequirementsEntry>> indexedRequirements) implements AdvancementModifier<CriteriaModifier>
{
    public static Builder builder(String modId) {
        return new Builder(modId);
    }

    @Override
    public void modify(BlueprintAdvancementBuilder builder) {
        Optional<AdvancementRequirements> requirements;
        builder.criteria.putAll(this.criteria);
        Optional<AdvancementRequirements> requirementsToAdd = this.requirements;
        if (requirementsToAdd.isPresent()) {
            if (this.shouldReplaceRequirements || builder.requirements.isEmpty()) {
                builder.requirements = requirementsToAdd;
            } else {
                ArrayList newRequirements = new ArrayList(builder.requirements.get().requirements());
                newRequirements.addAll(requirementsToAdd.get().requirements());
                builder.requirements = Optional.of(new AdvancementRequirements(newRequirements));
            }
        }
        if ((requirements = builder.requirements).isEmpty()) {
            return;
        }
        Optional<List<IndexedRequirementsEntry>> indexedRequirements = this.indexedRequirements;
        if (indexedRequirements.isPresent()) {
            ArrayList<List<String>> newRequirements = new ArrayList<List<String>>(requirements.get().requirements());
            int length = newRequirements.size();
            for (IndexedRequirementsEntry entry : indexedRequirements.get()) {
                int index = entry.index;
                if (index >= length) continue;
                if (entry.replace) {
                    newRequirements.set(index, entry.requirements);
                    continue;
                }
                ArrayList<String> newList = new ArrayList<String>((Collection)newRequirements.get(index));
                newList.addAll(entry.requirements);
                newRequirements.set(index, newList);
            }
            builder.requirements = Optional.of(new AdvancementRequirements(newRequirements));
        }
    }

    public Serializer getSerializer() {
        return AdvancementModifierSerializers.CRITERIA;
    }

    public static final class Builder {
        private final String modId;
        private final Map<String, Criterion<?>> criteria = Maps.newLinkedHashMap();
        private final List<IndexedRequirementsEntry> indexedRequirements = new LinkedList<IndexedRequirementsEntry>();
        @Nullable
        private AdvancementRequirements requirements;
        private boolean shouldReplaceRequirements = false;

        private Builder(String modId) {
            this.modId = modId;
        }

        public Builder addCriterionRaw(String key, Criterion<?> criterion) {
            if (this.criteria.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate criterion: " + key);
            }
            this.criteria.put(key, criterion);
            return this;
        }

        public Builder addCriterion(String key, Criterion<?> criterion) {
            return this.addCriterionRaw(this.modId + ":" + key, criterion);
        }

        public Builder requirements(List<List<String>> requirements) {
            this.requirements = new AdvancementRequirements(requirements);
            return this;
        }

        public Builder requirements(Collection<String> requirements, AdvancementRequirements.Strategy requirementsStrategy) {
            this.requirements = requirementsStrategy.create(requirements);
            return this;
        }

        public Builder requirements(AdvancementRequirements.Strategy requirementsStrategy) {
            this.requirements = requirementsStrategy.create(this.criteria.keySet());
            return this;
        }

        public Builder shouldReplaceRequirements(boolean shouldReplaceRequirements) {
            this.shouldReplaceRequirements = shouldReplaceRequirements;
            return this;
        }

        public Builder addIndexedRequirementsRaw(int index, boolean replace, String ... requirements) {
            this.indexedRequirements.add(new IndexedRequirementsEntry(index, replace, List.of(requirements)));
            return this;
        }

        public Builder addIndexedRequirements(int index, boolean replace, String ... requirements) {
            int length = requirements.length;
            String[] prefixedRequirements = new String[length];
            String prefix = this.modId + ":";
            for (int i = 0; i < length; ++i) {
                prefixedRequirements[i] = prefix + requirements[i];
            }
            return this.addIndexedRequirementsRaw(index, replace, prefixedRequirements);
        }

        public CriteriaModifier build() {
            Map<String, Criterion<?>> criteria = this.criteria;
            if (criteria.isEmpty()) {
                throw new IllegalStateException("Cannot have no criteria!");
            }
            return new CriteriaModifier((Map<String, Criterion<?>>)ImmutableMap.copyOf(criteria), Optional.ofNullable(this.requirements), this.shouldReplaceRequirements, (Optional<List<IndexedRequirementsEntry>>)Optional.of(ImmutableList.copyOf(this.indexedRequirements)));
        }
    }

    public record IndexedRequirementsEntry(int index, boolean replace, List<String> requirements) {
        private static final Codec<IndexedRequirementsEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("index").forGetter(IndexedRequirementsEntry::index), (App)Codec.BOOL.fieldOf("replace").forGetter(IndexedRequirementsEntry::replace), (App)Codec.STRING.listOf().fieldOf("requirements").forGetter(IndexedRequirementsEntry::requirements)).apply((Applicative)instance, IndexedRequirementsEntry::new));
    }

    public static final class Serializer
    implements AdvancementModifier.Serializer<CriteriaModifier> {
        private static final Codec<Map<String, Criterion<?>>> CRITERIA_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Criterion.CODEC).validate(map -> map.isEmpty() ? DataResult.error(() -> "Advancement criteria cannot be empty") : DataResult.success((Object)map));
        private static final Codec<CriteriaModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CRITERIA_CODEC.fieldOf("criteria").forGetter(CriteriaModifier::criteria), (App)AdvancementRequirements.CODEC.optionalFieldOf("requirements").forGetter(CriteriaModifier::requirements), (App)Codec.BOOL.fieldOf("should_replace_requirements").forGetter(CriteriaModifier::shouldReplaceRequirements), (App)IndexedRequirementsEntry.CODEC.listOf().optionalFieldOf("indexed_requirements").forGetter(CriteriaModifier::indexedRequirements)).apply((Applicative)instance, CriteriaModifier::new));

        @Override
        public JsonElement serialize(CriteriaModifier modifier, RegistryOps<JsonElement> ops) throws JsonParseException {
            DataResult result = CODEC.encodeStart(ops, (Object)modifier);
            Optional error = result.error();
            if (error.isPresent()) {
                throw new JsonParseException(((DataResult.Error)error.get()).message());
            }
            return (JsonElement)result.result().get();
        }

        @Override
        public CriteriaModifier deserialize(JsonElement element, RegistryOps<JsonElement> ops) throws JsonParseException {
            DataResult result = CODEC.decode(ops, (Object)element);
            Optional error = result.error();
            if (error.isPresent()) {
                throw new JsonParseException(((DataResult.Error)error.get()).message());
            }
            return (CriteriaModifier)((Pair)result.result().get()).getFirst();
        }
    }
}

