/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.block.chest;

import com.teamabnormals.blueprint.common.block.entity.BlueprintTrappedChestBlockEntity;
import com.teamabnormals.blueprint.core.api.IChestBlock;
import com.teamabnormals.blueprint.core.registry.BlueprintBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlueprintTrappedChestBlock
extends ChestBlock
implements IChestBlock {
    public final String type;

    public BlueprintTrappedChestBlock(String type, BlockBehaviour.Properties props) {
        super(props, () -> BlueprintBlockEntityTypes.TRAPPED_CHEST.get());
        this.type = type;
    }

    @Override
    public String getChestMaterialsName() {
        return this.type;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlueprintTrappedChestBlockEntity(pos, state);
    }

    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.CUSTOM.get((Object)Stats.TRIGGER_TRAPPED_CHEST);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return Mth.clamp((int)ChestBlockEntity.getOpenCount((BlockGetter)getter, (BlockPos)pos), (int)0, (int)15);
    }

    public int getDirectSignal(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return face == Direction.UP ? state.getSignal(getter, pos, face) : 0;
    }
}

