/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.entity;

import com.teamabnormals.blueprint.client.renderer.HasBlueprintBoatType;
import com.teamabnormals.blueprint.core.registry.BlueprintBoatTypes;
import com.teamabnormals.blueprint.core.registry.BlueprintEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BlueprintBoat
extends Boat
implements HasBlueprintBoatType {
    private static final EntityDataAccessor<String> BOAT_TYPE = SynchedEntityData.defineId(BlueprintBoat.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public BlueprintBoat(EntityType<? extends BlueprintBoat> type, Level level) {
        super(type, level);
    }

    public BlueprintBoat(Level level, ResourceLocation type, double x, double y, double z) {
        this((EntityType<? extends BlueprintBoat>)((EntityType)BlueprintEntityTypes.BOAT.get()), level);
        this.setType(type);
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BOAT_TYPE, (Object)BlueprintBoatTypes.UNDEFINED_BOAT_LOCATION.toString());
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352110_) {
        return super.getAddEntityPacket(p_352110_);
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putString("Type", (String)this.entityData.get(BOAT_TYPE));
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("Type", 8)) {
            String type = compound.getString("Type");
            ResourceLocation name = ResourceLocation.parse((String)type);
            if (BlueprintBoatTypes.getType(name) != null) {
                this.setType(name);
            } else {
                this.setType(BlueprintBoatTypes.UNDEFINED_BOAT_LOCATION);
            }
        } else {
            this.setType(BlueprintBoatTypes.UNDEFINED_BOAT_LOCATION);
        }
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.lastYd = this.getDeltaMovement().y;
        if (!this.isPassenger()) {
            if (onGroundIn) {
                if (this.fallDistance > 3.0f) {
                    if (this.status != Boat.Status.ON_LAND) {
                        this.fallDistance = 0.0f;
                        return;
                    }
                    this.causeFallDamage(this.fallDistance, 1.0f, this.damageSources().fall());
                    if (!this.level().isClientSide && this.isAlive()) {
                        this.kill();
                        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            for (int i = 0; i < 3; ++i) {
                                this.spawnAtLocation((ItemLike)this.getBoatType().getPlankItem());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.spawnAtLocation((ItemLike)Items.STICK);
                            }
                        }
                    }
                }
                this.fallDistance = 0.0f;
            } else if (!this.level().getFluidState(this.blockPosition().below()).is(FluidTags.WATER) && y < 0.0) {
                this.fallDistance = (float)((double)this.fallDistance - y);
            }
        }
    }

    public Item getDropItem() {
        return this.getBoatType().getBoatItem();
    }

    public Boat.Type getVariant() {
        return Boat.Type.OAK;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity p_294665_, EntityDimensions p_295933_, float p_295585_) {
        float f = this.getSinglePassengerXOffset();
        if (this.getPassengers().size() > 1) {
            int i = this.getPassengers().indexOf(p_294665_);
            f = i == 0 ? 0.2f : -0.6f;
            if (p_294665_ instanceof Animal) {
                f += 0.2f;
            }
        }
        return new Vec3(0.0, this.getBoatType().isRaft() ? (double)(p_295933_.height() * 0.8888889f) : (double)(p_295933_.height() / 3.0f), (double)f).yRot(-this.getYRot() * ((float)Math.PI / 180));
    }

    public void setType(ResourceLocation type) {
        this.entityData.set(BOAT_TYPE, (Object)type.toString());
    }

    @Override
    public BlueprintBoatTypes.BlueprintBoatType getBoatType() {
        return BlueprintBoatTypes.getType(ResourceLocation.parse((String)((String)this.entityData.get(BOAT_TYPE))));
    }
}

