/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.common.remolder.RemolderLoader;
import com.teamabnormals.blueprint.common.remolder.Remolding;
import com.teamabnormals.blueprint.common.remolder.data.DataType;
import com.teamabnormals.blueprint.common.remolder.data.JsonMolding;
import com.teamabnormals.blueprint.common.remolder.data.Molding;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.util.registry.BasicRegistry;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceMetadata;

public final class MoldingTypes {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final BasicRegistry<MoldingType<?>> REGISTRY = new BasicRegistry();
    public static final Codec<MoldingType<?>> TYPE_CODEC = REGISTRY;
    public static final MetadataSectionSerializer<JsonElement> JSON_METADATA_SERIALIZER = new MetadataSectionSerializer<JsonElement>(){

        public String getMetadataSectionName() {
            return "json";
        }

        public JsonElement fromJson(JsonObject object) {
            return object;
        }
    };
    public static final MoldingType<JsonElement> JSON = MoldingTypes.register("json", JsonMolding.ELEMENT_DATA_TYPE, JsonMolding::new, JsonOps.INSTANCE, resource -> {
        JsonElement jsonElement;
        block8: {
            BufferedReader reader = resource.openAsReader();
            try {
                jsonElement = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException | IllegalArgumentException exception) {
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return jsonElement;
    }, MoldingTypes::serializeJsonElement, new String[]{"json"});

    public static synchronized <T> MoldingType<T> register(String name, DataType<T> dataType, Molding.Factory factory, DynamicOps<T> ops, Function<Resource, T> deserializer, Function<T, byte[]> serializer, String ... fileExtensions) {
        MoldingType<T> moldingType = new MoldingType<T>(dataType, factory, ops, deserializer, serializer, fileExtensions);
        REGISTRY.register(name, moldingType);
        return moldingType;
    }

    private static byte[] serializeJsonElement(JsonElement element) {
        return GSON.toJson(element).getBytes(StandardCharsets.UTF_8);
    }

    public record MoldingType<T>(DataType<T> dataType, Molding.Factory factory, DynamicOps<T> ops, Function<Resource, T> deserializer, Function<T, byte[]> serializer, String[] fileExtensions) {
        private static <T> T getMetadata(Resource resource, DynamicOps<T> ops) {
            try {
                Optional optional = resource.metadata().getSection(JSON_METADATA_SERIALIZER);
                if (optional.isPresent()) {
                    return (T)(ops instanceof JsonOps ? optional.get() : JsonOps.INSTANCE.convertTo(ops, (JsonElement)optional.get()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        private static void logFailedRemolder(Remolding<?> remolding, Exception exception, String location) {
            Blueprint.LOGGER.error("Error while applying remolder {}: {}", remolding, (Object)exception);
            Blueprint.LOGGER.warn("Restoring and stopping Remolder data changes at location: {}", (Object)location);
        }

        public Resource remold(String location, Resource resource, List<RemolderLoader.Entry> entries) {
            Object root = this.deserializer().apply(resource);
            if (root == null) {
                return resource;
            }
            String pack = resource.sourcePackId();
            DynamicOps<T> ops = this.ops;
            Object metadata = MoldingType.getMetadata(resource, ops);
            for (RemolderLoader.Entry entry : entries) {
                Pair<?, ?> result;
                if (!entry.packFilter().test(pack)) continue;
                try {
                    result = entry.remolding().apply(ops, root, metadata);
                }
                catch (Exception exception) {
                    MoldingType.logFailedRemolder(entry.remolding(), exception, location);
                    return resource;
                }
                root = result.getFirst();
                metadata = result.getSecond();
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(this.serializer().apply(root));
            if (metadata == null) {
                return new RemoldedResource(resource.source(), (IoSupplier<InputStream>)((IoSupplier)() -> inputStream));
            }
            try {
                JsonElement element;
                ResourceMetadata resourceMetadata = ResourceMetadata.fromJsonStream((InputStream)new ByteArrayInputStream(MoldingTypes.serializeJsonElement(metadata instanceof JsonElement ? (element = (JsonElement)metadata) : (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, metadata))));
                return new RemoldedResource(resource.source(), (IoSupplier<InputStream>)((IoSupplier)() -> inputStream), (IoSupplier<ResourceMetadata>)((IoSupplier)() -> resourceMetadata));
            }
            catch (IOException exception) {
                Blueprint.LOGGER.error("Failed to serialize metadata", (Throwable)exception);
                return resource;
            }
        }
    }

    private static class RemoldedResource
    extends Resource {
        public RemoldedResource(PackResources source, IoSupplier<InputStream> streamSupplier) {
            super(source, streamSupplier);
        }

        public RemoldedResource(PackResources source, IoSupplier<InputStream> streamSupplier, IoSupplier<ResourceMetadata> metadataSupplier) {
            super(source, streamSupplier, metadataSupplier);
        }

        public Optional<KnownPack> knownPackInfo() {
            return Optional.empty();
        }
    }
}

