/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification.chunk.modifiers;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.common.world.modification.chunk.ChunkGeneratorModifierSerializers;
import com.teamabnormals.blueprint.common.world.modification.chunk.modifiers.ChunkGeneratorModifier;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.mixin.NoiseGeneratorSettingsMixin;
import com.teamabnormals.blueprint.core.registry.BlueprintSurfaceRules;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;

public final class SurfaceRuleModifier
implements ChunkGeneratorModifier<SurfaceRuleModifier> {
    public static final Codec<SurfaceRuleModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SurfaceRules.RuleSource.CODEC.fieldOf("surface_rule").forGetter(modifier -> modifier.surfaceRule), (App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(modifier -> modifier.replace)).apply((Applicative)instance, SurfaceRuleModifier::new));
    private final SurfaceRules.RuleSource surfaceRule;
    private final boolean replace;

    public SurfaceRuleModifier(SurfaceRules.RuleSource surfaceRule, boolean replace) {
        this.surfaceRule = surfaceRule;
        this.replace = replace;
    }

    @Override
    public void modify(ChunkGenerator chunkGenerator) {
        if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
            SurfaceRules.RuleSource newRuleSource;
            NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            NoiseGeneratorSettings settings = (NoiseGeneratorSettings)noiseBasedChunkGenerator.generatorSettings().value();
            if (this.replace) {
                newRuleSource = this.surfaceRule;
            } else {
                SurfaceRules.RuleSource ruleSource = settings.surfaceRule();
                if (ruleSource instanceof BlueprintSurfaceRules.TransientMergedRuleSource) {
                    BlueprintSurfaceRules.TransientMergedRuleSource transientMergedRuleSource = (BlueprintSurfaceRules.TransientMergedRuleSource)ruleSource;
                    transientMergedRuleSource.sequence().add(0, this.surfaceRule);
                    newRuleSource = ruleSource;
                } else if (ruleSource instanceof SurfaceRules.SequenceRuleSource) {
                    SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)ruleSource;
                    List sequence = sequenceRuleSource.sequence();
                    ArrayList<SurfaceRules.RuleSource> newSequence = new ArrayList<SurfaceRules.RuleSource>(sequence.size() + 1);
                    newSequence.add(this.surfaceRule);
                    newSequence.addAll(sequence);
                    newRuleSource = new BlueprintSurfaceRules.TransientMergedRuleSource(newSequence, (SurfaceRules.RuleSource)sequenceRuleSource);
                } else {
                    newRuleSource = new BlueprintSurfaceRules.TransientMergedRuleSource(Lists.newArrayList((Object[])new SurfaceRules.RuleSource[]{this.surfaceRule, ruleSource}), ruleSource);
                }
            }
            ((NoiseGeneratorSettingsMixin)settings).setSurfaceRule(newRuleSource);
        } else {
            Blueprint.LOGGER.warn("Could not apply surface rule modifier because " + String.valueOf(chunkGenerator) + " was not an instance of NoiseBasedChunkGenerator");
        }
    }

    public Serializer getSerializer() {
        return ChunkGeneratorModifierSerializers.SURFACE_RULE;
    }

    public static final class Serializer
    implements ChunkGeneratorModifier.Serializer<SurfaceRuleModifier> {
        @Override
        public JsonElement serialize(SurfaceRuleModifier modifier, RegistryOps<JsonElement> additional) throws JsonParseException {
            DataResult dataResult = CODEC.encodeStart(additional, (Object)modifier);
            Optional result = dataResult.result();
            if (result.isPresent()) {
                return (JsonElement)result.get();
            }
            throw new JsonParseException(((DataResult.Error)dataResult.error().get()).message());
        }

        @Override
        public SurfaceRuleModifier deserialize(JsonElement element, RegistryOps<JsonElement> additional) throws JsonParseException {
            DataResult dataResult = CODEC.decode(additional, (Object)element);
            Optional result = dataResult.result();
            if (result.isPresent()) {
                return (SurfaceRuleModifier)((Pair)result.get()).getFirst();
            }
            throw new JsonParseException(((DataResult.Error)dataResult.error().get()).message());
        }
    }
}

