/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.events;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.common.NeoForge;

public class FallingBlockEvent
extends Event {
    private FallingBlockEntity fallingBlockEntity;

    public FallingBlockEvent(FallingBlockEntity fallingBlockEntity) {
        this.fallingBlockEntity = fallingBlockEntity;
    }

    public FallingBlockEntity getEntity() {
        return this.fallingBlockEntity;
    }

    public void setEntity(FallingBlockEntity fallingBlockEntity) {
        this.fallingBlockEntity = fallingBlockEntity;
    }

    public static FallingBlockEntity onBlockFall(Level level, BlockPos pos, BlockState state, FallingBlockEntity fallingBlockEntity) {
        BlockFallEvent event = new BlockFallEvent(level, pos, state, fallingBlockEntity);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getEntity();
    }

    public static boolean onFallingBlockTick(FallingBlockEntity fallingBlockEntity) {
        return ((FallingBlockTickEvent)NeoForge.EVENT_BUS.post((Event)new FallingBlockTickEvent(fallingBlockEntity))).isCanceled();
    }

    public static class BlockFallEvent
    extends FallingBlockEvent {
        private final Level level;
        private final BlockPos pos;
        private final BlockState state;

        public BlockFallEvent(Level level, BlockPos pos, BlockState state, FallingBlockEntity fallingBlockEntity) {
            super(fallingBlockEntity);
            this.level = level;
            this.pos = pos;
            this.state = state;
        }

        public Level getLevel() {
            return this.level;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public BlockState getState() {
            return this.state;
        }
    }

    public static class FallingBlockTickEvent
    extends FallingBlockEvent
    implements ICancellableEvent {
        public FallingBlockTickEvent(FallingBlockEntity fallingBlockEntity) {
            super(fallingBlockEntity);
        }
    }
}

