/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.mixin;

import com.teamabnormals.blueprint.common.remolder.RemoldableResourceManager;
import com.teamabnormals.blueprint.common.remolder.RemolderLoader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPackResourceManager.class})
public abstract class MultiPackResourceManagerMixin
implements RemoldableResourceManager {
    private RemolderLoader remolderLoader;

    @Inject(method={"getResource"}, at={@At(value="RETURN")}, cancellable=true)
    private void getRemoldedResource(ResourceLocation location, CallbackInfoReturnable<Optional<Resource>> info) {
        if (this.remolderLoader == null) {
            return;
        }
        info.setReturnValue(this.remolderLoader.getResource(location, (Optional)info.getReturnValue()));
    }

    @Inject(method={"getResourceStack"}, at={@At(value="RETURN")}, cancellable=true)
    private void getRemoldedResourceStack(ResourceLocation location, CallbackInfoReturnable<List<Resource>> info) {
        if (this.remolderLoader == null) {
            return;
        }
        info.setReturnValue(this.remolderLoader.getResourceStack((List)info.getReturnValue(), location));
    }

    @Inject(method={"listResources"}, at={@At(value="RETURN")}, cancellable=true)
    private void listRemoldedResources(String path, Predicate<ResourceLocation> filter, CallbackInfoReturnable<Map<ResourceLocation, Resource>> info) {
        if (this.remolderLoader == null) {
            return;
        }
        info.setReturnValue(this.remolderLoader.listResources((Map)info.getReturnValue()));
    }

    @Inject(method={"listResourceStacks"}, at={@At(value="RETURN")}, cancellable=true)
    private void listRemoldedResourceStacks(String path, Predicate<ResourceLocation> filter, CallbackInfoReturnable<Map<ResourceLocation, List<Resource>>> info) {
        if (this.remolderLoader == null) {
            return;
        }
        info.setReturnValue(this.remolderLoader.listResourceStacks((Map)info.getReturnValue()));
    }

    @Override
    public RemolderLoader updateRemolderLoader(PackType packType) {
        this.remolderLoader = new RemolderLoader(this, packType);
        return this.remolderLoader;
    }

    @Override
    public RemolderLoader getRemolderLoader() {
        return this.remolderLoader;
    }
}

