/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class BlockUtil {
    public static boolean isBlockInWater(Level level, BlockPos pos) {
        if (level.getBlockState(pos).getFluidState().is(FluidTags.WATER)) {
            return true;
        }
        for (Direction direction : Direction.values()) {
            if (!level.getFluidState(pos.relative(direction)).is(FluidTags.WATER)) continue;
            return true;
        }
        return false;
    }

    public static boolean canPlace(Level level, @Nullable Player player, BlockPos pos, BlockState state) {
        CollisionContext selectionContext = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        VoxelShape voxelshape = state.getCollisionShape((BlockGetter)level, pos, selectionContext);
        VoxelShape offsetShape = level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos);
        return (offsetShape.isEmpty() || level.getBlockState(pos).canBeReplaced()) && state.canSurvive((LevelReader)level, pos) && level.isUnobstructed(null, voxelshape.move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
    }

    public static SoundEvent getPlaceSound(BlockState state, Level level, BlockPos pos, @Nullable Entity entity) {
        return state.getSoundType((LevelReader)level, pos, entity).getPlaceSound();
    }

    public static boolean isPosNotTouchingBlock(LevelAccessor level, BlockPos pos, Block blockToCheck, Direction ... blacklistedDirections) {
        for (Direction directions : Direction.values()) {
            List<Direction> blacklistedDirectionsList = Arrays.asList(blacklistedDirections);
            if (blacklistedDirectionsList.contains(directions) || level.getBlockState(pos.relative(directions)).getBlock() != blockToCheck) continue;
            return false;
        }
        return true;
    }

    public static BlockState transferAllBlockStates(BlockState initial, BlockState after) {
        BlockState block = after;
        for (Property property : initial.getBlock().getStateDefinition().getProperties()) {
            if (!after.hasProperty(property) || initial.getValue(property) == null) continue;
            block = (BlockState)block.setValue(property, initial.getValue(property));
        }
        return block;
    }

    public static BlockPos offsetPos(BlockSource source) {
        return source.pos().relative((Direction)source.state().getValue((Property)DirectionalBlock.FACING));
    }

    public static BlockState getStateAtOffsetPos(BlockSource source) {
        return source.level().getBlockState(BlockUtil.offsetPos(source));
    }

    public static <T extends Entity> List<T> getEntitiesAtOffsetPos(BlockSource source, Class<T> entityType) {
        return source.level().getEntitiesOfClass(entityType, new AABB(BlockUtil.offsetPos(source)));
    }

    public static <T extends Entity> List<T> getEntitiesAtOffsetPos(BlockSource source, Class<T> entityType, Predicate<? super T> predicate) {
        return source.level().getEntitiesOfClass(entityType, new AABB(BlockUtil.offsetPos(source)), predicate);
    }
}

