/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.item;

import com.teamabnormals.blueprint.core.util.item.ItemStackUtil;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public final class CreativeModeTabContentsPopulator {
    private static final TreeMap<String, Entry> ENTRIES = new TreeMap();

    public static synchronized Entry mod(String id) {
        return ENTRIES.computeIfAbsent(id, key -> new Entry());
    }

    public static void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        ENTRIES.values().forEach(entry -> entry.onBuildCreativeModeTabContents(event));
    }

    public static final class Entry {
        private final HashMap<ResourceKey<CreativeModeTab>, ArrayList<CreativeModeTabContentsEditor>> keyedContentEditors = new HashMap();
        private final HashMap<Predicate<BuildCreativeModeTabContentsEvent>, ArrayList<CreativeModeTabContentsEditor>> otherContentEditors = new HashMap();
        private CreativeModeTab.TabVisibility visibility = CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS;
        private ArrayList<CreativeModeTabContentsEditor> currentEditors = null;

        public Entry visibility(CreativeModeTab.TabVisibility visibility) {
            this.visibility = visibility;
            return this;
        }

        public Entry tab(ResourceKey<CreativeModeTab> tabKey) {
            this.currentEditors = this.keyedContentEditors.computeIfAbsent(tabKey, key -> new ArrayList());
            return this;
        }

        public Entry predicate(Predicate<BuildCreativeModeTabContentsEvent> predicate) {
            this.currentEditors = this.otherContentEditors.computeIfAbsent(predicate, key -> new ArrayList());
            return this;
        }

        public Entry editor(CreativeModeTabContentsEditor editor) {
            this.currentEditors.add(editor);
            return this;
        }

        @SafeVarargs
        public final Entry addStacks(Supplier<ItemStack> ... items) {
            return this.editor(CreativeModeTabContentsEditor.forAllStacks(items, (event, stack) -> event.accept(stack, this.visibility)));
        }

        @SafeVarargs
        public final Entry addItems(Supplier<? extends ItemLike> ... items) {
            return this.addStacks(Entry.convertItemLikesToStacks(items));
        }

        @SafeVarargs
        public final Entry addStacksFirst(Supplier<ItemStack> ... items) {
            return this.editor(CreativeModeTabContentsEditor.forAllStacks(items, (event, stack) -> event.insertFirst(stack, this.visibility)));
        }

        @SafeVarargs
        public final Entry addItemsFirst(Supplier<? extends ItemLike> ... items) {
            return this.addStacksFirst(Entry.convertItemLikesToStacks(items));
        }

        @SafeVarargs
        private static void addStacksAfter(BuildCreativeModeTabContentsEvent event, CreativeModeTab.TabVisibility visibility, ObjectSortedSet<ItemStack> entries, Predicate<ItemStack> predicate, Supplier<ItemStack> ... items) {
            for (ItemStack stack : entries) {
                if (!predicate.test(stack)) continue;
                for (Supplier<ItemStack> item : items) {
                    ItemStack itemValue = item.get();
                    event.insertAfter(stack, itemValue, visibility);
                    stack = itemValue;
                }
                return;
            }
        }

        @SafeVarargs
        public final Entry addStacksAfter(Predicate<ItemStack> predicate, Supplier<ItemStack> ... items) {
            return this.editor(event -> {
                CreativeModeTab.TabVisibility visibility = this.visibility;
                if (visibility == CreativeModeTab.TabVisibility.PARENT_TAB_ONLY || visibility == CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS) {
                    Entry.addStacksAfter(event, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY, (ObjectSortedSet<ItemStack>)event.getParentEntries(), predicate, items);
                }
                if (visibility == CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY || visibility == CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS) {
                    Entry.addStacksAfter(event, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY, (ObjectSortedSet<ItemStack>)event.getSearchEntries(), predicate, items);
                }
            });
        }

        @SafeVarargs
        public final Entry addItemsAfter(Predicate<ItemStack> predicate, Supplier<? extends ItemLike> ... items) {
            return this.addStacksAfter(predicate, Entry.convertItemLikesToStacks(items));
        }

        @SafeVarargs
        private static void addStacksBefore(BuildCreativeModeTabContentsEvent event, CreativeModeTab.TabVisibility visibility, ObjectSortedSet<ItemStack> entries, Predicate<ItemStack> predicate, Supplier<ItemStack> ... items) {
            for (ItemStack stack : entries) {
                if (!predicate.test(stack)) continue;
                for (Supplier<ItemStack> item : items) {
                    event.insertBefore(stack, item.get(), visibility);
                }
                return;
            }
        }

        @SafeVarargs
        public final Entry addStacksBefore(Predicate<ItemStack> predicate, Supplier<ItemStack> ... items) {
            return this.editor(event -> {
                CreativeModeTab.TabVisibility visibility = this.visibility;
                if (visibility == CreativeModeTab.TabVisibility.PARENT_TAB_ONLY || visibility == CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS) {
                    Entry.addStacksBefore(event, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY, (ObjectSortedSet<ItemStack>)event.getParentEntries(), predicate, items);
                }
                if (visibility == CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY || visibility == CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS) {
                    Entry.addStacksBefore(event, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY, (ObjectSortedSet<ItemStack>)event.getSearchEntries(), predicate, items);
                }
            });
        }

        @SafeVarargs
        public final Entry addItemsBefore(Predicate<ItemStack> predicate, Supplier<? extends ItemLike> ... items) {
            return this.addStacksBefore(predicate, Entry.convertItemLikesToStacks(items));
        }

        @SafeVarargs
        private static void addStacksAlphabetically(BuildCreativeModeTabContentsEvent event, CreativeModeTab.TabVisibility visibility, ObjectSortedSet<ItemStack> entries, Predicate<ItemStack> shouldCompareToStack, String trimRegex, Supplier<ItemStack> ... items) {
            TreeMap<String, ItemStack> treeMap = new TreeMap<String, ItemStack>();
            String lastPath = "";
            for (ItemStack stack : entries) {
                Optional key = BuiltInRegistries.ITEM.getResourceKey((Object)stack.getItem());
                if (!key.isPresent() || !shouldCompareToStack.test(stack)) continue;
                String path = ((ResourceKey)key.get()).location().getPath().replaceAll(trimRegex, "");
                if (path.compareTo(lastPath) <= 0) break;
                treeMap.putIfAbsent(path, stack);
                lastPath = path;
            }
            for (Supplier<ItemStack> supplier : items) {
                ItemStack stack = supplier.get();
                Optional key = BuiltInRegistries.ITEM.getResourceKey((Object)stack.getItem());
                if (key.isEmpty()) continue;
                String path = ((ResourceKey)key.get()).location().getPath().replace(trimRegex, "");
                Map.Entry entry = treeMap.floorEntry(path);
                if (entry != null) {
                    event.insertAfter((ItemStack)entry.getValue(), stack, visibility);
                } else {
                    Map.Entry firstEntry = treeMap.firstEntry();
                    if (firstEntry != null) {
                        event.insertBefore((ItemStack)firstEntry.getValue(), stack, visibility);
                    } else {
                        event.accept(stack, visibility);
                    }
                }
                treeMap.put(path, stack);
            }
        }

        @SafeVarargs
        public final Entry addStacksAlphabetically(Predicate<ItemStack> shouldCompareToStack, String trimRegex, Supplier<ItemStack> ... items) {
            return this.editor(event -> {
                CreativeModeTab.TabVisibility visibility = this.visibility;
                if (visibility == CreativeModeTab.TabVisibility.PARENT_TAB_ONLY || visibility == CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS) {
                    Entry.addStacksAlphabetically(event, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY, (ObjectSortedSet<ItemStack>)event.getParentEntries(), shouldCompareToStack, trimRegex, items);
                }
                if (visibility == CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY || visibility == CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS) {
                    Entry.addStacksAlphabetically(event, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY, (ObjectSortedSet<ItemStack>)event.getSearchEntries(), shouldCompareToStack, trimRegex, items);
                }
            });
        }

        @SafeVarargs
        public final Entry addItemsAlphabetically(Predicate<ItemStack> shouldCompareToStack, String trimRegex, Supplier<? extends ItemLike> ... items) {
            return this.addStacksAlphabetically(shouldCompareToStack, trimRegex, Entry.convertItemLikesToStacks(items));
        }

        @SafeVarargs
        public final Entry addSpawnEggsAlphabetically(Supplier<? extends ItemLike> ... items) {
            return this.addItemsAlphabetically(ItemStackUtil.is(SpawnEggItem.class), "spawn_egg|_", items);
        }

        @SafeVarargs
        public final Entry addPotterySherdsAlphabetically(Supplier<? extends ItemLike> ... items) {
            return this.addItemsAlphabetically(stack -> stack.is(ItemTags.DECORATED_POT_SHERDS), "pottery_sherd|_", items);
        }

        private void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
            ArrayList<CreativeModeTabContentsEditor> editorsForKey = this.keyedContentEditors.get(event.getTabKey());
            if (editorsForKey != null) {
                editorsForKey.forEach(editor -> editor.edit(event));
            }
            this.otherContentEditors.forEach((eventPredicate, editors) -> {
                if (eventPredicate.test(event)) {
                    editors.forEach(editor -> editor.edit(event));
                }
            });
        }

        private static Supplier<ItemStack>[] convertItemLikesToStacks(Supplier<? extends ItemLike> ... items) {
            int length = items.length;
            Supplier[] newItems = new Supplier[length];
            for (int i = 0; i < length; ++i) {
                int finalI = i;
                newItems[i] = () -> new ItemStack((ItemLike)items[finalI].get());
            }
            return newItems;
        }
    }

    @FunctionalInterface
    public static interface CreativeModeTabContentsEditor {
        public void edit(BuildCreativeModeTabContentsEvent var1);

        public static CreativeModeTabContentsEditor forAllStacks(Supplier<ItemStack>[] items, BiConsumer<BuildCreativeModeTabContentsEvent, ItemStack> consumer) {
            return event -> {
                for (Supplier supplier : items) {
                    consumer.accept(event, (ItemStack)supplier.get());
                }
            };
        }
    }
}

