/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.unusual.blockfactorysbosses.procedures.SnowCloudParticleVisualScaleProcedure;

@OnlyIn(value=Dist.CLIENT)
public class BlazingFlameParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private final float random_roll = 1.2f * (float)Math.random();

    public static BlazingFlameParticleProvider provider(SpriteSet spriteSet) {
        return new BlazingFlameParticleProvider(spriteSet);
    }

    protected BlazingFlameParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.setSize(0.9f, 0.9f);
        this.lifetime = 15;
        this.gravity = 0.0f;
        this.hasPhysics = true;
        this.xd = vx * 0.4;
        this.yd = vy * 0.4;
        this.zd = vz * 0.4;
        this.roll = this.random_roll;
        this.pickSprite(spriteSet);
        this.setAlpha(0.8f);
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    public float getQuadSize(float scale) {
        ClientLevel world = this.level;
        return super.getQuadSize(scale) * 4.0f * (float)SnowCloudParticleVisualScaleProcedure.execute(this.age);
    }

    public void tick() {
        super.tick();
        this.oRoll = this.roll;
        this.roll = this.random_roll;
        this.rCol = 1.0f * (float)(1 - this.age / 16) + 1.0f * (float)(this.age / 16);
        this.gCol = 1.0f * (float)(1 - this.age / 16) + 0.0f * (float)(this.age / 16);
        this.bCol = 1.0f * (float)(1 - this.age / 16) + 0.0f * (float)(this.age / 16);
        if (!this.removed) {
            this.setSprite(this.spriteSet.get(this.age / 1 % 16 + 1, 16));
        }
    }

    public static class BlazingFlameParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public BlazingFlameParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new BlazingFlameParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

