/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.unusual.blockfactorysbosses.configuration.ConfigFileConfiguration;
import net.unusual.blockfactorysbosses.entity.NullPrEntity;
import net.unusual.blockfactorysbosses.entity.SlowRotMoveControl;
import net.unusual.blockfactorysbosses.procedures.YetiEntityDiesProcedure;
import net.unusual.blockfactorysbosses.procedures.YetiEntityIsHurtProcedure;
import net.unusual.blockfactorysbosses.procedures.YetiOnEntityTickUpdateProcedure;

public class YetiEntity
extends Monster
implements RangedAttackMob {
    public final AnimationState dieAnimationState = new AnimationState();
    public final AnimationState spawnAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState hitAnimationState = new AnimationState();
    public final AnimationState throwAnimationState = new AnimationState();
    public final AnimationState leapAnimationState = new AnimationState();
    public final AnimationState leapEndAnimationState = new AnimationState();
    public final AnimationState angryAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> DATA_spawn_animtime = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_hit_animtime = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_cooldown = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_animtime = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_phase = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_throw_cooldown = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_throw_animtime = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_has_icespike = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_leap_cooldown = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_leap_animtime = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_groundsmash_cooldown = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_groundsmash_animtime = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_stuck_animtime = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_battle_time = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_die_animtime = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_source_uuid = SynchedEntityData.defineId(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public YetiEntity(EntityType<YetiEntity> type, Level world) {
        super(type, world);
        this.xpReward = 500;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setInvisible(true);
        this.moveControl = new SlowRotMoveControl((Mob)this);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_spawn_animtime, (Object)65);
        builder.define(DATA_hit_animtime, (Object)0);
        builder.define(DATA_attack_cooldown, (Object)60);
        builder.define(DATA_attack_animtime, (Object)0);
        builder.define(DATA_attack_phase, (Object)0);
        builder.define(DATA_throw_cooldown, (Object)0);
        builder.define(DATA_throw_animtime, (Object)0);
        builder.define(DATA_has_icespike, (Object)false);
        builder.define(DATA_leap_cooldown, (Object)0);
        builder.define(DATA_leap_animtime, (Object)0);
        builder.define(DATA_groundsmash_cooldown, (Object)0);
        builder.define(DATA_groundsmash_animtime, (Object)0);
        builder.define(DATA_stuck_animtime, (Object)0);
        builder.define(DATA_battle_time, (Object)0);
        builder.define(DATA_die_animtime, (Object)0);
        builder.define(DATA_source_uuid, (Object)"");
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return false;
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 20, 5.0f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block_factorys_bosses:yeti_footstep")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block_factorys_bosses:yeti_hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block_factorys_bosses:silence"));
    }

    /*
     * Unable to fully structure code
     */
    public void tick() {
        block4: {
            if (!this.level().isClientSide) break block4;
            this.idleAnimationState.animateWhen((Integer)this.getEntityData().get(YetiEntity.DATA_die_animtime) == 0, this.tickCount);
            this.dieAnimationState.animateWhen((Integer)this.getEntityData().get(YetiEntity.DATA_die_animtime) > 0, this.tickCount);
            this.spawnAnimationState.animateWhen((Integer)this.getEntityData().get(YetiEntity.DATA_spawn_animtime) > 0, this.tickCount);
            this.attackAnimationState.animateWhen((Integer)this.getEntityData().get(YetiEntity.DATA_attack_animtime) > 0, this.tickCount);
            this.hitAnimationState.animateWhen((Integer)this.getEntityData().get(YetiEntity.DATA_hit_animtime) > 0, this.tickCount);
            this.throwAnimationState.animateWhen((Integer)this.getEntityData().get(YetiEntity.DATA_throw_animtime) > 0, this.tickCount);
            if ((Integer)this.getEntityData().get(YetiEntity.DATA_groundsmash_animtime) <= 0) ** GOTO lbl-1000
            if ((Integer)this.getEntityData().get(YetiEntity.DATA_groundsmash_animtime) < 119) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            this.angryAnimationState.animateWhen(v0, this.tickCount);
            this.leapAnimationState.animateWhen((Integer)this.getEntityData().get(YetiEntity.DATA_leap_animtime) > 23, this.tickCount);
            if ((Integer)this.getEntityData().get(YetiEntity.DATA_leap_animtime) <= 0) ** GOTO lbl-1000
            if ((Integer)this.getEntityData().get(YetiEntity.DATA_leap_animtime) < 23) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            this.leapEndAnimationState.animateWhen(v1, this.tickCount);
        }
        super.tick();
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        YetiEntity entity;
        Level world;
        block10: {
            block9: {
                double x = this.getX();
                double y = this.getY();
                double z = this.getZ();
                world = this.level();
                entity = this;
                Entity sourceentity = damagesource.getEntity();
                Entity immediatesourceentity = damagesource.getDirectEntity();
                if (damagesource.is(DamageTypes.FALL)) {
                    return false;
                }
                if (damagesource.is(DamageTypes.DROWN)) {
                    return false;
                }
                if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
                    return false;
                }
                if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
                    return false;
                }
                if ((Integer)this.getEntityData().get(DATA_spawn_animtime) > 0) break block9;
                if ((Integer)this.getEntityData().get(DATA_hit_animtime) > 13) break block9;
                if ((Integer)this.getEntityData().get(DATA_groundsmash_animtime) <= 0) break block10;
                if ((Integer)this.getEntityData().get(DATA_groundsmash_animtime) >= 119) break block10;
            }
            return false;
        }
        if (damagesource.getDirectEntity() instanceof AbstractArrow) {
            amount *= 0.15f;
        }
        if (damagesource.is(DamageTypes.TRIDENT)) {
            amount *= 0.3f;
        }
        YetiEntityIsHurtProcedure.execute((LevelAccessor)world, (Entity)entity);
        return super.hurt(damagesource, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        YetiEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this, source.getEntity());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Dataspawn_animtime", ((Integer)this.entityData.get(DATA_spawn_animtime)).intValue());
        compound.putInt("Datahit_animtime", ((Integer)this.entityData.get(DATA_hit_animtime)).intValue());
        compound.putInt("Dataattack_cooldown", ((Integer)this.entityData.get(DATA_attack_cooldown)).intValue());
        compound.putInt("Dataattack_animtime", ((Integer)this.entityData.get(DATA_attack_animtime)).intValue());
        compound.putInt("Dataattack_phase", ((Integer)this.entityData.get(DATA_attack_phase)).intValue());
        compound.putInt("Datathrow_cooldown", ((Integer)this.entityData.get(DATA_throw_cooldown)).intValue());
        compound.putInt("Datathrow_animtime", ((Integer)this.entityData.get(DATA_throw_animtime)).intValue());
        compound.putBoolean("Datahas_icespike", ((Boolean)this.entityData.get(DATA_has_icespike)).booleanValue());
        compound.putInt("Dataleap_cooldown", ((Integer)this.entityData.get(DATA_leap_cooldown)).intValue());
        compound.putInt("Dataleap_animtime", ((Integer)this.entityData.get(DATA_leap_animtime)).intValue());
        compound.putInt("Datagroundsmash_cooldown", ((Integer)this.entityData.get(DATA_groundsmash_cooldown)).intValue());
        compound.putInt("Datagroundsmash_animtime", ((Integer)this.entityData.get(DATA_groundsmash_animtime)).intValue());
        compound.putInt("Datastuck_animtime", ((Integer)this.entityData.get(DATA_groundsmash_animtime)).intValue());
        compound.putInt("Databattle_time", ((Integer)this.entityData.get(DATA_battle_time)).intValue());
        compound.putInt("Datadie_animtime", ((Integer)this.entityData.get(DATA_die_animtime)).intValue());
        compound.putString("Datasource_uuid", (String)this.entityData.get(DATA_source_uuid));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataspawn_animtime")) {
            this.entityData.set(DATA_spawn_animtime, (Object)compound.getInt("Dataspawn_animtime"));
        }
        if (compound.contains("Datahit_animtime")) {
            this.entityData.set(DATA_hit_animtime, (Object)compound.getInt("Datahit_animtime"));
        }
        if (compound.contains("Dataattack_cooldown")) {
            this.entityData.set(DATA_attack_cooldown, (Object)compound.getInt("Dataattack_cooldown"));
        }
        if (compound.contains("Dataattack_animtime")) {
            this.entityData.set(DATA_attack_animtime, (Object)compound.getInt("Dataattack_animtime"));
        }
        if (compound.contains("Dataattack_phase")) {
            this.entityData.set(DATA_attack_phase, (Object)compound.getInt("Dataattack_phase"));
        }
        if (compound.contains("Datathrow_cooldown")) {
            this.entityData.set(DATA_throw_cooldown, (Object)compound.getInt("Datathrow_cooldown"));
        }
        if (compound.contains("Datathrow_animtime")) {
            this.entityData.set(DATA_throw_animtime, (Object)compound.getInt("Datathrow_animtime"));
        }
        if (compound.contains("Datahas_icespike")) {
            this.entityData.set(DATA_has_icespike, (Object)compound.getBoolean("Datahas_icespike"));
        }
        if (compound.contains("Dataleap_cooldown")) {
            this.entityData.set(DATA_leap_cooldown, (Object)compound.getInt("Dataleap_cooldown"));
        }
        if (compound.contains("Dataleap_animtime")) {
            this.entityData.set(DATA_leap_animtime, (Object)compound.getInt("Dataleap_animtime"));
        }
        if (compound.contains("Datagroundsmash_cooldown")) {
            this.entityData.set(DATA_groundsmash_cooldown, (Object)compound.getInt("Datagroundsmash_cooldown"));
        }
        if (compound.contains("Datagroundsmash_animtime")) {
            this.entityData.set(DATA_groundsmash_animtime, (Object)compound.getInt("Datagroundsmash_animtime"));
        }
        if (compound.contains("Datastuck_animtime")) {
            this.entityData.set(DATA_stuck_animtime, (Object)compound.getInt("Datastuck_animtime"));
        }
        if (compound.contains("Databattle_time")) {
            this.entityData.set(DATA_battle_time, (Object)compound.getInt("Databattle_time"));
        }
        if (compound.contains("Datasource_uuid")) {
            this.entityData.set(DATA_source_uuid, (Object)compound.getString("Datasource_uuid"));
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)ConfigFileConfiguration.YETI_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)ConfigFileConfiguration.YETI_ARMOR.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)ConfigFileConfiguration.YETI_ATK.get()).doubleValue());
        YetiEntity yetiEntity = this;
        if (yetiEntity instanceof LivingEntity) {
            YetiEntity _entity = yetiEntity;
            _entity.setHealth((float)((Double)ConfigFileConfiguration.YETI_HEALTH.get()).doubleValue());
        }
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        YetiOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        NullPrEntity.shoot((LivingEntity)this, target);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 250.0);
        builder = builder.add(Attributes.ARMOR, 2.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 18.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 64.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 2.3);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        return builder;
    }
}

