/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.block.family;

import com.calemi.ccore.api.block.family.CBlockFamilyMember;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class CBlockFamily {
    private final FamilyType familyType;
    private final LinkedHashMap<MemberType, CBlockFamilyMember> members;
    private final List<CBlockFamily> ancestors;
    private TagKey<Item> logTag;

    CBlockFamily(FamilyType familyType) {
        this.familyType = familyType;
        this.members = Maps.newLinkedHashMap();
        this.ancestors = new ArrayList<CBlockFamily>();
        this.logTag = null;
    }

    public FamilyType getFamilyType() {
        return this.familyType;
    }

    public Map<MemberType, CBlockFamilyMember> getMembers() {
        return this.members;
    }

    public List<CBlockFamily> getAncestors() {
        return this.ancestors;
    }

    public TagKey<Item> getLogTag() {
        return this.logTag;
    }

    public CBlockFamilyMember getMember(MemberType type) {
        return this.members.get((Object)type);
    }

    public Block getBlock(MemberType type) {
        CBlockFamilyMember member = this.getMember(type);
        if (member != null) {
            return member.getBlock();
        }
        return null;
    }

    public List<Block> getAllBlocks() {
        return this.getMembers().values().stream().map(CBlockFamilyMember::getBlock).toList();
    }

    public List<Item> getAllTabItems() {
        return this.getMembers().values().stream().filter(CBlockFamilyMember::showInCreativeTabs).map(member -> member.getBlock().asItem()).toList();
    }

    public static enum FamilyType {
        STONE,
        COBBLESTONE,
        PLANKS;


        public boolean isStone() {
            return this == STONE || this == COBBLESTONE;
        }
    }

    public static enum MemberType {
        LOG,
        WOOD,
        STRIPPED_LOG,
        STRIPPED_WOOD,
        BASE,
        CRACKED,
        STAIRS,
        SLAB,
        WALL,
        PILLAR,
        CHISELED,
        FENCE,
        FENCE_GATE,
        DOOR,
        TRAPDOOR,
        PRESSURE_PLATE,
        BUTTON,
        SIGN,
        WALL_SIGN,
        HANGING_SIGN,
        WALL_HANGING_SIGN;

    }

    public static class Builder {
        private final CBlockFamily family;

        public Builder(FamilyType familyType) {
            this.family = new CBlockFamily(familyType);
        }

        public Builder logTag(TagKey<Item> logTag) {
            this.family.logTag = logTag;
            return this;
        }

        public Builder member(MemberType memberType, CBlockFamilyMember.Builder memberBuilder) {
            this.family.members.put(memberType, memberBuilder.getMember());
            return this;
        }

        public Builder ancestor(CBlockFamily ancestor) {
            this.family.ancestors.add(ancestor);
            return this;
        }

        public CBlockFamily getFamily() {
            return this.family;
        }
    }
}

