/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.block.family;

import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;

public class CBlockFamilyMember {
    private final Block block;
    private boolean showInCreativeTabs = true;
    private boolean genBlockState = true;
    private boolean genLootTable = true;
    private boolean genBlockTags = true;

    CBlockFamilyMember(Block block) {
        this.block = block;
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean genBlockState() {
        return this.genBlockState;
    }

    public boolean genLootTable() {
        return this.genLootTable;
    }

    public boolean genBlockTags() {
        return this.genBlockTags;
    }

    public boolean showInCreativeTabs() {
        return this.showInCreativeTabs;
    }

    public static class Builder {
        private final CBlockFamilyMember member;

        public Builder(Block block) {
            this.member = new CBlockFamilyMember(block);
        }

        public Builder(DeferredBlock<Block> block) {
            this((Block)block.get());
        }

        public Builder dontGenOrShow() {
            return this.dontShowInCreativeTabs().dontGenBlockState().dontGenLootTable().dontGenBlockTags();
        }

        public Builder dontShowInCreativeTabs() {
            this.member.showInCreativeTabs = false;
            return this;
        }

        public Builder dontGenBlockState() {
            this.member.genBlockState = false;
            return this;
        }

        public Builder dontGenLootTable() {
            this.member.genLootTable = false;
            return this;
        }

        public Builder dontGenBlockTags() {
            this.member.genBlockTags = false;
            return this;
        }

        public CBlockFamilyMember getMember() {
            return this.member;
        }
    }
}

