/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.block.scanner;

import com.calemi.ccore.api.location.BlockLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public abstract class BlockScanner {
    private final ArrayList<BlockPos> collectedPositions = new ArrayList();
    private final Level level;
    private final BlockPos originPosition;
    private final int maxCollectionSize;
    private boolean halted = false;

    public BlockScanner(Level level, BlockPos originPosition, int maxCollectionSize) {
        this.level = level;
        this.originPosition = originPosition;
        this.maxCollectionSize = maxCollectionSize;
    }

    public BlockScanner(BlockLocation originLocation, int maxCollectionSize) {
        this(originLocation.getLevel(), originLocation.getBlockPos(), maxCollectionSize);
    }

    public ArrayList<BlockPos> getCollectedPositions() {
        return this.collectedPositions;
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getOriginPosition() {
        return this.originPosition;
    }

    public int getMaxCollectionSize() {
        return this.maxCollectionSize;
    }

    public boolean isHalted() {
        return this.halted;
    }

    public void setHalted(boolean halted) {
        this.halted = halted;
    }

    public abstract boolean shouldCollect(BlockPos var1);

    public abstract boolean branchOnFailedCollect();

    public abstract List<BlockPos> nextPositionsToScan(BlockPos var1);

    public void start() {
        this.reset();
        this.scan(this.originPosition);
    }

    public void reset() {
        this.collectedPositions.clear();
        this.halted = false;
    }

    public void scan(BlockPos location) {
        if (this.halted || this.collectedPositions.size() >= this.maxCollectionSize) {
            return;
        }
        if (!this.collectedPositions.contains(location)) {
            if (this.shouldCollect(location)) {
                this.collectedPositions.add(location);
            } else if (!this.branchOnFailedCollect()) {
                return;
            }
            for (BlockPos nextPositionToScan : this.nextPositionsToScan(location)) {
                this.scan(nextPositionToScan);
            }
        }
    }
}

