/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.block.scanner;

import com.calemi.ccore.api.block.scanner.BlockScanner;
import com.calemi.ccore.api.location.BlockLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class VeinBlockScanner
extends BlockScanner {
    private Block originBlock = this.getLevel().getBlockState(this.getOriginPosition()).getBlock();

    public VeinBlockScanner(Level level, BlockPos originPosition, int maxCollectionSize) {
        super(level, originPosition, maxCollectionSize);
    }

    public VeinBlockScanner(BlockLocation originLocation, int maxCollectionSize) {
        this(originLocation.getLevel(), originLocation.getBlockPos(), maxCollectionSize);
        this.originBlock = originLocation.getBlockState().getBlock();
    }

    @Override
    public boolean shouldCollect(BlockPos scannedBlockPos) {
        return this.getLevel().getBlockState(scannedBlockPos).getBlock().equals(this.originBlock);
    }

    @Override
    public boolean branchOnFailedCollect() {
        return false;
    }

    @Override
    public List<BlockPos> nextPositionsToScan(BlockPos prevBlockPos) {
        ArrayList<BlockPos> nextPositions = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    nextPositions.add(prevBlockPos.offset(x, y, z));
                }
            }
        }
        return nextPositions;
    }
}

