/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.client.render;

import com.calemi.ccore.api.boat.CBoatType;
import com.calemi.ccore.api.boat.CBoatTypeRegistry;
import com.calemi.ccore.api.entity.CBoat;
import com.calemi.ccore.api.entity.CChestBoat;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class CBoatRenderer
extends EntityRenderer<Boat> {
    private final Map<CBoatType, Pair<ResourceLocation, ListModel<Boat>>> boatResources;

    public CBoatRenderer(EntityRendererProvider.Context context, boolean hasChest) {
        super(context);
        this.shadowRadius = 0.8f;
        this.boatResources = (Map)CBoatTypeRegistry.getTypes().stream().collect(ImmutableMap.toImmutableMap(key -> key, model -> Pair.of((Object)ResourceLocation.fromNamespaceAndPath((String)model.getModId(), (String)CBoatRenderer.getTextureLocation(model, hasChest)), (Object)this.createBoatModel(context, (CBoatType)model, hasChest))));
    }

    public void render(Boat boat, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float f2;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.375f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        float f = (float)boat.getHurtTime() - partialTicks;
        float f1 = boat.getDamage() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)boat.getHurtDir()));
        }
        if (!Mth.equal((float)(f2 = boat.getBubbleAngle(partialTicks)), (float)0.0f)) {
            poseStack.mulPose(new Quaternionf().setAngleAxis(boat.getBubbleAngle(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<Boat>> pair = this.getModelWithLocation(boat);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        ListModel listmodel = (ListModel)pair.getSecond();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        listmodel.setupAnim((Entity)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(listmodel.renderType(resourcelocation));
        listmodel.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        if (!boat.isUnderWater()) {
            VertexConsumer vertexconsumer1 = bufferSource.getBuffer(RenderType.waterMask());
            if (listmodel instanceof WaterPatchModel) {
                WaterPatchModel waterpatchmodel = (WaterPatchModel)listmodel;
                waterpatchmodel.waterPatch().render(poseStack, vertexconsumer1, packedLight, OverlayTexture.NO_OVERLAY);
            }
        }
        poseStack.popPose();
        super.render((Entity)boat, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(Boat boat) {
        return (ResourceLocation)this.getModelWithLocation(boat).getFirst();
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof CChestBoat) {
            return this.boatResources.get(((CChestBoat)boat).getBoatType());
        }
        return this.boatResources.get(((CBoat)boat).getBoatType());
    }

    private static String getTextureLocation(CBoatType boatType, boolean hasChest) {
        return hasChest ? "textures/entity/chest_boat/" + boatType.getName() + ".png" : "textures/entity/boat/" + boatType.getName() + ".png";
    }

    private static ModelLayerLocation createLocation(String modId, String name, String layer) {
        return new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)modId, (String)name), layer);
    }

    public static ModelLayerLocation createBoatModelName(CBoatType boatType) {
        return CBoatRenderer.createLocation(boatType.getModId(), "boat/" + boatType.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(CBoatType boatType) {
        return CBoatRenderer.createLocation(boatType.getModId(), "chest_boat/" + boatType.getName(), "main");
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, CBoatType boatType, boolean hasChest) {
        ModelLayerLocation modellayerlocation = hasChest ? CBoatRenderer.createChestBoatModelName(boatType) : CBoatRenderer.createBoatModelName(boatType);
        ModelPart baked = context.bakeLayer(modellayerlocation);
        return hasChest ? new ChestBoatModel(baked) : new BoatModel(baked);
    }
}

