/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.container;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CContainerHelper {
    public static int countItems(Container container, Item item) {
        return CContainerHelper.countItems(container, new ItemStack((ItemLike)item), false);
    }

    public static int countItems(Container container, ItemStack stack) {
        return CContainerHelper.countItems(container, stack, true);
    }

    private static int countItems(Container container, ItemStack stack, boolean compareNBT) {
        boolean isInventory = container instanceof Inventory;
        int count = 0;
        for (int slotIndex = 0; slotIndex < container.getContainerSize(); ++slotIndex) {
            ItemStack stackInSlot;
            if (isInventory && (slotIndex == 36 || slotIndex == 37 || slotIndex == 38 || slotIndex == 39) || !(stackInSlot = container.getItem(slotIndex)).is(stack.getItem()) || compareNBT && !ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)stack)) continue;
            count += stackInSlot.getCount();
        }
        return count;
    }

    public static int calculateFittingSpace(Container container, Item item) {
        return CContainerHelper.calculateFittingSpace(container, new ItemStack((ItemLike)item), false);
    }

    public static int calculateFittingSpace(Container container, ItemStack stack) {
        return CContainerHelper.calculateFittingSpace(container, stack, true);
    }

    private static int calculateFittingSpace(Container container, ItemStack stack, boolean compareNBT) {
        boolean isInventory = container instanceof Inventory;
        int fittingSpace = 0;
        for (int slotIndex = 0; slotIndex < container.getContainerSize(); ++slotIndex) {
            if (isInventory && (slotIndex == 36 || slotIndex == 37 || slotIndex == 38 || slotIndex == 39)) continue;
            ItemStack stackInSlot = container.getItem(slotIndex);
            if (stackInSlot.isEmpty()) {
                fittingSpace += stack.getMaxStackSize();
            }
            if (!stackInSlot.is(stack.getItem()) || compareNBT && !ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)stack)) continue;
            fittingSpace += stack.getMaxStackSize() - stackInSlot.getCount();
        }
        return fittingSpace;
    }

    public static void consumeItems(Container container, Item item, int amount) {
        CContainerHelper.consumeItems(container, new ItemStack((ItemLike)item), amount, false);
    }

    public static void consumeItems(Container container, ItemStack stack) {
        CContainerHelper.consumeItems(container, stack, stack.getCount(), true);
    }

    public static void consumeItems(Container container, ItemStack stack, int amount) {
        CContainerHelper.consumeItems(container, stack, amount, true);
    }

    private static void consumeItems(Container container, ItemStack stack, int amount, boolean compareNBT) {
        boolean isInventory = container instanceof Inventory;
        int amountLeft = amount;
        if (CContainerHelper.countItems(container, stack, compareNBT) < amount) {
            return;
        }
        for (int slotIndex = 0; slotIndex < container.getContainerSize(); ++slotIndex) {
            if (isInventory && (slotIndex == 36 || slotIndex == 37 || slotIndex == 38 || slotIndex == 39)) continue;
            if (amountLeft <= 0) break;
            ItemStack stackInSlot = container.getItem(slotIndex);
            if (!stackInSlot.is(stack.getItem()) || compareNBT && !ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)stack)) continue;
            if (amountLeft >= stackInSlot.getCount()) {
                amountLeft -= stackInSlot.getCount();
                container.setItem(slotIndex, ItemStack.EMPTY);
                continue;
            }
            stackInSlot.shrink(amountLeft);
            return;
        }
    }

    public static boolean canInsertItem(Container container, Item item, int amount) {
        return CContainerHelper.calculateFittingSpace(container, item) >= amount;
    }

    public static boolean canInsertItem(Container container, ItemStack stack) {
        return CContainerHelper.canInsertItem(container, stack, stack.getCount());
    }

    public static boolean canInsertItem(Container container, ItemStack stack, int amount) {
        return CContainerHelper.calculateFittingSpace(container, stack) >= amount;
    }

    public static void insertItem(Container container, Item item, int amount) {
        CContainerHelper.insertItem(container, new ItemStack((ItemLike)item), amount);
    }

    public static void insertItem(Container container, ItemStack stack) {
        CContainerHelper.insertItem(container, stack, stack.getCount());
    }

    public static void insertItem(Container container, ItemStack stack, int amount) {
        boolean isInventory = container instanceof Inventory;
        if (!CContainerHelper.canInsertItem(container, stack, amount)) {
            return;
        }
        int amountLeft = amount;
        int maxStackSize = stack.getMaxStackSize();
        for (int slotIndex = 0; slotIndex < container.getContainerSize(); ++slotIndex) {
            if (isInventory && (slotIndex == 36 || slotIndex == 37 || slotIndex == 38 || slotIndex == 39)) continue;
            if (amountLeft <= 0) break;
            ItemStack stackInSlot = container.getItem(slotIndex);
            if (stackInSlot.isEmpty()) {
                int cappedAmount = Math.min(maxStackSize, amountLeft);
                amountLeft -= cappedAmount;
                ItemStack stackCopy = stack.copy();
                stackCopy.setCount(cappedAmount);
                container.setItem(slotIndex, stackCopy);
                continue;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)stack)) continue;
            int spaceToMax = maxStackSize - stackInSlot.getCount();
            if (spaceToMax >= amountLeft) {
                stackInSlot.setCount(stackInSlot.getCount() + amountLeft);
                break;
            }
            amountLeft -= spaceToMax;
            stackInSlot.setCount(maxStackSize);
        }
    }
}

