/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.datagen;

import com.calemi.ccore.api.block.family.CBlockFamily;
import com.calemi.ccore.api.block.family.CBlockFamilyMember;
import java.util.Arrays;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public abstract class CBlockStateProvider
extends BlockStateProvider {
    protected final String modId;

    public CBlockStateProvider(String modId, PackOutput output, ExistingFileHelper fileHelper) {
        super(output, modId, fileHelper);
        this.modId = modId;
    }

    protected void family(CBlockFamily family, CBlockFamily.MemberType type, CBlockFamilyMember member) {
        Block base;
        Block base2;
        Block wood;
        if (!member.genBlockState()) {
            return;
        }
        if (type.equals((Object)CBlockFamily.MemberType.LOG) && (wood = family.getBlock(CBlockFamily.MemberType.WOOD)) != null) {
            this.log((RotatedPillarBlock)member.getBlock(), (RotatedPillarBlock)wood);
        }
        if (type.equals((Object)CBlockFamily.MemberType.STRIPPED_LOG) && (wood = family.getBlock(CBlockFamily.MemberType.STRIPPED_WOOD)) != null) {
            this.log((RotatedPillarBlock)member.getBlock(), (RotatedPillarBlock)wood);
        }
        if (type.equals((Object)CBlockFamily.MemberType.BASE) || type.equals((Object)CBlockFamily.MemberType.CRACKED) || type.equals((Object)CBlockFamily.MemberType.CHISELED)) {
            this.all(member.getBlock());
        }
        if (type.equals((Object)CBlockFamily.MemberType.PILLAR)) {
            this.pillar((RotatedPillarBlock)member.getBlock());
        }
        if (type.equals((Object)CBlockFamily.MemberType.STAIRS) && (base2 = family.getBlock(CBlockFamily.MemberType.BASE)) != null) {
            this.stairs((StairBlock)member.getBlock(), base2);
        }
        if (type.equals((Object)CBlockFamily.MemberType.SLAB) && (base2 = family.getBlock(CBlockFamily.MemberType.BASE)) != null) {
            this.slab((SlabBlock)member.getBlock(), base2);
        }
        if (type.equals((Object)CBlockFamily.MemberType.WALL) && (base2 = family.getBlock(CBlockFamily.MemberType.BASE)) != null) {
            this.wall((WallBlock)member.getBlock(), base2);
        }
        if (type.equals((Object)CBlockFamily.MemberType.FENCE) && (base2 = family.getBlock(CBlockFamily.MemberType.BASE)) != null) {
            this.fence((FenceBlock)member.getBlock(), base2);
        }
        if (type.equals((Object)CBlockFamily.MemberType.FENCE_GATE) && (base2 = family.getBlock(CBlockFamily.MemberType.BASE)) != null) {
            this.fenceGate((FenceGateBlock)member.getBlock(), base2);
        }
        if (type.equals((Object)CBlockFamily.MemberType.DOOR)) {
            this.door((DoorBlock)member.getBlock());
        }
        if (type.equals((Object)CBlockFamily.MemberType.TRAPDOOR)) {
            this.trapdoor((TrapDoorBlock)member.getBlock());
        }
        if (type.equals((Object)CBlockFamily.MemberType.PRESSURE_PLATE) && (base2 = family.getBlock(CBlockFamily.MemberType.BASE)) != null) {
            this.pressurePlate((PressurePlateBlock)member.getBlock(), base2);
        }
        if (type.equals((Object)CBlockFamily.MemberType.BUTTON) && (base2 = family.getBlock(CBlockFamily.MemberType.BASE)) != null) {
            this.button((ButtonBlock)member.getBlock(), base2);
        }
        if (type.equals((Object)CBlockFamily.MemberType.SIGN)) {
            Block wallSign = family.getBlock(CBlockFamily.MemberType.WALL_SIGN);
            base = family.getBlock(CBlockFamily.MemberType.BASE);
            if (base != null) {
                this.sign((StandingSignBlock)member.getBlock(), (WallSignBlock)wallSign, base);
            }
        }
        if (type.equals((Object)CBlockFamily.MemberType.HANGING_SIGN)) {
            Block wallHangingSign = family.getBlock(CBlockFamily.MemberType.WALL_HANGING_SIGN);
            base = family.getBlock(CBlockFamily.MemberType.BASE);
            if (base != null) {
                this.hangingSign((CeilingHangingSignBlock)member.getBlock(), (WallHangingSignBlock)wallHangingSign, base);
            }
        }
    }

    protected void all(Block block) {
        String blockName = this.name(block);
        String blockPath = "block/" + blockName;
        ModelBuilder model = this.models().cubeAll(blockName, this.rl(blockPath));
        this.simpleBlockWithItem(block, (ModelFile)model);
    }

    protected void allCutout(Block block) {
        String blockName = this.name(block);
        String blockPath = "block/" + blockName;
        ModelBuilder model = ((BlockModelBuilder)this.models().cubeAll(blockName, this.rl(blockPath))).renderType("cutout");
        this.simpleBlockWithItem(block, (ModelFile)model);
    }

    protected void log(RotatedPillarBlock log, RotatedPillarBlock wood) {
        String logName = this.name((Block)log);
        String woodName = this.name((Block)wood);
        String logPath = "block/" + logName;
        ModelBuilder logModel = this.models().cubeColumn(logName, this.rl(logPath), this.rl(logPath + "_top"));
        ModelBuilder logHorizontalModel = this.models().cubeColumn(logName + "_horizontal", this.rl(logPath), this.rl(logPath + "_top"));
        ModelBuilder woodModel = this.models().cubeColumn(woodName, this.rl(logPath), this.rl(logPath));
        this.axisBlock(log, (ModelFile)logModel, (ModelFile)logHorizontalModel);
        this.simpleBlockItem((Block)log, (ModelFile)logModel);
        this.axisBlock(wood, (ModelFile)woodModel, (ModelFile)woodModel);
        this.simpleBlockItem((Block)wood, (ModelFile)woodModel);
    }

    protected void stairs(StairBlock block, Block blockMaterial) {
        ResourceLocation modelTexture = this.texture(blockMaterial, "block/");
        this.stairsBlock(block, modelTexture);
        String itemModelName = this.name((Block)block);
        ModelBuilder itemModel = this.models().stairs(itemModelName, modelTexture, modelTexture, modelTexture);
        this.simpleBlockItem((Block)block, (ModelFile)itemModel);
    }

    protected void slab(SlabBlock block, Block blockMaterial) {
        ResourceLocation modelTexture = this.texture(blockMaterial, "block/");
        this.slabBlock(block, modelTexture, modelTexture);
        String itemModelName = this.name((Block)block);
        ModelBuilder itemModel = this.models().slab(itemModelName, modelTexture, modelTexture, modelTexture);
        this.simpleBlockItem((Block)block, (ModelFile)itemModel);
    }

    protected void wall(WallBlock block, Block blockMaterial) {
        ResourceLocation modelTexture = this.texture(blockMaterial, "block/");
        this.wallBlock(block, modelTexture);
        String itemModelName = this.name((Block)block);
        ModelBuilder itemModel = this.models().wallInventory(itemModelName, modelTexture);
        this.simpleBlockItem((Block)block, (ModelFile)itemModel);
    }

    protected void pillar(RotatedPillarBlock block) {
        ResourceLocation modelTexture = this.texture((Block)block, "block/");
        ResourceLocation modelTextureTop = this.texture((Block)block, "block/", "_top");
        this.axisBlock(block, modelTexture, modelTextureTop);
        String itemModelName = this.name((Block)block);
        ModelBuilder itemModel = this.models().cubeColumn(itemModelName, modelTexture, modelTextureTop);
        this.simpleBlockItem((Block)block, (ModelFile)itemModel);
    }

    protected void fence(FenceBlock block, Block blockMaterial) {
        String blockName = this.name((Block)block);
        String blockMaterialName = this.name(blockMaterial);
        String blockMaterialPath = "block/" + blockMaterialName;
        ResourceLocation blockMaterialRL = this.rl(blockMaterialPath);
        ModelBuilder itemModel = this.models().fenceInventory(blockName, blockMaterialRL);
        this.fenceBlock(block, blockMaterialRL);
        this.simpleBlockItem((Block)block, (ModelFile)itemModel);
    }

    protected void fenceGate(FenceGateBlock block, Block blockMaterial) {
        String blockName = this.name((Block)block);
        String blockMaterialName = this.name(blockMaterial);
        String blockMaterialPath = "block/" + blockMaterialName;
        ResourceLocation blockMaterialRL = this.rl(blockMaterialPath);
        ModelBuilder itemModel = this.models().fenceGate(blockName, blockMaterialRL);
        this.fenceGateBlock(block, blockMaterialRL);
        this.simpleBlockItem((Block)block, (ModelFile)itemModel);
    }

    protected void door(DoorBlock block) {
        String blockName = this.name((Block)block);
        String blockPath = "block/" + blockName;
        ResourceLocation bottomBlockRL = this.rl(blockPath + "_bottom");
        ResourceLocation topBlockRL = this.rl(blockPath + "_top");
        this.doorBlockWithRenderType(block, bottomBlockRL, topBlockRL, "cutout");
        this.flatItem(blockName, "item");
    }

    protected void trapdoor(TrapDoorBlock block) {
        String blockName = this.name((Block)block);
        String blockPath = "block/" + blockName;
        ResourceLocation blockRL = this.rl(blockPath);
        ModelBuilder itemModel = this.models().trapdoorBottom(blockName, blockRL);
        this.trapdoorBlockWithRenderType(block, blockRL, true, "cutout");
        this.simpleBlockItem((Block)block, (ModelFile)itemModel);
    }

    protected void pressurePlate(PressurePlateBlock block, Block blockMaterial) {
        String blockName = this.name((Block)block);
        String blockMaterialName = this.name(blockMaterial);
        String blockMaterialPath = "block/" + blockMaterialName;
        ResourceLocation blockMaterialRL = this.rl(blockMaterialPath);
        ModelBuilder itemModel = this.models().pressurePlate(blockName, blockMaterialRL);
        this.pressurePlateBlock(block, blockMaterialRL);
        this.simpleBlockItem((Block)block, (ModelFile)itemModel);
    }

    protected void button(ButtonBlock block, Block blockMaterial) {
        String blockName = this.name((Block)block);
        String blockMaterialName = this.name(blockMaterial);
        String blockMaterialPath = "block/" + blockMaterialName;
        ResourceLocation blockMaterialRL = this.rl(blockMaterialPath);
        this.buttonBlock(block, blockMaterialRL);
        ModelBuilder itemModel = this.models().buttonInventory(blockName + "_inventory", blockMaterialRL);
        this.simpleBlockItem((Block)block, (ModelFile)itemModel);
    }

    protected void sign(StandingSignBlock blockSign, WallSignBlock blockWallSign, Block blockMaterial) {
        String blockSignName = this.name((Block)blockSign);
        String blockMaterialName = this.name(blockMaterial);
        String blockMaterialPath = "block/" + blockMaterialName;
        ResourceLocation blockMaterialRL = this.rl(blockMaterialPath);
        this.signBlock(blockSign, blockWallSign, blockMaterialRL);
        this.flatItem(blockSignName, "item");
    }

    protected void hangingSign(CeilingHangingSignBlock blockHangingSign, WallHangingSignBlock blockHangingWallSign, Block blockMaterial) {
        String blockHangingSignName = this.name((Block)blockHangingSign);
        String blockMaterialName = this.name(blockMaterial);
        String blockMaterialPath = "block/" + blockMaterialName;
        ResourceLocation blockMaterialRL = this.rl(blockMaterialPath);
        this.hangingSignBlock(blockHangingSign, blockHangingWallSign, blockMaterialRL);
        this.flatItem(blockHangingSignName, "item");
    }

    protected ModelFile petalModel(String blockName, int petalAmount) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_" + petalAmount, "minecraft:block/flowerbed_" + petalAmount)).texture("flowerbed", "block/" + blockName)).texture("stem", "block/" + blockName + "_stem")).renderType("cutout");
    }

    protected void deepslate(RotatedPillarBlock block) {
        String blockName = this.name((Block)block);
        String blockSidePath = "block/" + blockName;
        String blockTopPath = "block/" + blockName + "_top";
        String parent = "block/cube_column_mirrored";
        ModelBuilder model = this.models().cubeColumn(blockName, this.rl(blockSidePath), this.rl(blockTopPath));
        ModelBuilder mirroredModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_mirrored", parent)).texture("end", blockTopPath)).texture("side", blockSidePath);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(90).nextModel().modelFile((ModelFile)mirroredModel).rotationX(90).rotationY(90).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)model).nextModel().modelFile((ModelFile)mirroredModel).nextModel().modelFile((ModelFile)model).rotationY(180).nextModel().modelFile((ModelFile)mirroredModel).rotationY(180).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)model).rotationX(90).nextModel().modelFile((ModelFile)mirroredModel).rotationX(90).nextModel().modelFile((ModelFile)model).rotationX(90).rotationY(180).nextModel().modelFile((ModelFile)mirroredModel).rotationX(90).rotationY(180).addModel();
        this.simpleBlockItem((Block)block, (ModelFile)model);
    }

    protected void grass(Block grassBlock, Block dirtBlock) {
        String blockName = this.name(grassBlock);
        ResourceLocation modelTextureSide = this.texture(grassBlock, "block/", "_side");
        ResourceLocation modelTextureTop = this.texture(grassBlock, "block/", "_top");
        ResourceLocation modelTextureBottom = this.texture(dirtBlock, "block/");
        ModelBuilder model = this.models().cubeBottomTop(blockName, modelTextureSide, modelTextureBottom, modelTextureTop);
        this.simpleBlockWithItem(grassBlock, (ModelFile)model);
    }

    protected void sapling(Block block) {
        String blockName = this.name(block);
        String blockPath = "block/" + blockName;
        ModelBuilder model = ((BlockModelBuilder)this.models().cross(blockName, this.rl(blockPath))).renderType("cutout");
        this.simpleBlock(block, (ModelFile)model);
        this.flatItem(blockName, "block");
    }

    protected void crystal(Block block) {
        String blockName = this.name(block);
        String blockCrystalPath = "block/" + blockName;
        String modelParent = "minecraft:block/cross";
        ResourceLocation modelTexture = this.texture(block, "block/");
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockCrystalPath, modelParent)).texture("cross", modelTexture)).renderType("cutout");
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)model).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).rotationX(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(270).addModel();
        this.flatItem(blockName, "block");
    }

    protected void petal(Block block) {
        String blockName = this.name(block);
        Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        int[] flowerAmounts = new int[]{1, 2, 3, 4};
        ModelFile[] models = new ModelFile[]{this.petalModel(blockName, 1), this.petalModel(blockName, 2), this.petalModel(blockName, 3), this.petalModel(blockName, 4)};
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        for (int i = 0; i < models.length; ++i) {
            for (Direction direction : directions) {
                int[] applicableAmounts = Arrays.copyOfRange(flowerAmounts, i, flowerAmounts.length);
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(models[i]).rotationY(direction.getCounterClockWise().getCounterClockWise().get2DDataValue() * 90).addModel()).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{direction}).condition((Property)BlockStateProperties.FLOWER_AMOUNT, (Comparable[])((Integer[])Arrays.stream(applicableAmounts).boxed().toArray(Integer[]::new))).end();
            }
        }
        this.flatItem(blockName, "item");
    }

    protected void flowerPot(Block blockPottedFlower, Block blockFlower) {
        String pottedFlowerName = this.name(blockPottedFlower);
        String flowerName = this.name(blockFlower);
        String pottedFlowerPath = "block/" + pottedFlowerName;
        String modelParent = "minecraft:block/flower_pot_cross";
        ResourceLocation modelTextureFlower = this.texture(blockFlower, "block/");
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(pottedFlowerPath, modelParent)).texture("plant", modelTextureFlower)).renderType("cutout");
        this.simpleBlock(blockPottedFlower, (ModelFile)model);
    }

    protected void flatItem(String name, String textureSource) {
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.rl(textureSource + "/" + name));
    }

    protected ResourceLocation texture(Block block, String pathPrefix) {
        return this.texture(block, pathPrefix, "");
    }

    protected ResourceLocation texture(Block block, String pathPrefix, String pathSuffix) {
        ResourceLocation blockKey = this.key(block);
        return ResourceLocation.fromNamespaceAndPath((String)blockKey.getNamespace(), (String)(pathPrefix + blockKey.getPath() + pathSuffix));
    }

    protected ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)path);
    }

    protected ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    protected String name(Block block) {
        return this.key(block).getPath();
    }
}

