/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.datagen;

import com.calemi.ccore.api.block.family.CBlockFamily;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public abstract class CRecipeProvider
extends RecipeProvider {
    protected final String modId;

    public CRecipeProvider(String modId, PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
        this.modId = modId;
    }

    protected void family(CBlockFamily family, RecipeOutput recipeOutput) {
        Block baseBlock = family.getBlock(CBlockFamily.MemberType.BASE);
        Block log = family.getBlock(CBlockFamily.MemberType.LOG);
        Block wood = family.getBlock(CBlockFamily.MemberType.WOOD);
        Block strippedLog = family.getBlock(CBlockFamily.MemberType.STRIPPED_LOG);
        Block strippedWood = family.getBlock(CBlockFamily.MemberType.STRIPPED_WOOD);
        Block crackedBlock = family.getBlock(CBlockFamily.MemberType.CRACKED);
        Block chiseled = family.getBlock(CBlockFamily.MemberType.CHISELED);
        Block pillar = family.getBlock(CBlockFamily.MemberType.PILLAR);
        Block stairs = family.getBlock(CBlockFamily.MemberType.STAIRS);
        Block slab = family.getBlock(CBlockFamily.MemberType.SLAB);
        Block wall = family.getBlock(CBlockFamily.MemberType.WALL);
        Block fence = family.getBlock(CBlockFamily.MemberType.FENCE);
        Block fenceGate = family.getBlock(CBlockFamily.MemberType.FENCE_GATE);
        Block door = family.getBlock(CBlockFamily.MemberType.DOOR);
        Block trapDoor = family.getBlock(CBlockFamily.MemberType.TRAPDOOR);
        Block pressurePlate = family.getBlock(CBlockFamily.MemberType.PRESSURE_PLATE);
        Block button = family.getBlock(CBlockFamily.MemberType.BUTTON);
        Block sign = family.getBlock(CBlockFamily.MemberType.SIGN);
        Block hangingSign = family.getBlock(CBlockFamily.MemberType.HANGING_SIGN);
        for (int ancestorIndex = 0; ancestorIndex < family.getAncestors().size(); ++ancestorIndex) {
            Block ancestorBaseBlock = family.getAncestors().get(ancestorIndex).getBlock(CBlockFamily.MemberType.BASE);
            if (ancestorBaseBlock == null) continue;
            if (baseBlock != null) {
                if (ancestorIndex == 0) {
                    this.twoByTwo((ItemLike)baseBlock, 4, (ItemLike)ancestorBaseBlock, null, recipeOutput);
                }
                this.stonecutter(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)baseBlock, (ItemLike)ancestorBaseBlock);
            }
            if (stairs != null) {
                this.stonecutter(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairs, (ItemLike)ancestorBaseBlock);
            }
            if (slab != null) {
                this.stonecutter(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (ItemLike)ancestorBaseBlock, 2);
            }
            if (wall != null) {
                this.stonecutter(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (ItemLike)ancestorBaseBlock);
            }
            if (chiseled != null) {
                this.stonecutter(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)chiseled, (ItemLike)ancestorBaseBlock);
            }
            if (pillar == null) continue;
            this.stonecutter(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)pillar, (ItemLike)ancestorBaseBlock);
        }
        if (log != null && baseBlock != null && family.getLogTag() != null) {
            this.planks(family, recipeOutput);
        }
        if (log != null && wood != null) {
            this.wood(family, recipeOutput);
        }
        if (strippedLog != null && strippedWood != null) {
            this.strippedWood(family, recipeOutput);
        }
        if (crackedBlock != null && baseBlock != null) {
            CRecipeProvider.smeltingResultFromBase((RecipeOutput)recipeOutput, (ItemLike)crackedBlock, (ItemLike)baseBlock);
        }
        if (chiseled != null) {
            this.chiseled(family, recipeOutput);
        }
        if (pillar != null) {
            this.pillar(family, recipeOutput);
        }
        if (stairs != null) {
            this.stairs(family, recipeOutput);
        }
        if (slab != null) {
            this.slab(family, recipeOutput);
        }
        if (wall != null) {
            this.wall(family, recipeOutput);
        }
        if (fence != null) {
            this.fence(family, recipeOutput);
        }
        if (fenceGate != null) {
            this.fenceGate(family, recipeOutput);
        }
        if (door != null) {
            this.door(family, recipeOutput);
        }
        if (trapDoor != null) {
            this.trapDoor(family, recipeOutput);
        }
        if (pressurePlate != null) {
            this.pressurePlate(family, recipeOutput);
        }
        if (button != null) {
            this.button(family, recipeOutput);
        }
        if (sign != null) {
            this.sign(family, recipeOutput);
        }
        if (hangingSign != null) {
            this.hangingSign(family, recipeOutput);
        }
    }

    protected void stonecutter(RecipeOutput recipeOutput, RecipeCategory category, ItemLike result, ItemLike material) {
        this.stonecutter(recipeOutput, category, result, material, 1);
    }

    protected void stonecutter(RecipeOutput recipeOutput, RecipeCategory category, ItemLike result, ItemLike material, int resultCount) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material}), (RecipeCategory)category, (ItemLike)result, (int)resultCount).unlockedBy(CRecipeProvider.getHasName((ItemLike)material), CRecipeProvider.has((ItemLike)material)).save(recipeOutput, this.rl(CRecipeProvider.getConversionRecipeName((ItemLike)result, (ItemLike)material) + "_stonecutting"));
    }

    protected void oneToOne(RecipeOutput recipeOutput, ItemLike result, ItemLike ingredient, @Nullable String group, int resultCount) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)resultCount).requires(ingredient).group(group).unlockedBy(CRecipeProvider.getHasName((ItemLike)ingredient), CRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, this.rl(CRecipeProvider.getConversionRecipeName((ItemLike)result, (ItemLike)ingredient)));
    }

    protected void twoByTwo(ItemLike result, int count, ItemLike ingredient, @Nullable String group, RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).define(Character.valueOf('#'), ingredient).pattern("##").pattern("##").group(group).unlockedBy(CRecipeProvider.getHasName((ItemLike)ingredient), CRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result) + "_from_" + CRecipeProvider.getItemName((ItemLike)ingredient)));
    }

    protected void oneByTwoVertical(RecipeOutput recipeOutput, ItemLike result, int count, ItemLike ingredient) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)result, (int)count).define(Character.valueOf('X'), ingredient).pattern("X").pattern("X").unlockedBy(CRecipeProvider.getHasName((ItemLike)ingredient), CRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void sword(RecipeOutput recipeOutput, ItemLike result, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result, (int)1).define(Character.valueOf('X'), material).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).pattern("X").pattern("X").pattern("S").unlockedBy(CRecipeProvider.getHasName((ItemLike)material), CRecipeProvider.has((ItemLike)material)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void shovel(RecipeOutput recipeOutput, ItemLike result, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result, (int)1).define(Character.valueOf('X'), material).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).pattern(" X ").pattern(" S ").pattern(" S ").unlockedBy(CRecipeProvider.getHasName((ItemLike)material), CRecipeProvider.has((ItemLike)material)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void pickaxe(RecipeOutput recipeOutput, ItemLike result, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result, (int)1).define(Character.valueOf('X'), material).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).pattern("XXX").pattern(" S ").pattern(" S ").unlockedBy(CRecipeProvider.getHasName((ItemLike)material), CRecipeProvider.has((ItemLike)material)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void axe(RecipeOutput recipeOutput, ItemLike result, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result, (int)1).define(Character.valueOf('X'), material).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).pattern("XX ").pattern("XS ").pattern(" S ").unlockedBy(CRecipeProvider.getHasName((ItemLike)material), CRecipeProvider.has((ItemLike)material)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void hoe(RecipeOutput recipeOutput, ItemLike result, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result, (int)1).define(Character.valueOf('X'), material).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).pattern("XX ").pattern(" S ").pattern(" S ").unlockedBy(CRecipeProvider.getHasName((ItemLike)material), CRecipeProvider.has((ItemLike)material)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void helmet(RecipeOutput recipeOutput, ItemLike result, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result, (int)1).define(Character.valueOf('X'), material).pattern("XXX").pattern("X X").unlockedBy(CRecipeProvider.getHasName((ItemLike)material), CRecipeProvider.has((ItemLike)material)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void chestplate(RecipeOutput recipeOutput, ItemLike result, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result, (int)1).define(Character.valueOf('X'), material).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy(CRecipeProvider.getHasName((ItemLike)material), CRecipeProvider.has((ItemLike)material)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void leggings(RecipeOutput recipeOutput, ItemLike result, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result, (int)1).define(Character.valueOf('X'), material).pattern("XXX").pattern("X X").pattern("X X").unlockedBy(CRecipeProvider.getHasName((ItemLike)material), CRecipeProvider.has((ItemLike)material)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void boots(RecipeOutput recipeOutput, ItemLike result, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result, (int)1).define(Character.valueOf('X'), material).pattern("X X").pattern("X X").unlockedBy(CRecipeProvider.getHasName((ItemLike)material), CRecipeProvider.has((ItemLike)material)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void wood(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.WOOD);
        Block ingredient = family.getBlock(CBlockFamily.MemberType.LOG);
        this.twoByTwo((ItemLike)result, 3, (ItemLike)ingredient, "bark", recipeOutput);
    }

    protected void strippedWood(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.STRIPPED_WOOD);
        Block ingredient = family.getBlock(CBlockFamily.MemberType.STRIPPED_LOG);
        this.twoByTwo((ItemLike)result, 3, (ItemLike)ingredient, "bark", recipeOutput);
    }

    protected void planks(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.BASE);
        TagKey<Item> ingredient = family.getLogTag();
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)4).requires(ingredient).group("planks").unlockedBy("has_logs", CRecipeProvider.has(ingredient)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void chiseled(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.CHISELED);
        Block ingredient = family.getBlock(CBlockFamily.MemberType.BASE);
        Block slab = family.getBlock(CBlockFamily.MemberType.SLAB);
        this.stonecutter(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (ItemLike)ingredient);
        this.oneByTwoVertical(recipeOutput, (ItemLike)result, 1, (ItemLike)slab);
    }

    protected void pillar(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.PILLAR);
        Block ingredient = family.getBlock(CBlockFamily.MemberType.BASE);
        this.stonecutter(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (ItemLike)ingredient);
        this.oneByTwoVertical(recipeOutput, (ItemLike)result, 1, (ItemLike)ingredient);
    }

    protected void stairs(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.STAIRS);
        Block ingredient = family.getBlock(CBlockFamily.MemberType.BASE);
        CRecipeProvider.stairBuilder((ItemLike)result, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient})).group(family.getFamilyType().equals((Object)CBlockFamily.FamilyType.PLANKS) ? "wooden_stairs" : null).unlockedBy(CRecipeProvider.getHasName((ItemLike)ingredient), CRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
        if (family.getFamilyType().isStone()) {
            this.stonecutter(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (ItemLike)ingredient);
        }
    }

    protected void slab(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.SLAB);
        Block ingredient = family.getBlock(CBlockFamily.MemberType.BASE);
        CRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient})).group(family.getFamilyType().equals((Object)CBlockFamily.FamilyType.PLANKS) ? "wooden_slab" : null).unlockedBy(CRecipeProvider.getHasName((ItemLike)ingredient), CRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
        if (family.getFamilyType().isStone()) {
            this.stonecutter(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (ItemLike)ingredient, 2);
        }
    }

    protected void wall(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.WALL);
        Block ingredient = family.getBlock(CBlockFamily.MemberType.BASE);
        CRecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient})).unlockedBy(CRecipeProvider.getHasName((ItemLike)ingredient), CRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
        if (family.getFamilyType().isStone()) {
            this.stonecutter(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (ItemLike)ingredient);
        }
    }

    protected void fence(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.FENCE);
        Block ingredient = family.getBlock(CBlockFamily.MemberType.BASE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)3).define(Character.valueOf('W'), (ItemLike)ingredient).define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).pattern("W#W").pattern("W#W").group(family.getFamilyType().equals((Object)CBlockFamily.FamilyType.PLANKS) ? "wooden_fence" : null).unlockedBy(CRecipeProvider.getHasName((ItemLike)ingredient), CRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void fenceGate(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.FENCE_GATE);
        Block ingredient = family.getBlock(CBlockFamily.MemberType.BASE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)result).define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('W'), (ItemLike)ingredient).pattern("#W#").pattern("#W#").group(family.getFamilyType().equals((Object)CBlockFamily.FamilyType.PLANKS) ? "wooden_fence_gate" : null).unlockedBy(CRecipeProvider.getHasName((ItemLike)ingredient), CRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void door(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.DOOR);
        Block ingredient = family.getBlock(CBlockFamily.MemberType.BASE);
        CRecipeProvider.doorBuilder((ItemLike)result, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient})).group(family.getFamilyType().equals((Object)CBlockFamily.FamilyType.PLANKS) ? "wooden_door" : null).unlockedBy(CRecipeProvider.getHasName((ItemLike)ingredient), CRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void trapDoor(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.TRAPDOOR);
        Block ingredient = family.getBlock(CBlockFamily.MemberType.BASE);
        CRecipeProvider.trapdoorBuilder((ItemLike)result, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient})).group(family.getFamilyType().equals((Object)CBlockFamily.FamilyType.PLANKS) ? "wooden_trapdoor" : null).unlockedBy(CRecipeProvider.getHasName((ItemLike)ingredient), CRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void pressurePlate(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.PRESSURE_PLATE);
        Block ingredient = family.getBlock(CBlockFamily.MemberType.BASE);
        CRecipeProvider.pressurePlateBuilder((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)result, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient})).group(family.getFamilyType().equals((Object)CBlockFamily.FamilyType.PLANKS) ? "wooden_pressure_plate" : null).unlockedBy(CRecipeProvider.getHasName((ItemLike)ingredient), CRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void button(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.BUTTON);
        Block ingredient = family.getBlock(CBlockFamily.MemberType.BASE);
        CRecipeProvider.buttonBuilder((ItemLike)result, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient})).group(family.getFamilyType().equals((Object)CBlockFamily.FamilyType.PLANKS) ? "wooden_button" : null).unlockedBy(CRecipeProvider.getHasName((ItemLike)ingredient), CRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void sign(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.SIGN);
        Block ingredient = family.getBlock(CBlockFamily.MemberType.BASE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)3).group(family.getFamilyType().equals((Object)CBlockFamily.FamilyType.PLANKS) ? "wooden_sign" : null).define(Character.valueOf('#'), (ItemLike)ingredient).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).pattern("###").pattern("###").pattern(" X ").unlockedBy(CRecipeProvider.getHasName((ItemLike)ingredient), CRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected void hangingSign(CBlockFamily family, RecipeOutput recipeOutput) {
        Block result = family.getBlock(CBlockFamily.MemberType.HANGING_SIGN);
        Block ingredient = family.getBlock(CBlockFamily.MemberType.BASE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)6).group("hanging_sign").define(Character.valueOf('#'), (ItemLike)ingredient).define(Character.valueOf('X'), (ItemLike)Items.CHAIN).pattern("X X").pattern("###").pattern("###").unlockedBy("has_stripped_logs", CRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, this.rl(CRecipeProvider.getItemName((ItemLike)result)));
    }

    protected ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)path);
    }
}

