/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.entity;

import com.calemi.ccore.api.boat.CBoatType;
import com.calemi.ccore.api.boat.CBoatTypeRegistry;
import com.calemi.ccore.impl.entity.CEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CChestBoat
extends ChestBoat {
    public CChestBoat(EntityType<? extends CChestBoat> type, Level level) {
        super(type, level);
        this.blocksBuilding = true;
    }

    public CChestBoat(Level level, double x, double y, double z) {
        this(CEntities.CHEST_BOAT.get(), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putString("Type", this.getBoatType().getName());
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        if (nbt.contains("Type", 8)) {
            this.entityData.set(DATA_ID_TYPE, (Object)CBoatTypeRegistry.getIndex(CBoatTypeRegistry.byName(nbt.getString("Type"))));
        }
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.lastYd = this.getDeltaMovement().y;
        if (!this.isPassenger()) {
            if (onGround) {
                if (this.fallDistance > 3.0f) {
                    if (this.status != Boat.Status.ON_LAND) {
                        this.resetFallDistance();
                        return;
                    }
                    this.causeFallDamage(this.fallDistance, 1.0f, this.damageSources().fall());
                    if (!this.level().isClientSide && !this.isRemoved()) {
                        this.kill();
                        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            for (int i = 0; i < 3; ++i) {
                                this.spawnAtLocation((ItemLike)this.getBoatType().getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.spawnAtLocation((ItemLike)Items.STICK);
                            }
                        }
                    }
                }
                this.resetFallDistance();
            } else if (!this.level().getFluidState(this.blockPosition().below()).is(FluidTags.WATER) && y < 0.0) {
                this.fallDistance -= (float)y;
            }
        }
    }

    public Item getDropItem() {
        return (Item)this.getBoatType().getChestBoatItem().get();
    }

    public void setBoatType(CBoatType type) {
        this.entityData.set(DATA_ID_TYPE, (Object)CBoatTypeRegistry.getIndex(type));
    }

    public CBoatType getBoatType() {
        return CBoatTypeRegistry.byIndex((Integer)this.entityData.get(DATA_ID_TYPE));
    }

    @Deprecated
    public Boat.Type getVariant() {
        return Boat.Type.OAK;
    }

    @Deprecated
    public void setVariant(Boat.Type vanillaType) {
    }
}

