/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.item;

import com.calemi.ccore.api.item.ItemSpawnProfile;
import com.calemi.ccore.api.location.BlockLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class ItemDropCollection {
    private final List<ItemStack> drops = new ArrayList<ItemStack>();

    public void addDrop(ItemStack stack) {
        int currentCount = stack.getCount();
        for (ItemStack drop : this.drops) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)drop, (ItemStack)stack) || drop.getCount() > drop.getMaxStackSize()) continue;
            int spaceLeft = drop.getMaxStackSize() - drop.getCount();
            if (currentCount > spaceLeft) {
                currentCount -= spaceLeft;
                drop.setCount(drop.getMaxStackSize());
                continue;
            }
            drop.setCount(drop.getCount() + stack.getCount());
            return;
        }
        stack.setCount(currentCount);
        this.drops.add(stack);
    }

    public void dropAll(BlockLocation location) {
        for (ItemStack drop : this.drops) {
            ItemSpawnProfile itemSpawnProfile = new ItemSpawnProfile().setStack(drop).setDestination(location);
            itemSpawnProfile.spawn();
        }
    }
}

