/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.item;

import com.calemi.ccore.api.location.BlockLocation;
import com.calemi.ccore.api.math.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemSpawnProfile {
    private Level level;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private ItemStack stack = ItemStack.EMPTY;
    private int amount = 0;

    public ItemEntity spawn() {
        ItemStack stackCopy = this.stack.copy();
        stackCopy.setCount(this.amount);
        ItemEntity item = new ItemEntity(this.level, this.x, this.y, this.z, stackCopy);
        item.setNoPickUpDelay();
        item.setDeltaMovement((double)(-0.05f + MathHelper.random.nextFloat() * 0.1f), (double)(-0.05f + MathHelper.random.nextFloat() * 0.1f), (double)(-0.05f + MathHelper.random.nextFloat() * 0.1f));
        this.level.addFreshEntity((Entity)item);
        return item;
    }

    public ItemSpawnProfile setDestination(Level level, float x, float y, float z) {
        this.level = level;
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public ItemSpawnProfile setDestination(Entity entity) {
        this.x = entity.getX();
        this.y = entity.getY();
        this.z = entity.getZ();
        this.level = entity.level();
        return this;
    }

    public ItemSpawnProfile setDestination(BlockLocation location) {
        this.x = (float)location.getX() + 0.5f;
        this.y = (float)location.getY() + 0.5f;
        this.z = (float)location.getZ() + 0.5f;
        this.level = location.getLevel();
        return this;
    }

    public ItemSpawnProfile setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public ItemSpawnProfile setItem(Item item) {
        this.stack = new ItemStack((ItemLike)item);
        this.amount = 1;
        return this;
    }

    public ItemSpawnProfile setStack(ItemStack stack) {
        this.stack = stack;
        this.amount = stack.getCount();
        return this;
    }
}

