/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.SmithingTemplateItem;

public class SmithingTemplateHelper {
    public static SmithingTemplateItem createCustomUpgradeTemplate(String modId, String upgradeName, List<String> baseMaterialNames, List<String> additionMaterialNames) {
        return new SmithingTemplateItem(SmithingTemplateHelper.appliesToDescription(modId, upgradeName), SmithingTemplateHelper.ingredients(modId, upgradeName), SmithingTemplateHelper.upgradeDescription(modId, upgradeName), SmithingTemplateHelper.baseSlotDescription(modId, upgradeName), SmithingTemplateHelper.additionsSlotDescription(modId, upgradeName), SmithingTemplateHelper.toEmptySlotIconList(modId, baseMaterialNames), SmithingTemplateHelper.toEmptySlotIconList(modId, additionMaterialNames), new FeatureFlag[0]);
    }

    private static Component appliesToDescription(String modId, String upgradeName) {
        return Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)("smithing_template." + upgradeName + "_upgrade.applies_to")))).withStyle(ChatFormatting.BLUE);
    }

    private static Component ingredients(String modId, String upgradeName) {
        return Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)("smithing_template." + upgradeName + "_upgrade.ingredients")))).withStyle(ChatFormatting.BLUE);
    }

    private static Component upgradeDescription(String modId, String upgradeName) {
        return Component.translatable((String)Util.makeDescriptionId((String)"upgrade", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)"smithing_upgrade"))).withStyle(ChatFormatting.GRAY);
    }

    private static Component baseSlotDescription(String modId, String upgradeName) {
        return Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)("smithing_template." + upgradeName + "_upgrade.base_slot_description"))));
    }

    private static Component additionsSlotDescription(String modId, String upgradeName) {
        return Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)("smithing_template." + upgradeName + "_upgrade.additions_slot_description"))));
    }

    private static List<ResourceLocation> toEmptySlotIconList(String modId, List<String> materialNames) {
        return materialNames.stream().map(materialName -> ResourceLocation.fromNamespaceAndPath((String)modId, (String)("item/empty_slot_" + materialName))).toList();
    }
}

