/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.location;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class BlockLocation {
    private Level level;
    private BlockPos blockPos;

    public BlockLocation(Level level, int x, int y, int z) {
        this.level = level;
        this.blockPos = new BlockPos(x, y, z);
    }

    public BlockLocation(Level level, BlockPos blockPos) {
        this(level, blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    public BlockLocation(BlockEntity blockEntity) {
        this(blockEntity.getLevel(), blockEntity.getBlockPos());
    }

    public BlockLocation(Entity entity) {
        this(entity.level(), entity.getBlockX(), entity.getBlockY(), entity.getBlockZ());
    }

    public BlockLocation copy() {
        return new BlockLocation(this.level, this.blockPos);
    }

    public BlockLocation offset(int x, int y, int z) {
        this.setBlockPos(this.blockPos.offset(x, y, z));
        return this;
    }

    public BlockLocation relative(Direction dir, int distance) {
        this.setBlockPos(this.blockPos.relative(dir, distance));
        return this;
    }

    public BlockLocation relative(Direction dir) {
        return this.relative(dir, 1);
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public void setBlockPos(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public int getX() {
        return this.blockPos.getX();
    }

    public int getY() {
        return this.blockPos.getY();
    }

    public int getZ() {
        return this.blockPos.getZ();
    }

    public Block getBlock() {
        return this.getBlockState().getBlock();
    }

    public boolean setBlock(BlockState newState, int flags, int recursionLeft) {
        return this.getLevel().setBlock(this.getBlockPos(), newState, flags, recursionLeft);
    }

    public boolean setBlock(BlockState newState, int flags) {
        return this.setBlock(newState, flags, 512);
    }

    public boolean setBlock(BlockState newState) {
        return this.getLevel().setBlockAndUpdate(this.getBlockPos(), newState);
    }

    public boolean removeBlock(boolean isMoving) {
        return this.getLevel().removeBlock(this.getBlockPos(), isMoving);
    }

    public boolean destroyBlock(boolean dropBlock, @Nullable Entity entity, int recursionLeft) {
        return this.getLevel().destroyBlock(this.getBlockPos(), dropBlock, entity, recursionLeft);
    }

    public void destroyBlockProgress(int breakerId, int progress) {
        this.getLevel().destroyBlockProgress(breakerId, this.getBlockPos(), progress);
    }

    public BlockState getBlockState() {
        return this.getLevel().getBlockState(this.getBlockPos());
    }

    public boolean isState(Predicate<BlockState> state) {
        return this.getLevel().isStateAtPosition(this.getBlockPos(), state);
    }

    public List<ItemStack> getBlockDropsFromBreaking(Player breaker, ItemStack heldStack) {
        return Block.getDrops((BlockState)this.getBlockState(), (ServerLevel)((ServerLevel)this.level), (BlockPos)this.getBlockPos(), (BlockEntity)this.getBlockEntity(), (Entity)breaker, (ItemStack)heldStack);
    }

    public int getBlockExperienceFromBreaking(Player breaker, ItemStack heldStack) {
        return this.getBlockState().getExpDrop((LevelAccessor)this.getLevel(), this.getBlockPos(), this.getBlockEntity(), (Entity)breaker, heldStack);
    }

    public void spawnExperience(int amount) {
        this.getBlock().popExperience((ServerLevel)this.getLevel(), this.getBlockPos(), amount);
    }

    public FluidState getFluidState() {
        return this.getLevel().getFluidState(this.getBlockPos());
    }

    public boolean isFluid(Predicate<FluidState> state) {
        return this.getLevel().isFluidAtPosition(this.getBlockPos(), state);
    }

    public BlockEntity getBlockEntity() {
        return this.getLevel().getBlockEntity(this.getBlockPos());
    }

    public void removeBlockEntity() {
        this.getLevel().removeBlockEntity(this.getBlockPos());
    }

    public void blockEntityChanged() {
        this.getLevel().blockEntityChanged(this.getBlockPos());
    }

    public boolean isInWorldBounds() {
        return this.getLevel().isInWorldBounds(this.getBlockPos());
    }

    public boolean isLoaded() {
        return this.getLevel().isLoaded(this.getBlockPos());
    }

    public boolean mayInteract(Player player) {
        return this.getLevel().mayInteract(player, this.getBlockPos());
    }

    public boolean isRaining() {
        return this.getLevel().isRainingAt(this.getBlockPos());
    }

    public LevelChunk getChunk() {
        return this.getLevel().getChunkAt(this.getBlockPos());
    }

    public void blockEvent(Block block, int eventId, int eventParam) {
        this.getLevel().blockEvent(this.getBlockPos(), block, eventId, eventParam);
    }

    public void globalLevelEntity(int eventId, int data) {
        this.getLevel().globalLevelEvent(eventId, this.getBlockPos(), data);
    }

    public DifficultyInstance getCurrentDifficulty() {
        return this.getLevel().getCurrentDifficultyAt(this.getBlockPos());
    }

    public SoundType getSoundType(BlockState state) {
        return state.getSoundType((LevelReader)this.getLevel(), this.getBlockPos(), null);
    }

    public SoundType getSoundType() {
        return this.getBlockState().getSoundType((LevelReader)this.getLevel(), this.getBlockPos(), null);
    }

    public double getDistance(BlockLocation blockLocation) {
        int dx = this.getX() - blockLocation.getX();
        int dy = this.getY() - blockLocation.getY();
        int dz = this.getZ() - blockLocation.getZ();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockLocation) {
            BlockLocation compareBlockLocation = (BlockLocation)obj;
            return this.level.equals(compareBlockLocation.getLevel()) && this.getBlockPos().equals((Object)compareBlockLocation.getBlockPos());
        }
        return super.equals(obj);
    }

    public String toString() {
        return "[" + this.getX() + ", " + this.getY() + ", " + this.getZ() + "]";
    }
}

