/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.loot.modifier;

import com.calemi.ccore.api.math.MathHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class BonusItemLootModifier
extends LootModifier {
    private final float chance;
    private final ItemStack bonusItem;
    public static final MapCodec<BonusItemLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IGlobalLootModifier.LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(glm -> glm.conditions), (App)Codec.FLOAT.fieldOf("chance").forGetter(b -> Float.valueOf(b.chance)), (App)ItemStack.CODEC.fieldOf("bonus_item").forGetter(b -> b.bonusItem)).apply((Applicative)instance, BonusItemLootModifier::new));

    public BonusItemLootModifier(LootItemCondition[] conditionsIn, float chance, ItemStack bonusItem) {
        super(conditionsIn);
        this.chance = chance;
        this.bonusItem = bonusItem;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (MathHelper.rollChance(this.chance)) {
            generatedLoot.add((Object)this.bonusItem.copy());
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

