/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.math;

import java.util.Random;
import net.minecraft.client.gui.screens.Screen;

public class MathHelper {
    public static final Random random = new Random();

    public static int[] getCountingArray(int startingValue, int endingValue) {
        if (endingValue < startingValue) {
            return new int[0];
        }
        int length = endingValue - startingValue;
        int[] array = new int[length + 1];
        for (int i = 0; i < array.length; ++i) {
            array[i] = startingValue + i;
        }
        return array;
    }

    public static int getAmountToAdd(int startingValue, int amountToAdd, int maxAmount) {
        if (startingValue + amountToAdd > maxAmount) {
            return 0;
        }
        return amountToAdd;
    }

    public static int getAmountToFill(int startingValue, int amountToAdd, int maxAmount) {
        if (startingValue + amountToAdd > maxAmount) {
            return maxAmount - startingValue;
        }
        return 0;
    }

    public static int scaleInt(int value, int maxValue, int desiredMaxScale) {
        float f = (float)value * (float)desiredMaxScale / (float)maxValue;
        return (int)f;
    }

    public static boolean rollChance(double chance) {
        return random.nextDouble() <= chance;
    }

    public static float randomRange(float min, float max) {
        return min + (float)Math.random() * (max - min);
    }

    public static long clamp(long value, long min, long max) {
        return value < min ? min : Math.min(value, max);
    }

    public static int getShiftCtrlInt(int defaultValue, int shiftValue, int ctrlValue, int bothValue) {
        int i = defaultValue;
        boolean s = Screen.hasShiftDown();
        boolean c = Screen.hasControlDown();
        if (s) {
            i = shiftValue;
        }
        if (c) {
            i = ctrlValue;
        }
        if (s && c) {
            i = bothValue;
        }
        return i;
    }
}

