/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.raytrace;

import com.calemi.ccore.api.location.BlockLocation;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RayTraceHelper {
    public static BlockTrace rayTraceBlock(Level level, Player player, double maxDistance) {
        Vec3 playerPosVec = new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
        Vec3 playerLookVec = player.getLookAngle();
        Direction playerLookDir = Direction.getNearest((double)playerLookVec.x, (double)playerLookVec.y, (double)playerLookVec.z);
        BlockHitResult rayTrace = level.clip(new ClipContext(playerPosVec, playerPosVec.add(playerLookVec.scale(maxDistance)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        UseOnContext itemUseContext = new UseOnContext(player, InteractionHand.MAIN_HAND, rayTrace);
        BlockPlaceContext blockUseContext = new BlockPlaceContext(itemUseContext);
        if (rayTrace.getType() == HitResult.Type.BLOCK) {
            BlockPos pos = blockUseContext.getClickedPos();
            BlockLocation locationOffset = new BlockLocation(level, pos);
            BlockPos difference = locationOffset.getBlockPos().subtract((Vec3i)itemUseContext.getClickedPos());
            Direction blockSide = Direction.getNearest((float)difference.getX(), (float)difference.getY(), (float)difference.getZ());
            BlockLocation locationReal = locationOffset.copy();
            locationReal.relative(blockSide.getOpposite(), 1);
            return new BlockTrace(locationReal, blockSide);
        }
        return null;
    }

    public static Entity rayTraceEntity(Level level, Player player, int maxDistance) {
        Entity entityHit = null;
        for (int i = 0; i < maxDistance; ++i) {
            Vec3 playerLookVec = player.getLookAngle();
            Vec3 playerLookVecOffset = new Vec3(player.getX() + playerLookVec.x * (double)i, player.getY() + playerLookVec.y * (double)i, player.getZ() + playerLookVec.z * (double)i);
            List entities = level.getEntities((Entity)player, new AABB(playerLookVecOffset.add(-1.0, -1.0, -1.0), playerLookVecOffset.add(1.0, 1.0, 1.0)), entity -> entity instanceof LivingEntity);
            if (entities.isEmpty()) continue;
            entityHit = (Entity)entities.getFirst();
            break;
        }
        return entityHit;
    }

    public record BlockTrace(BlockLocation hit, Direction hitSide) {
        public BlockLocation getHit() {
            return this.hit;
        }

        public Direction getHitSide() {
            return this.hitSide;
        }
    }
}

