/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.sound;

import com.calemi.ccore.api.location.BlockLocation;
import com.calemi.ccore.api.math.MathHelper;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SoundProfile {
    private SoundEvent soundEvent = null;
    private SoundSource soundSource = SoundSource.PLAYERS;
    private Level level = null;
    private Vec3 position = null;
    private Random random = new Random();
    private float minVolume = 1.0f;
    private float maxVolume = 1.0f;
    private float minPitch = 1.0f;
    private float maxPitch = 1.0f;
    private boolean distanceDelay = false;

    public SoundEvent getSoundEvent() {
        return this.soundEvent;
    }

    public SoundSource getSoundSource() {
        return this.soundSource;
    }

    public Level getLevel() {
        return this.level;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public Random getRandom() {
        return this.random;
    }

    public float getMinVolume() {
        return this.minVolume;
    }

    public float getMaxVolume() {
        return this.maxVolume;
    }

    public float getMinPitch() {
        return this.minPitch;
    }

    public float getMaxPitch() {
        return this.maxPitch;
    }

    public float getVolume() {
        if (this.minVolume == this.maxVolume) {
            return this.minVolume;
        }
        return MathHelper.randomRange(this.minVolume, this.maxVolume);
    }

    public float getPitch() {
        if (this.minPitch == this.maxPitch) {
            return this.minPitch;
        }
        return MathHelper.randomRange(this.minPitch, this.maxPitch);
    }

    public boolean hasDistanceDelay() {
        return this.distanceDelay;
    }

    public SoundProfile setLevel(Level level) {
        this.level = level;
        return this;
    }

    public SoundProfile setLevel(Player player) {
        this.level = player.level();
        return this;
    }

    public SoundProfile setLevel(BlockLocation location) {
        this.level = location.getLevel();
        return this;
    }

    public SoundProfile setPosition(Vec3 position) {
        this.position = position;
        return this;
    }

    public SoundProfile setPosition(Player player) {
        this.setPosition(player.position());
        return this;
    }

    public SoundProfile setPosition(BlockPos blockPos) {
        this.position = new Vec3((double)((float)blockPos.getX() + 0.5f), (double)((float)blockPos.getY() + 0.5f), (double)((float)blockPos.getZ() + 0.5f));
        return this;
    }

    public SoundProfile setPosition(BlockLocation location) {
        this.setPosition(location.getBlockPos());
        return this;
    }

    public SoundProfile setLevelAndPosition(Player player) {
        this.setLevel(player);
        this.setPosition(player);
        return this;
    }

    public SoundProfile setLevelAndPosition(BlockLocation location) {
        this.setLevel(location);
        this.setPosition(location);
        return this;
    }

    public SoundProfile setEvent(SoundEvent soundEvent) {
        this.soundEvent = soundEvent;
        return this;
    }

    public SoundProfile setSource(SoundSource soundSource) {
        this.soundSource = soundSource;
        return this;
    }

    public SoundProfile setRandom(Random random) {
        this.random = random;
        return this;
    }

    public SoundProfile setVolume(float minVolume, float maxVolume) {
        this.minVolume = minVolume;
        this.maxVolume = maxVolume;
        return this;
    }

    public SoundProfile setVolume(float volume) {
        return this.setVolume(volume, volume);
    }

    public SoundProfile setPitch(float minPitch, float maxPitch) {
        this.minPitch = minPitch;
        this.maxPitch = maxPitch;
        return this;
    }

    public SoundProfile setPitch(float pitch) {
        return this.setPitch(pitch, pitch);
    }

    public SoundProfile setHasDistanceDelay(boolean distanceDelay) {
        this.distanceDelay = distanceDelay;
        return this;
    }

    public void play(@Nullable Player ignorePlayer) {
        this.getLevel().playSound(ignorePlayer, this.position.x, this.position.y, this.position.z, this.getSoundEvent(), this.getSoundSource(), this.getVolume(), this.getPitch());
    }

    public void play() {
        this.play(null);
    }

    public void playLocal() {
        this.getLevel().playLocalSound(this.position.x, this.position.y, this.position.z, this.getSoundEvent(), this.getSoundSource(), this.getVolume(), this.getPitch(), this.distanceDelay);
    }

    public void playPacket(ServerPlayer player) {
        player.connection.send((Packet)new ClientboundSoundPacket(Holder.direct((Object)this.getSoundEvent()), this.getSoundSource(), this.position.x, this.position.y, this.position.z, this.getVolume(), this.getPitch(), this.random.nextLong()));
    }

    public void playGlobal() {
        for (Player player : this.level.players()) {
            this.playLocal();
        }
    }
}

