/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.api.tooltip;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TooltipHelper {
    public static void addInformationLoreFirst(List<Component> tooltipList, MutableComponent loreComponent) {
        if (!TooltipHelper.addInformationLore(tooltipList, loreComponent)) {
            tooltipList.add((Component)TooltipHelper.getPlateText("key.shift", ChatFormatting.AQUA).append(" ").append((Component)Component.translatable((String)"ccore.lore.info").withStyle(ChatFormatting.GRAY)));
        }
    }

    public static boolean addInformationLore(List<Component> tooltipList, MutableComponent loreComponent) {
        if (Screen.hasShiftDown()) {
            tooltipList.add((Component)loreComponent.withStyle(ChatFormatting.GRAY));
            return true;
        }
        return false;
    }

    public static void addControlsLoreFirst(List<Component> tooltipList, MutableComponent loreComponent, ControlType controlType) {
        if (!TooltipHelper.addControlsLore(tooltipList, loreComponent, controlType)) {
            tooltipList.add((Component)TooltipHelper.getPlateText("key.ctrl", ChatFormatting.AQUA).append(" ").append((Component)Component.translatable((String)"ccore.lore.controls").withStyle(ChatFormatting.GRAY)));
        }
    }

    public static boolean addControlsLore(List<Component> tooltipList, MutableComponent loreComponent, ControlType controlType) {
        if (Screen.hasControlDown()) {
            TooltipHelper.addActionLore(tooltipList, loreComponent.withStyle(ChatFormatting.GRAY), controlType);
            return true;
        }
        return false;
    }

    private static void addActionLore(List<Component> tooltipList, MutableComponent loreComponent, ControlType controlType) {
        tooltipList.add((Component)TooltipHelper.getPlateText(controlType.getName(), ChatFormatting.YELLOW).append(" ").append((Component)loreComponent));
    }

    public static void addBlankLine(List<Component> tooltipList) {
        tooltipList.add((Component)Component.literal((String)"   "));
    }

    public static MutableComponent getPlateText(String valueKey, ChatFormatting format) {
        return Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "[")).append((Component)Component.translatable((String)("ccore.lore." + valueKey)).withStyle(format)).append(String.valueOf(ChatFormatting.GRAY) + "]");
    }

    public static enum ControlType {
        USE("use"),
        USE_OPEN_HAND("use-open-hand"),
        RELEASE_USE("release-use"),
        SNEAK_USE("sneak-use"),
        LEFT_CLICK_BLOCK("left-click-block"),
        SNEAK_LEFT_CLICK_BLOCK("sneak-left-click-block"),
        SNEAK_BREAK_BLOCK("sneak-break-block");

        private final String key;

        private ControlType(String key) {
            this.key = key;
        }

        String getName() {
            return "control_type." + this.key;
        }
    }
}

