/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.ccore.impl.entity;

import com.calemi.ccore.api.entity.CBoat;
import com.calemi.ccore.api.entity.CChestBoat;
import com.calemi.ccore.main.CCore;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"ccore");
    public static final Supplier<EntityType<CBoat>> BOAT = CEntities.register("boat", EntityType.Builder.of(CBoat::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).clientTrackingRange(10));
    public static final Supplier<EntityType<CChestBoat>> CHEST_BOAT = CEntities.register("chest_boat", EntityType.Builder.of(CChestBoat::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).clientTrackingRange(10));

    public static <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> register(String name, EntityType.Builder<E> builder) {
        return ENTITY_TYPES.register(name, () -> builder.build("ccore:" + name));
    }

    public static void init() {
        CCore.LOGGER.info("Registering: Entity Types - Start");
        ENTITY_TYPES.register(CCore.MOD_EVENT_BUS);
        CCore.LOGGER.info("Registering: Entity Types - End");
    }
}

