/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.neoforge;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.djefrey.colorwheel.engine.uniform.ClrwlFrameUniforms;
import dev.djefrey.colorwheel.engine.uniform.ClrwlShadowFrameUniforms;
import dev.djefrey.colorwheel.engine.uniform.DebugMode;
import dev.djefrey.colorwheel.neoforge.ClrwlConfigNeoForge;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ClrwlCommandsNeoForge {
    public static void registerClientCommands(RegisterClientCommandsEvent event) {
        LiteralArgumentBuilder command = Commands.literal((String)"colorwheel");
        ModConfigSpec.BooleanValue alertIncompatiblePack = ClrwlConfigNeoForge.INSTANCE.client.alertIncompatiblePack;
        ModConfigSpec.BooleanValue alertBrokenPack = ClrwlConfigNeoForge.INSTANCE.client.alertBrokenPack;
        LiteralArgumentBuilder debug = Commands.literal((String)"debug");
        debug.then(Commands.literal((String)"shader").then(Commands.argument((String)"mode", (ArgumentType)DebugMode.CommandArgument.INSTANCE).executes(ctx -> {
            DebugMode mode = (DebugMode)((Object)((Object)ctx.getArgument("mode", DebugMode.class)));
            ClrwlFrameUniforms.debugMode(mode);
            return 1;
        })));
        debug.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"frustum").then(Commands.literal((String)"capture").executes(ctx -> {
            ClrwlFrameUniforms.captureFrustum();
            ClrwlShadowFrameUniforms.captureFrustum();
            return 1;
        }))).then((ArgumentBuilder)Commands.literal((String)"unpause"))).executes(ctx -> {
            ClrwlFrameUniforms.unpauseFrustum();
            ClrwlShadowFrameUniforms.unpauseFrustum();
            return 1;
        }));
        command.then((ArgumentBuilder)debug);
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"alertIncompatiblePack").executes(ctx -> {
            if (((Boolean)alertIncompatiblePack.get()).booleanValue()) {
                ClrwlCommandsNeoForge.sendMessage((CommandSourceStack)ctx.getSource(), (Component)Component.translatable((String)"command.colorwheel.alert_incompatible_pack.get.on"));
            } else {
                ClrwlCommandsNeoForge.sendMessage((CommandSourceStack)ctx.getSource(), (Component)Component.translatable((String)"command.colorwheel.alert_incompatible_pack.get.off"));
            }
            return 1;
        })).then(Commands.literal((String)"on").executes(ctx -> {
            alertIncompatiblePack.set((Object)true);
            ClrwlCommandsNeoForge.sendMessage((CommandSourceStack)ctx.getSource(), (Component)Component.translatable((String)"command.colorwheel.alert_incompatible_pack.set.on"));
            return 1;
        }))).then(Commands.literal((String)"off").executes(ctx -> {
            alertIncompatiblePack.set((Object)false);
            ClrwlCommandsNeoForge.sendMessage((CommandSourceStack)ctx.getSource(), (Component)Component.translatable((String)"command.colorwheel.alert_incompatible_pack.set.off"));
            return 1;
        })));
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"alertBrokenPack").executes(ctx -> {
            if (((Boolean)alertBrokenPack.get()).booleanValue()) {
                ClrwlCommandsNeoForge.sendMessage((CommandSourceStack)ctx.getSource(), (Component)Component.translatable((String)"command.colorwheel.alert_broken_pack.get.on"));
            } else {
                ClrwlCommandsNeoForge.sendMessage((CommandSourceStack)ctx.getSource(), (Component)Component.translatable((String)"command.colorwheel.alert_broken_pack.get.off"));
            }
            return 1;
        })).then(Commands.literal((String)"on").executes(ctx -> {
            alertBrokenPack.set((Object)true);
            ClrwlCommandsNeoForge.sendMessage((CommandSourceStack)ctx.getSource(), (Component)Component.translatable((String)"command.colorwheel.alert_broken_pack.set.on"));
            return 1;
        }))).then(Commands.literal((String)"off").executes(ctx -> {
            alertBrokenPack.set((Object)false);
            ClrwlCommandsNeoForge.sendMessage((CommandSourceStack)ctx.getSource(), (Component)Component.translatable((String)"command.colorwheel.alert_broken_pack.set.off"));
            return 1;
        })));
        event.getDispatcher().register(command);
    }

    private static void sendMessage(CommandSourceStack source, Component message) {
        source.sendSuccess(() -> message, true);
    }
}

