/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel_patcher.neoforge;

import dev.djefrey.colorwheel_patcher.ClrwlPatcher;
import dev.djefrey.colorwheel_patcher.Version;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLPaths;

@Mod(value="colorwheel_patcher")
public final class ClrwlPatcherNeoForge {
    private final Pattern VERSION_REGEX = Pattern.compile("(\\d+).(\\d+).(\\d+).*");

    public ClrwlPatcherNeoForge(IEventBus modBus) {
        modBus.addListener(this::onCommonSetup);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        String versionStr = ((ModContainer)ModList.get().getModContainerById("colorwheel_patcher").get()).getModInfo().getVersion().getQualifier();
        Matcher matcher = this.VERSION_REGEX.matcher(versionStr);
        if (!matcher.matches()) {
            throw new IllegalStateException("Could not parse Colorwheel mod version");
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int incremental = Integer.parseInt(matcher.group(3));
        Path shaderPath = FMLPaths.GAMEDIR.get().resolve("shaderpacks");
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("colorwheel_patcher");
        ClrwlPatcher.init(new Version(major, minor, incremental), shaderPath, configPath);
    }
}

