/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.neoforge.mixin.foundation.copycat.multistate;

import com.copycatsplus.copycats.content.copycat.cogwheel.CopycatCogWheelBlock;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.MaterialItemStorage;
import com.copycatsplus.copycats.foundation.copycat.multistate.MultiStateCopycatBlock;
import com.simibubi.create.AllBlocks;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.extensions.IBlockExtension;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MultiStateCopycatBlock.class, CopycatCogWheelBlock.class})
@Pseudo
public abstract class MultiStateCopycatBlockMixin
extends Block
implements IBlockExtension,
IMultiStateCopycatBlock {
    public MultiStateCopycatBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        Block block = state.getBlock();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            IMultiStateCopycatBlockEntity copycatBE = copycatBlock.getCopycatBlockEntity((BlockGetter)level, pos);
            if (copycatBE == null) {
                return super.getSoundType(state, level, pos, entity);
            }
            for (MaterialItemStorage.MaterialItem materialItem : copycatBE.getMaterialItemStorage().getAllMaterialItems()) {
                if (!materialItem.hasCustomMaterial()) continue;
                return materialItem.material().getSoundType(level, pos, entity);
            }
            return ICopycatBlock.getMaterial((BlockGetter)level, pos).getSoundType(level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        Block block = state.getBlock();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            float bonus = 0.0f;
            int count = 0;
            IMultiStateCopycatBlockEntity copycatBE = copycatBlock.getCopycatBlockEntity((BlockGetter)level, pos);
            if (copycatBE == null) {
                return super.getFriction(state, level, pos, entity);
            }
            for (String property : copycatBE.getMaterialItemStorage().getAllProperties()) {
                if (!copycatBlock.partExists(state, property)) continue;
                BlockState mat = copycatBE.getMaterialItemStorage().getMaterialItem(property).material();
                ++count;
                bonus += mat.is(Blocks.AIR) ? super.getFriction(state, level, pos, entity) : mat.getFriction(level, pos, entity);
            }
            return bonus / (float)count;
        }
        return super.getFriction(state, level, pos, entity);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        AuxiliaryLightManager lightManager = level.getAuxLightManager(pos);
        if (lightManager != null) {
            return lightManager.getLightAt(pos);
        }
        return super.getLightEmission(state, level, pos);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        Block block = state.getBlock();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            AtomicReference<Float> explosionResistance = new AtomicReference<Float>(Float.valueOf(state.getBlock().getExplosionResistance()));
            IMultiStateCopycatBlockEntity copycatBE = copycatBlock.getCopycatBlockEntity(level, pos);
            if (copycatBE == null) {
                return super.getExplosionResistance(state, level, pos, explosion);
            }
            copycatBE.getMaterialItemStorage().getAllMaterials().forEach(bs -> explosionResistance.accumulateAndGet(Float.valueOf(bs.getBlock().getExplosionResistance()), Math::max));
            return explosionResistance.get().floatValue();
        }
        return super.getExplosionResistance(state, level, pos, explosion);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockState material;
        String string;
        if (target == null) {
            string = null;
        } else {
            Direction direction;
            Vec3 vec3 = target.getLocation();
            if (target instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)target;
                direction = blockHit.getDirection();
            } else {
                direction = Direction.UP;
            }
            string = this.getPropertyFromInteraction(state, (BlockGetter)level, pos, vec3, direction, true);
        }
        String property = string;
        BlockState blockState = material = property == null ? ICopycatBlock.getMaterial((BlockGetter)level, pos) : IMultiStateCopycatBlock.getMaterial((BlockGetter)level, pos, property);
        if (AllBlocks.COPYCAT_BASE.has(material) || player != null && player.isSteppingCarefully()) {
            return new ItemStack((ItemLike)this);
        }
        return material.getBlock().getCloneItemStack(level, pos, material);
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        Block block = state1.getBlock();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            BlockHitResult hitResult = level.clip(new ClipContext(entity.position(), entity.position().add(0.0, -2.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)entity));
            String property = copycatBlock.getPropertyFromInteraction(state1, (BlockGetter)level, pos, hitResult, true);
            IMultiStateCopycatBlockEntity copycatBE = copycatBlock.getCopycatBlockEntity((BlockGetter)level, pos);
            if (copycatBE == null) {
                return super.addLandingEffects(state1, level, pos, state2, entity, numberOfParticles);
            }
            BlockState material = copycatBE.getMaterialItemStorage().getMaterialItem(property).material();
            return material.addLandingEffects(level, pos, material, entity, numberOfParticles);
        }
        return super.addLandingEffects(state1, level, pos, state2, entity, numberOfParticles);
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        Block block = state.getBlock();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            BlockHitResult hitResult = level.clip(new ClipContext(entity.position(), entity.position().add(0.0, -2.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, entity));
            String property = copycatBlock.getPropertyFromInteraction(state, (BlockGetter)level, pos, hitResult, true);
            IMultiStateCopycatBlockEntity copycatBE = copycatBlock.getCopycatBlockEntity((BlockGetter)level, pos);
            if (copycatBE == null) {
                return super.addRunningEffects(state, level, pos, entity);
            }
            BlockState material = copycatBE.getMaterialItemStorage().getMaterialItem(property).material();
            return material.addRunningEffects(level, pos, entity);
        }
        return super.addRunningEffects(state, level, pos, entity);
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        Block block = state.getBlock();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            AtomicReference<Float> bonus = new AtomicReference<Float>(Float.valueOf(0.0f));
            IMultiStateCopycatBlockEntity copycatBE = copycatBlock.getCopycatBlockEntity((BlockGetter)level, pos);
            if (copycatBE == null) {
                return super.getEnchantPowerBonus(state, level, pos);
            }
            copycatBE.getMaterialItemStorage().getAllMaterials().forEach(mat -> bonus.accumulateAndGet(Float.valueOf(mat.getEnchantPowerBonus(level, pos)), Float::max));
            return bonus.get().floatValue();
        }
        return super.getEnchantPowerBonus(state, level, pos);
    }

    public void fallOn(@NotNull Level pLevel, @NotNull BlockState state, @NotNull BlockPos pPos, @NotNull Entity pEntity, float p_152430_) {
        Block block = state.getBlock();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            BlockHitResult hitResult = pLevel.clip(new ClipContext(pEntity.position(), pEntity.position().add(0.0, -2.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, pEntity));
            String property = copycatBlock.getPropertyFromInteraction(state, (BlockGetter)pLevel, pPos, hitResult, true);
            IMultiStateCopycatBlockEntity copycatBE = copycatBlock.getCopycatBlockEntity((BlockGetter)pLevel, pPos);
            if (copycatBE == null) {
                super.fallOn(pLevel, state, pPos, pEntity, p_152430_);
                return;
            }
            BlockState material = copycatBE.getMaterialItemStorage().getMaterialItem(property).material();
            material.getBlock().fallOn(pLevel, material, pPos, pEntity, p_152430_);
        } else {
            super.fallOn(pLevel, state, pPos, pEntity, p_152430_);
        }
    }

    public float getDestroyProgress(@NotNull BlockState pState, @NotNull Player pPlayer, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        return super.getDestroyProgress(pState, pPlayer, pLevel, pPos);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter renderView, BlockPos pos, Direction side, @Nullable BlockState sourceState, @Nullable BlockPos sourcePos) {
        return IMultiStateCopycatBlock.getAppearance(this, state, renderView, pos, side, sourceState, sourcePos);
    }

    @Override
    @Unique
    public abstract BlockState rotate(BlockState var1, Rotation var2);

    @Override
    @Unique
    public abstract BlockState mirror(@NotNull BlockState var1, @NotNull Mirror var2);

    @Override
    @Unique
    public abstract ItemInteractionResult useItemOn(ItemStack var1, BlockState var2, Level var3, BlockPos var4, Player var5, InteractionHand var6, BlockHitResult var7);

    @Override
    @Unique
    public abstract InteractionResult useWithoutItem(BlockState var1, Level var2, BlockPos var3, Player var4, BlockHitResult var5);
}

