/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.net;

import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.corelib.death.DeathManager;
import de.maxhenkel.corpse.corelib.net.Message;
import de.maxhenkel.corpse.net.MessageOpenHistory;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageRequestDeathHistory
implements Message<MessageRequestDeathHistory> {
    public static final CustomPacketPayload.Type<MessageRequestDeathHistory> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"corpse", (String)"request_death_history"));

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        MessageRequestDeathHistory.sendDeathHistory(sender);
    }

    @Override
    public MessageRequestDeathHistory fromBytes(RegistryFriendlyByteBuf buf) {
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
    }

    @Override
    public CustomPacketPayload.Type<MessageRequestDeathHistory> type() {
        return TYPE;
    }

    public static boolean sendDeathHistory(ServerPlayer player) {
        return MessageRequestDeathHistory.sendDeathHistory(player, player.getUUID());
    }

    public static boolean sendDeathHistory(ServerPlayer playerToSend, UUID playerUUID) {
        List<Death> deaths = DeathManager.getDeaths(playerToSend.serverLevel(), playerUUID);
        if (deaths == null) {
            return false;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)playerToSend, (CustomPacketPayload)new MessageOpenHistory(deaths), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }
}

