/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.corpsecurioscompat.util;

import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosSlotDetector {
    public static boolean doesItemAddSlots(ItemStack stack, Player player, String slotType) {
        if (stack.isEmpty()) {
            return false;
        }
        Optional curiosOpt = CuriosApi.getCurio((ItemStack)stack);
        if (curiosOpt.isEmpty()) {
            return false;
        }
        ICurio curio = (ICurio)curiosOpt.get();
        SlotContext slotContext = new SlotContext(slotType, (LivingEntity)player, 0, false, true);
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"corpsecurioscompat", (String)"temp_check");
        Multimap modifiers = curio.getAttributeModifiers(slotContext, id);
        for (Map.Entry entry : modifiers.entries()) {
            Attribute attr = (Attribute)((Holder)entry.getKey()).value();
            AttributeModifier modifier = (AttributeModifier)entry.getValue();
            if (!(attr instanceof SlotAttribute)) continue;
            SlotAttribute slotAttr = (SlotAttribute)attr;
            if (!(modifier.amount() > 0.0) || modifier.operation() != AttributeModifier.Operation.ADD_VALUE) continue;
            return true;
        }
        Multimap stackModifiers = CuriosApi.getAttributeModifiers((SlotContext)slotContext, (ResourceLocation)id, (ItemStack)stack);
        for (Map.Entry entry : stackModifiers.entries()) {
            Attribute attr = (Attribute)((Holder)entry.getKey()).value();
            AttributeModifier modifier = (AttributeModifier)entry.getValue();
            if (!(attr instanceof SlotAttribute) || !(modifier.amount() > 0.0) || modifier.operation() != AttributeModifier.Operation.ADD_VALUE) continue;
            return true;
        }
        return false;
    }
}

