/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.integration.extradelight.recipe;

import com.google.common.cache.CacheBuilder;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.recipe.ToolOnBlockRecipe;
import com.lance5057.extradelight.workstations.juicer.JuicerRecipe;
import com.lance5057.extradelight.workstations.meltingpot.MeltingPotRecipe;
import com.lance5057.extradelight.workstations.mortar.recipes.MortarRecipe;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerRecipeSearchEvent;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.simibubi.create.content.kinetics.mixer.CompactingRecipe;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import plus.dragons.createcentralkitchen.config.CCKConfig;
import plus.dragons.createcentralkitchen.mixin.extradelight.SingleItemRecipeAccessor;
import plus.dragons.createdragonsplus.common.recipe.RecipeConverter;

public class ExtraDelightRecipeConverters {
    public static final RecipeConverter<MortarRecipe, CompactingRecipe> AUTOMATIC_GRINDING = RecipeConverter.cached((CacheBuilder)CacheBuilder.newBuilder(), holder -> {
        FluidStack fluid;
        MortarRecipe recipe = (MortarRecipe)holder.value();
        ResourceLocation id = holder.id().withSuffix("_using_press");
        StandardProcessingRecipe.Builder builder = (StandardProcessingRecipe.Builder)new StandardProcessingRecipe.Builder(CompactingRecipe::new, id).require((Ingredient)recipe.getIngredients().getFirst());
        ItemStack result = ((SingleItemRecipeAccessor)recipe).getResult();
        if (!result.isEmpty()) {
            builder.output(result);
        }
        if (!(fluid = recipe.getFluid()).isEmpty()) {
            builder.output(fluid);
        }
        return new RecipeHolder(id, (Recipe)((CompactingRecipe)builder.build()));
    });
    public static final RecipeConverter<JuicerRecipe, CompactingRecipe> AUTOMATIC_JUICING = RecipeConverter.cached((CacheBuilder)CacheBuilder.newBuilder(), holder -> {
        JuicerRecipe recipe = (JuicerRecipe)holder.value();
        ResourceLocation id = holder.id().withSuffix("_using_press");
        StandardProcessingRecipe.Builder builder = (StandardProcessingRecipe.Builder)new StandardProcessingRecipe.Builder(CompactingRecipe::new, id).require((Ingredient)recipe.getIngredients().getFirst());
        builder.output((float)recipe.getChance(), ((SingleItemRecipeAccessor)recipe).getResult());
        builder.output(recipe.getFluid());
        return new RecipeHolder(id, (Recipe)((CompactingRecipe)builder.build()));
    });
    public static final RecipeConverter<MeltingPotRecipe, MixingRecipe> AUTOMATIC_MELTING = RecipeConverter.cached((CacheBuilder)CacheBuilder.newBuilder(), holder -> {
        MeltingPotRecipe recipe = (MeltingPotRecipe)holder.value();
        ResourceLocation id = holder.id().withSuffix("_using_mixer");
        StandardProcessingRecipe.Builder builder = (StandardProcessingRecipe.Builder)new StandardProcessingRecipe.Builder(MixingRecipe::new, id).require(recipe.input);
        builder.output(recipe.result);
        builder.requiresHeat(HeatCondition.HEATED);
        return new RecipeHolder(id, (Recipe)((MixingRecipe)builder.build()));
    });
    public static final RecipeConverter<ToolOnBlockRecipe, DeployerApplicationRecipe> AUTOMATIC_GINGERBREAD_DECORATING = RecipeConverter.cached((CacheBuilder)CacheBuilder.newBuilder(), holder -> {
        ToolOnBlockRecipe recipe = (ToolOnBlockRecipe)holder.value();
        ResourceLocation id = holder.id().withSuffix("_using_deployer");
        ItemApplicationRecipe.Builder builder = (ItemApplicationRecipe.Builder)((ItemApplicationRecipe.Builder)((ItemApplicationRecipe.Builder)new ItemApplicationRecipe.Builder(DeployerApplicationRecipe::new, id).require((ItemLike)recipe.getIn())).require(recipe.getTool())).output((ItemLike)recipe.getOut());
        return new RecipeHolder(id, (Recipe)((DeployerApplicationRecipe)builder.build()));
    });

    @SubscribeEvent
    public static void onDeployerRecipeSearch(DeployerRecipeSearchEvent event) {
        if (((Boolean)CCKConfig.recipes().convertToolOnBlockRecipesToDeployingRecipes.get()).booleanValue()) {
            DeployerBlockEntity deployer = event.getBlockEntity();
            RecipeWrapper inventory = event.getInventory();
            Level level = deployer.getLevel();
            assert (level != null);
            event.addRecipe(() -> level.getRecipeManager().getAllRecipesFor((RecipeType)ExtraDelightRecipes.TOOL_ON_BLOCK.get()).stream().map(AUTOMATIC_GINGERBREAD_DECORATING).filter(holder -> ((DeployerApplicationRecipe)holder.value()).matches(inventory, level)).findFirst(), 50);
        }
    }
}

