/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.kinetics.fan.coloring;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import plus.dragons.createdragonsplus.common.kinetics.fan.coloring.ColoringRecipeInput;
import plus.dragons.createdragonsplus.common.kinetics.fan.coloring.ColoringRecipeParams;
import plus.dragons.createdragonsplus.common.registry.CDPRecipes;

public class ColoringRecipe
extends ProcessingRecipe<ColoringRecipeInput, ColoringRecipeParams> {
    public ColoringRecipe(ColoringRecipeParams params) {
        super(CDPRecipes.COLORING, (ProcessingRecipeParams)params);
    }

    public static Builder builder(ResourceLocation id, DyeColor color) {
        return new Builder(id, color);
    }

    public DyeColor getColor() {
        return ((ColoringRecipeParams)this.params).color;
    }

    public boolean matches(ColoringRecipeInput input, Level level) {
        return ((ColoringRecipeParams)this.params).color == input.color() && ((Ingredient)this.ingredients.getFirst()).test(input.item());
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 12;
    }

    public static class Builder
    extends ProcessingRecipeBuilder<ColoringRecipeParams, ColoringRecipe, Builder> {
        protected Builder(ResourceLocation recipeId, DyeColor color) {
            super(ColoringRecipe::new, recipeId);
            ((ColoringRecipeParams)this.params).color = color;
        }

        protected ColoringRecipeParams createParams() {
            return new ColoringRecipeParams();
        }

        public Builder self() {
            return this;
        }
    }

    public static class Serializer<R extends ColoringRecipe>
    implements RecipeSerializer<R> {
        private final MapCodec<R> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, R> streamCodec;

        public Serializer(ProcessingRecipe.Factory<ColoringRecipeParams, R> factory) {
            this.codec = ProcessingRecipe.codec(factory, ColoringRecipeParams.CODEC);
            this.streamCodec = ProcessingRecipe.streamCodec(factory, ColoringRecipeParams.STREAM_CODEC);
        }

        public MapCodec<R> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, R> streamCodec() {
            return this.streamCodec;
        }
    }
}

