/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createstuffadditions.item;

import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.List;
import java.util.function.Consumer;
import net.mcreator.createstuffadditions.init.CreateSaModItems;
import net.mcreator.createstuffadditions.item.renderer.PortableDrillItemRenderer;
import net.mcreator.createstuffadditions.network.CreateSaModVariables;
import net.mcreator.createstuffadditions.procedures.LocalizationHandlerProcedure;
import net.mcreator.createstuffadditions.procedures.PortableDrillBlockDestroyedWithToolProcedure;
import net.mcreator.createstuffadditions.procedures.PortableDrillToolInHandTickProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class PortableDrillItem
extends TieredItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 0;
        }

        public float getSpeed() {
            return 20.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_IRON_TOOL;
        }

        public int getEnchantmentValue() {
            return 0;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.ANDESITE), new ItemStack((ItemLike)Items.IRON_INGOT)});
        }
    };

    public PortableDrillItem() {
        super(TOOL_TIER, new Item.Properties().attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 4.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.8, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    @SubscribeEvent
    public static void handleToolDamage(ModifyDefaultComponentsEvent event) {
        event.modify((ItemLike)CreateSaModItems.PORTABLE_DRILL.get(), builder -> builder.remove(DataComponents.MAX_DAMAGE));
    }

    public boolean isCorrectToolForDrops(ItemStack itemstack, BlockState blockstate) {
        return !blockstate.is(BlockTags.NEEDS_DIAMOND_TOOL);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        return ItemAbilities.DEFAULT_AXE_ACTIONS.contains(toolAction) || ItemAbilities.DEFAULT_HOE_ACTIONS.contains(toolAction) || ItemAbilities.DEFAULT_SHOVEL_ACTIONS.contains(toolAction) || ItemAbilities.DEFAULT_PICKAXE_ACTIONS.contains(toolAction) || ItemAbilities.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    public float getDestroySpeed(ItemStack itemstack, BlockState blockstate) {
        return 20.0f;
    }

    public boolean mineBlock(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        itemstack.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
        PortableDrillBlockDestroyedWithToolProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)entity, itemstack);
        return true;
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        itemstack.hurtAndBreak(2, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
        return true;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBarWidth(ItemStack stack) {
        LocalPlayer entity;
        LocalPlayer localPlayer = entity = Minecraft.getInstance().player != null ? Minecraft.getInstance().player : null;
        if (entity != null) {
            if (((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") + ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater") > 2.0 * CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity) {
                return 13;
            }
            return (int)((((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") + ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater")) * (0.5 / CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity) * 13.0);
        }
        return (int)((((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") + ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater")) * 3.125E-4 * 13.0);
    }

    public int getBarColor(ItemStack stack) {
        return 0xFFFFFF;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        LocalPlayer entity = Minecraft.getInstance().player != null ? Minecraft.getInstance().player : null;
        int tagFuel = 0;
        int tagWater = 0;
        tagFuel = (int)((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel");
        tagWater = (int)((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater");
        if (entity != null) {
            if (Screen.hasShiftDown()) {
                list.add((Component)Component.literal((String)Component.translatable((String)"item_desc.holdshift").getString().replace("\u00a77", "\u00a7f")));
                list.add((Component)Component.literal((String)(Component.translatable((String)"item_desc.fuel").getString() + " \u00a78" + tagFuel + "/" + Math.round(CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity))));
                list.add((Component)Component.literal((String)(Component.translatable((String)"item_desc.water").getString() + " \u00a78" + tagWater + "/" + Math.round(CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity))));
                list.add((Component)Component.literal((String)" "));
                list.addAll(LocalizationHandlerProcedure.execute(Component.translatable((String)"item_desc.portable_drill.desc").getString(), 0));
            } else {
                list.add((Component)Component.literal((String)Component.translatable((String)"item_desc.holdshift").getString()));
                list.add((Component)Component.literal((String)(Component.translatable((String)"item_desc.fuel").getString() + " \u00a78" + tagFuel + "/" + Math.round(CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity))));
                list.add((Component)Component.literal((String)(Component.translatable((String)"item_desc.water").getString() + " \u00a78" + tagWater + "/" + Math.round(CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity))));
            }
        }
        super.appendHoverText(itemstack, context, list, flag);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new PortableDrillItemRenderer()));
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            PortableDrillToolInHandTickProcedure.execute(entity, itemstack);
        }
    }
}

