/*
 * Decompiled with CFR 0.152.
 */
package net.davio.aquaticambitions.content.processing.conduit;

import com.mojang.serialization.Codec;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import net.createmod.catnip.lang.Lang;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitBlockEntity;
import net.davio.aquaticambitions.registry.CAABlockEntityTypes;
import net.davio.aquaticambitions.registry.CAAShapes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MechanicalConduitBlock
extends Block
implements IBE<MechanicalConduitBlockEntity>,
IWrenchable,
ProperWaterloggedBlock {
    public static final EnumProperty<ConduitPowerLevel> CONDUIT_POWER_LEVEL = EnumProperty.create((String)"conduit", ConduitPowerLevel.class);

    public MechanicalConduitBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(CONDUIT_POWER_LEVEL, (Comparable)((Object)ConduitPowerLevel.IDLE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
        builder.add(new Property[]{CONDUIT_POWER_LEVEL});
    }

    public FluidState getFluidState(BlockState pState) {
        return this.fluidState(pState);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState defaultState = (BlockState)this.defaultBlockState().setValue(CONDUIT_POWER_LEVEL, (Comparable)((Object)ConduitPowerLevel.IDLE));
        return this.withWater(defaultState, context);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CAAShapes.MECH_CONDUIT_SHAPE;
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return pState;
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (context == CollisionContext.empty()) {
            return AllShapes.HEATER_BLOCK_SPECIAL_COLLISION_SHAPE;
        }
        return this.getShape(blockState, level, pos, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.nextInt(10) != 0) {
            return;
        }
        if (((ConduitPowerLevel)((Object)state.getValue(CONDUIT_POWER_LEVEL))).equals((Object)ConduitPowerLevel.AWAKENED)) {
            world.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), SoundEvents.CONDUIT_AMBIENT, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
        }
    }

    public static ConduitPowerLevel getConduitLevelOf(BlockState blockState) {
        return (ConduitPowerLevel)((Object)blockState.getValue(CONDUIT_POWER_LEVEL));
    }

    public Class<MechanicalConduitBlockEntity> getBlockEntityClass() {
        return MechanicalConduitBlockEntity.class;
    }

    public BlockEntityType<? extends MechanicalConduitBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CAABlockEntityTypes.MECHANICAL_CONDUIT.get();
    }

    public static int getLight(BlockState state) {
        ConduitPowerLevel level = (ConduitPowerLevel)((Object)state.getValue(CONDUIT_POWER_LEVEL));
        return switch (level.ordinal()) {
            case 0 -> 8;
            default -> 15;
        };
    }

    public static enum ConduitPowerLevel implements StringRepresentable
    {
        IDLE,
        AWAKENED;

        public static final Codec<ConduitPowerLevel> CODEC;

        public boolean isAwakened() {
            return this.ordinal() >= AWAKENED.ordinal();
        }

        public String getSerializedName() {
            return Lang.asId((String)this.name());
        }

        static {
            CODEC = StringRepresentable.fromEnum(ConduitPowerLevel::values);
        }
    }
}

