/*
 * Decompiled with CFR 0.152.
 */
package net.davio.aquaticambitions.registry;

import net.createmod.catnip.lang.Lang;
import net.davio.aquaticambitions.CreateAquaticAmbitions;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class CAATags {
    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.create((ResourceKey)registry.key(), (ResourceLocation)id);
    }

    public static <T> TagKey<T> commonTag(Registry<T> registry, String path) {
        return CAATags.optionalTag(registry, ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static <T> TagKey<T> modTag(Registry<T> registry, String path) {
        return CAATags.optionalTag(registry, CreateAquaticAmbitions.asResource(path));
    }

    public static TagKey<Block> commonBlockTag(String path) {
        return CAATags.commonTag(BuiltInRegistries.BLOCK, path);
    }

    public static TagKey<Item> commonItemTag(String path) {
        return CAATags.commonTag(BuiltInRegistries.ITEM, path);
    }

    public static TagKey<Fluid> commonFluidTag(String path) {
        return CAATags.commonTag(BuiltInRegistries.FLUID, path);
    }

    public static TagKey<Block> modBlockTag(String path) {
        return CAATags.modTag(BuiltInRegistries.BLOCK, path);
    }

    public static TagKey<Item> modItemTag(String path) {
        return CAATags.modTag(BuiltInRegistries.ITEM, path);
    }

    public static TagKey<Fluid> modFluidTag(String path) {
        return CAATags.modTag(BuiltInRegistries.FLUID, path);
    }

    public static void init() {
        CAABlockTags.init();
        CAAItemTags.init();
        CAAFluidTags.init();
    }

    public static enum CAABlockTags {
        FAN_PROCESSING_CATALYSTS_CHANNELING(NameSpace.MOD, "fan_processing_catalysts/channeling");

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private CAABlockTags() {
            this(NameSpace.MOD);
        }

        private CAABlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CAABlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CAABlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CAABlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? CAATags.optionalTag(BuiltInRegistries.BLOCK, id) : BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Block block) {
            return block.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.getItem()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).getBlock());
        }

        public boolean matches(BlockState state) {
            return state.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum CAAItemTags {
        UA_CORAL(NameSpace.MOD, "upgrade_aquatic/coral");

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private CAAItemTags() {
            this(NameSpace.MOD);
        }

        private CAAItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CAAItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CAAItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CAAItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? CAATags.optionalTag(BuiltInRegistries.ITEM, id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum CAAFluidTags {
        CONDUIT_FUEL(NameSpace.MOD, "mechanical_conduit_fuel"),
        CLEARS_EFFECTS(NameSpace.MOD, "conduit_effects/clears_effects"),
        GIVES_FIRE_RES(NameSpace.MOD, "conduit_effects/gives_fire_resistance"),
        GIVES_HASTE(NameSpace.MOD, "conduit_effects/gives_haste"),
        GIVES_INFESTED(NameSpace.MOD, "conduit_effects/gives_infested"),
        GIVES_INVIS(NameSpace.MOD, "conduit_effects/gives_invisibility"),
        GIVES_JUMP(NameSpace.MOD, "conduit_effects/gives_jump"),
        GIVES_LUCK(NameSpace.MOD, "conduit_effects/gives_luck"),
        GIVES_NIGHT_VISION(NameSpace.MOD, "conduit_effects/gives_night_vision"),
        GIVES_OOZING(NameSpace.MOD, "conduit_effects/gives_oozing"),
        GIVES_POISON(NameSpace.MOD, "conduit_effects/gives_poison"),
        GIVES_REGEN(NameSpace.MOD, "conduit_effects/gives_regen"),
        GIVES_RESISTANCE(NameSpace.MOD, "conduit_effects/gives_resistance"),
        GIVES_SLOW_FALL(NameSpace.MOD, "conduit_effects/gives_slow_fall"),
        GIVES_SLOWNESS(NameSpace.MOD, "conduit_effects/gives_slowness"),
        GIVES_SPEED(NameSpace.MOD, "conduit_effects/gives_speed"),
        GIVES_STRENGTH(NameSpace.MOD, "conduit_effects/gives_strength"),
        GIVES_WATER_BREATHING(NameSpace.MOD, "conduit_effects/gives_water_breathing"),
        GIVES_WEAKNESS(NameSpace.MOD, "conduit_effects/gives_weakness"),
        GIVES_WEAVING(NameSpace.MOD, "conduit_effects/gives_weaving"),
        GIVES_WIND(NameSpace.MOD, "conduit_effects/gives_wind"),
        GIVES_WITHER(NameSpace.MOD, "conduit_effects/gives_wither"),
        GIVES_SATURATION(NameSpace.MOD, "conduit_effects/gives_saturation"),
        SETS_ON_FIRE(NameSpace.MOD, "conduit_effects/sets_on_fire"),
        FAN_PROCESSING_CATALYSTS_CHANNELING(NameSpace.MOD, "fan_processing_catalysts/channeling");

        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;

        private CAAFluidTags() {
            this(NameSpace.MOD);
        }

        private CAAFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CAAFluidTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CAAFluidTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CAAFluidTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? CAATags.optionalTag(BuiltInRegistries.FLUID, id) : FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Fluid fluid) {
            return fluid.is(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NameSpace {
        MOD("create_aquatic_ambitions", false, true),
        COMMON("c"),
        CREATE("create");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

