/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks.blockentities;

import com.pedrorok.hypertube.HypertubeMod;
import com.pedrorok.hypertube.blocks.HyperAcceleratorBlock;
import com.pedrorok.hypertube.blocks.HypertubeBlock;
import com.pedrorok.hypertube.blocks.blockentities.ActionTubeBlockEntity;
import com.pedrorok.hypertube.config.ServerConfig;
import com.pedrorok.hypertube.core.connection.TubeConnectionException;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.core.sound.TubeSoundManager;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.kinetics.base.IRotate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class HyperAcceleratorBlockEntity
extends ActionTubeBlockEntity
implements IHaveHoveringInformation {
    private final UUID tubeSoundId = UUID.randomUUID();
    private IConnection connectionOne;
    private IConnection connectionTwo;

    public HyperAcceleratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (compound.contains("ConnectionOne")) {
            this.connectionOne = this.getConnection(compound, "ConnectionOne");
        }
        if (compound.contains("ConnectionTwo")) {
            this.connectionTwo = this.getConnection(compound, "ConnectionTwo");
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        this.writeConnection(compound, new Tuple[]{new Tuple((Object)this.connectionOne, (Object)"ConnectionOne"), new Tuple((Object)this.connectionTwo, (Object)"ConnectionTwo")});
    }

    @Override
    public boolean wrenchClicked(Direction direction) {
        IConnection connectionInDirection = this.getConnectionInDirection(direction);
        if (connectionInDirection == null) {
            return false;
        }
        connectionInDirection.updateTubeSegments(this.level);
        return true;
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            this.tickClient();
            return;
        }
        BlockState state = this.getBlockState();
        BlockPos pos = this.getBlockPos();
        float actualSpeed = Math.abs(this.getSpeed());
        Boolean isOpen = (Boolean)state.getValue((Property)HyperAcceleratorBlock.OPEN);
        LivingEntity nearbyEntity = this.getNearbyLivingEntities((ServerLevel)this.level, pos.getCenter());
        boolean canOpen = nearbyEntity != null && nearbyEntity.getPersistentData().getBoolean("hypertube_travel");
        this.isTubeClosed(canOpen, isOpen);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient() {
        float actualSpeed = Math.abs(this.getSpeed());
        TubeSoundManager.TubeAmbientSound sound = TubeSoundManager.getAmbientSound(this.tubeSoundId);
        if (actualSpeed < 16.0f) {
            sound.tickClientPlayerSounds();
            return;
        }
        this.playClientEffects(sound);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        float finalSpeed = Math.abs(this.getSpeed());
        boolean hasNeededSpeed = finalSpeed < 16.0f;
        IRotate.SpeedLevel.getFormattedSpeedText((float)this.speed, (boolean)hasNeededSpeed).forGoggles(tooltip);
        if (hasNeededSpeed) {
            tooltip.add((Component)Component.literal((String)"     ").append((Component)Component.literal((String)"\u2592 ")).append((Component)Component.translatable((String)"tooltip.create_hypertube.entrance_no_speed")).withColor(0xFF0000));
        } else {
            MutableComponent literalTooltip = Component.literal((String)"     ");
            literalTooltip = literalTooltip.append((Component)((Boolean)this.getBlockState().getValue((Property)HyperAcceleratorBlock.ACCELERATE) != false ? Component.translatable((String)"block.hypertube.hyper_accelerator.accelerate_mode").withColor(0xFFFF00) : Component.translatable((String)"block.hypertube.hyper_accelerator.brake_mode").withColor(0xFF8800)));
            tooltip.add((Component)literalTooltip);
        }
        return true;
    }

    @Override
    public List<IConnection> getConnections() {
        ArrayList<IConnection> connections = new ArrayList<IConnection>();
        if (this.connectionOne != null) {
            connections.add(this.connectionOne);
        }
        if (this.connectionTwo != null) {
            connections.add(this.connectionTwo);
        }
        return connections;
    }

    @Override
    public void setConnection(IConnection connection, Direction thisConnectionDir) {
        BlockState blockState;
        Block block;
        if (this.connectionOne == null) {
            this.connectionOne = connection;
        } else if (this.connectionTwo == null) {
            this.connectionTwo = connection;
        } else {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not define connection", connection, this.connectionOne, this.connectionTwo).getMessage());
            return;
        }
        if (this.level != null && !this.level.isClientSide() && (block = (blockState = this.level.getBlockState(this.worldPosition)).getBlock()) instanceof HypertubeBlock) {
            HypertubeBlock hypertubeBlock = (HypertubeBlock)block;
            hypertubeBlock.updateBlockStateFromEntity(blockState, this.level, this.worldPosition);
            if (thisConnectionDir != null) {
                BlockState state = hypertubeBlock.getState(blockState, List.of(thisConnectionDir), true);
                hypertubeBlock.updateBlockState(this.level, this.worldPosition, state);
            }
        }
        this.setChanged();
        this.sync();
    }

    @Override
    public void clearConnection(IConnection connection) {
        if (this.connectionOne != null && this.connectionOne.isSameConnection(connection)) {
            this.connectionOne = null;
        } else if (this.connectionTwo != null && this.connectionTwo.isSameConnection(connection)) {
            this.connectionTwo = null;
        } else {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not be cleared", connection, this.connectionOne, this.connectionTwo).getMessage());
            return;
        }
        this.setChanged();
        this.sync();
    }

    @Override
    protected int getConnectionCount() {
        return 2;
    }

    public void onSpeedChanged(float previousSpeed) {
        this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)HyperAcceleratorBlock.ACTIVE, (Comparable)Boolean.valueOf(Math.abs(this.getSpeed()) >= 16.0f)), 3);
    }

    @Override
    public void remove() {
        super.remove();
        if (this.level.isClientSide) {
            TubeSoundManager.TubeAmbientSound sound = TubeSoundManager.getAmbientSound(this.tubeSoundId);
            sound.stopSound();
        }
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)ServerConfig.get().STRESS_IMPACT_ACCELERATOR.getAsDouble();
        return impact;
    }

    public IConnection getConnectionOne() {
        return this.connectionOne;
    }

    public IConnection getConnectionTwo() {
        return this.connectionTwo;
    }
}

