/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.config;

import com.pedrorok.hypertube.core.travel.TravelConstants;
import com.pedrorok.hypertube.utils.TubeUtils;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfig {
    public static final ModConfigSpec SPEC;
    private static final ServerConfig INSTANCE;
    public final ModConfigSpec.BooleanValue ALLOW_FISH_TO_TRAVEL;
    public final ModConfigSpec.BooleanValue ALLOW_VILLAGER_TO_TRAVEL;
    public final ModConfigSpec.DoubleValue SPEED_MULTIPLIER;
    public final ModConfigSpec.DoubleValue STRESS_IMPACT_ENTRANCE;
    public final ModConfigSpec.DoubleValue STRESS_IMPACT_ACCELERATOR;

    private ServerConfig(ModConfigSpec.Builder builder) {
        builder.comment("Change these settings to customize the server-side behavior of the mod.").push("Travel Settings");
        this.ALLOW_FISH_TO_TRAVEL = builder.comment("Allow fish to go through the tubes. (experimental)").define("allowFishTravel", true);
        this.ALLOW_VILLAGER_TO_TRAVEL = builder.comment("Allow villagers to go through the tubes.").define("allowVillagerTravel", true);
        this.SPEED_MULTIPLIER = builder.comment("Multiplier for the speed of the tubes. Default is 1.0, which is normal speed. (THIS IS HIGHLY EXPERIMENTAL)").defineInRange("speedMultiplier", 1.0, 0.5, 99.0);
        builder.pop();
        builder.comment("Stress Settings").push("Stress Settings");
        this.STRESS_IMPACT_ENTRANCE = builder.comment("Stress impact of the Hyper Entrance block.").defineInRange("entranceStressImpact", 4.0, 0.0, 100.0);
        this.STRESS_IMPACT_ACCELERATOR = builder.comment("Stress impact of the Hyper Accelerator block.").defineInRange("acceleratorStressImpact", 4.0, 0.0, 100.0);
        builder.pop();
    }

    public static ServerConfig get() {
        return INSTANCE;
    }

    public void init() {
        if (!((Boolean)this.ALLOW_FISH_TO_TRAVEL.get()).booleanValue()) {
            TravelConstants.TRAVELLER_ENTITIES.remove(EntityType.SALMON);
            TravelConstants.TRAVELLER_ENTITIES.remove(EntityType.COD);
            TravelConstants.TRAVELLER_ENTITIES.remove(EntityType.TROPICAL_FISH);
        }
        if (!((Boolean)this.ALLOW_VILLAGER_TO_TRAVEL.get()).booleanValue()) {
            TravelConstants.TRAVELLER_ENTITIES.remove(EntityType.VILLAGER);
            TravelConstants.TRAVELLER_ENTITIES.remove(EntityType.WANDERING_TRADER);
        }
        TubeUtils.SPEED_MULTIPLIER = ((Double)this.SPEED_MULTIPLIER.get()).floatValue();
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        INSTANCE = (ServerConfig)pair.getLeft();
        SPEC = (ModConfigSpec)pair.getRight();
    }
}

