/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.content.components;

import com.oierbravo.create_mechanical_spawner.ModLang;
import com.oierbravo.create_mechanical_spawner.content.components.SpawnerPointDisplay;
import com.oierbravo.create_mechanical_spawner.content.components.collector.LootCollectorBlock;
import com.oierbravo.create_mechanical_spawner.content.components.collector.LootCollectorBlockEntity;
import com.oierbravo.create_mechanical_spawner.content.components.recipe.SpawnerRecipe;
import com.oierbravo.create_mechanical_spawner.foundation.utility.LivingEntityHelper;
import com.oierbravo.create_mechanical_spawner.infrastructure.config.MConfigs;
import com.oierbravo.create_mechanical_spawner.registrate.ModBlockEntities;
import com.oierbravo.create_mechanical_spawner.registrate.ModRecipes;
import com.oierbravo.mechanicals.compat.jade.IHavePercent;
import com.oierbravo.mechanicals.foundation.blockEntity.behaviour.DynamicCycleBehavior;
import com.oierbravo.mechanicals.foundation.blockEntity.behaviour.RecipeRequirementsBehaviour;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeWithRequirements;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class SpawnerBlockEntity
extends KineticBlockEntity
implements DynamicCycleBehavior.DynamicCycleBehaviorSpecifics,
RecipeRequirementsBehaviour.RecipeRequirementsSpecifics<SpawnerRecipe>,
IHavePercent {
    public UUID owner;
    protected DeployerFakePlayer player;
    DynamicCycleBehavior dynamicCycleBehaviour;
    ScrollValueBehaviour scrollValueBehaviour;
    public SmartFluidTankBehaviour inputTank;
    public RecipeRequirementsBehaviour<SpawnerRecipe> recipeRequirementsBehaviour;

    public SpawnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void initialize() {
        super.initialize();
        this.initHandler();
    }

    private void initHandler() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            this.player = new DeployerFakePlayer(sLevel, this.owner);
            Vec3 initialPos = VecHelper.getCenterOf((Vec3i)this.worldPosition.relative((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)));
            this.player.setPos(initialPos.x, initialPos.y, initialPos.z);
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        int max = (Integer)MConfigs.server().spawner.maxRange.get();
        this.inputTank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)((Integer)MConfigs.server().spawner.fluidCapacity.get()));
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        this.scrollValueBehaviour = new ScrollValueBehaviour((Component)ModLang.translate("spawner.scrollValue.label", new Object[0]).component(), (SmartBlockEntity)this, (ValueBoxTransform)new SpawnPointValuePositioning()).between(1, max);
        this.scrollValueBehaviour.value = 1;
        behaviours.add((BlockEntityBehaviour)this.scrollValueBehaviour);
        this.dynamicCycleBehaviour = new DynamicCycleBehavior((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.dynamicCycleBehaviour);
        this.recipeRequirementsBehaviour = new RecipeRequirementsBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.recipeRequirementsBehaviour);
    }

    public ScrollValueBehaviour getScrollValueBehavior() {
        return this.scrollValueBehaviour;
    }

    public Optional<SpawnerRecipe> getRecipe() {
        return ModRecipes.findSpawner(this.inputTank.getPrimaryHandler().getFluid(), this.level);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean addedRequirements;
        SpawnerPointDisplay.display(this);
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.getProgressPercent() > 0) {
            ModLang.translate("spawner.tooltip.progress", this.getProgressPercent()).style(ChatFormatting.YELLOW).forGoggles(tooltip);
            added = true;
        }
        if (this.isSpawnPosBlockLootCollector()) {
            ModLang.translate("spawner.tooltip.with_loot_collector", new Object[0]).style(ChatFormatting.GREEN).forGoggles(tooltip);
            added = true;
        }
        if (!this.inputTank.isEmpty()) {
            this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)this.inputTank.getPrimaryHandler());
            added = true;
        }
        if (addedRequirements = this.recipeRequirementsBehaviour.addToGoggleTooltip(tooltip, isPlayerSneaking, added)) {
            added = true;
        }
        return added;
    }

    private BlockPos getSpawnPos() {
        return this.getBlockPos().relative(Direction.Axis.Y, this.scrollValueBehaviour.getValue());
    }

    private boolean isSpawnableBlockPos() {
        if (this.level != null && this.level.getBlockState(this.getSpawnPos()).getBlock() == Blocks.AIR) {
            return true;
        }
        return this.isSpawnPosBlockLootCollector();
    }

    private boolean isSpawnPosBlockLootCollector() {
        assert (this.level != null);
        BlockEntity spawnPosBlockEntity = this.level.getBlockEntity(this.getSpawnPos());
        if (spawnPosBlockEntity == null) {
            return false;
        }
        if (((Boolean)MConfigs.server().spawner.allowAnyContainerForLootCollector.get()).booleanValue()) {
            @Nullable IItemHandler cap = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.getSpawnPos(), (Object)Direction.DOWN);
            return cap != null;
        }
        if (this.level.getBlockState(this.getSpawnPos()).getBlock() instanceof ItemVaultBlock && ((Boolean)MConfigs.server().spawner.allowCreateItemVaultForLootCollector.get()).booleanValue()) {
            return true;
        }
        return this.level.getBlockState(this.getSpawnPos()).getBlock() instanceof LootCollectorBlock;
    }

    public void showParticles() {
        if (!this.isSpeedRequirementFulfilled()) {
            return;
        }
        Vec3 offset = new Vec3(0.0, 0.0, 0.0);
        Vec3 center = offset.add(VecHelper.getCenterOf((Vec3i)this.worldPosition));
        assert (this.level != null);
        this.level.addParticle((ParticleOptions)ParticleTypes.POOF, center.x, center.y, center.z, 0.0, 0.01, 0.0);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntities.MECHANICAL_SPAWNER.get(), (be, context) -> be.inputTank.getCapability());
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public FluidTank getInputTank() {
        return this.inputTank.getPrimaryHandler();
    }

    public int getScrollValueBehaviour() {
        return this.scrollValueBehaviour.getValue();
    }

    public List<BlockPos> getSpawnBlockPosition(Direction forcedMovement, boolean visualize) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int position = visualize ? this.scrollValueBehaviour.getValue() : this.getScrollValueBehaviour();
        BlockPos current = this.worldPosition.relative(Direction.Axis.Y, position);
        positions.add(current);
        return positions;
    }

    public List<SpawnerBlockEntity> collectSpawnGroup() {
        return new ArrayList<SpawnerBlockEntity>();
    }

    private void fillCollector(Level pLevel, SpawnerRecipe pSpawnerRecipe, BlockPos pSpawnPos) {
        IItemHandler lootCollectorInventoryHandler;
        assert (this.level != null);
        if (pLevel.isClientSide) {
            return;
        }
        BlockEntity lootCollector = this.level.getBlockEntity(pSpawnPos);
        int lootLevel = 0;
        if (lootCollector instanceof LootCollectorBlockEntity) {
            LootCollectorBlockEntity lootCollectorBlockEntity = (LootCollectorBlockEntity)lootCollector;
            lootLevel = lootCollectorBlockEntity.getLootingLevel();
        }
        if ((lootCollectorInventoryHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, pSpawnPos, (Object)Direction.DOWN)) == null) {
            return;
        }
        if (((Boolean)MConfigs.server().spawner.customLootPerSpawnRecipeEnabled.get()).booleanValue() && !pSpawnerRecipe.getCustomLoot().isEmpty()) {
            this.fillCollectorWithCustomLoot(lootCollectorInventoryHandler, pSpawnerRecipe);
        } else {
            this.fillCollectorWithMobLoot(lootCollectorInventoryHandler, pSpawnerRecipe, pSpawnPos, lootLevel);
        }
        lootCollector.setChanged();
    }

    protected void fillCollectorWithCustomLoot(IItemHandler pLootCollectorInventory, SpawnerRecipe pSpawnerRecipe) {
        List<ItemStack> customLootStack = pSpawnerRecipe.rollCustomLoot();
        for (ItemStack itemStack : customLootStack) {
            ItemHandlerHelper.insertItem((IItemHandler)pLootCollectorInventory, (ItemStack)itemStack, (boolean)false);
        }
    }

    protected void fillCollectorWithMobLoot(IItemHandler pLootCollectorInventory, SpawnerRecipe pSpawnerRecipe, BlockPos pSpawnPos, int lootingLevel) {
        Entity entitySpawn = LivingEntityHelper.createEntity((ServerLevel)this.level, pSpawnerRecipe.getOutput().getMob(), pSpawnPos);
        if (!(entitySpawn instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entitySpawn;
        List<ItemStack> list = LivingEntityHelper.getLootFromMob((ServerLevel)this.level, (Entity)mob, pSpawnPos, this.getPlayer(), lootingLevel);
        for (ItemStack itemStack : list) {
            ItemHandlerHelper.insertItem((IItemHandler)pLootCollectorInventory, (ItemStack)itemStack, (boolean)false);
        }
    }

    public int getProgressPercent() {
        return this.dynamicCycleBehaviour.getProgressPercent();
    }

    public DeployerFakePlayer getPlayer() {
        return this.player;
    }

    public float getKineticSpeed() {
        return this.getSpeed();
    }

    public int getProcessingTime() {
        if (this.getRecipe().isEmpty()) {
            return 1;
        }
        return (int)((double)this.getRecipe().get().getProcessingTime() * (Double)MConfigs.server().spawner.timeMultiplier.get());
    }

    private boolean checkRequirements(SpawnerRecipe recipe) {
        if (!this.isSpawnPosBlockLootCollector()) {
            return false;
        }
        return recipe == null || recipe.getFluidAmount() <= this.inputTank.getPrimaryHandler().getFluidAmount();
    }

    public boolean tryProcess(boolean simulate) {
        if (!this.isSpeedRequirementFulfilled()) {
            return false;
        }
        Optional<SpawnerRecipe> optionalSpawnerRecipe = this.getRecipe();
        if (optionalSpawnerRecipe.isEmpty()) {
            this.recipeRequirementsBehaviour.cleanRequirements();
            return false;
        }
        SpawnerRecipe spawnerRecipe = optionalSpawnerRecipe.get();
        if (!this.recipeRequirementsBehaviour.checkRequirements((IRecipeWithRequirements)spawnerRecipe)) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (this.level != null && this.level.isClientSide()) {
            return true;
        }
        this.inputTank.getPrimaryHandler().drain(spawnerRecipe.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
        if (this.isSpawnPosBlockLootCollector()) {
            this.fillCollector(this.level, spawnerRecipe, this.getSpawnPos());
        } else {
            LivingEntityHelper.spawnLivingEntity(this.level, spawnerRecipe.getMob(), this.getSpawnPos());
        }
        return true;
    }

    public boolean hasEnoughOutputSpace(SpawnerRecipe spawnerRecipe) {
        return this.isSpawnableBlockPos();
    }

    public boolean matchesIngredients(SpawnerRecipe spawnerRecipe) {
        if (this.inputTank.getPrimaryHandler().getFluidAmount() < spawnerRecipe.getFluidAmount()) {
            return false;
        }
        return spawnerRecipe.getFluidIngredient().test(this.inputTank.getPrimaryHandler().getFluid());
    }

    public static class SpawnPointValuePositioning
    extends ValueBoxTransform.Sided {
        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction != Direction.UP && direction != Direction.DOWN;
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)16.0);
        }
    }
}

